% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNTCalculation.R
\name{RM2NNT}
\alias{RM2NNT}
\title{Calculate the NNT based on the restricted mean survival times between
 the treatment and control groups}
\usage{
RM2NNT(time, status, arm, tau = NULL, confint = 0.95, digits = 3)
}
\arguments{
\item{time}{The time to event or censor.}

\item{status}{The indicator of the event or censor at the end of the follow-up.}

\item{arm}{The variable indicates the treatment (arm = 1) and control (arm = 0) groups.}

\item{tau}{The chosen time point of clinical interest.}

\item{confint}{The percentile of confidence interval. The default value is
\code{confint = 0.95}.}

\item{digits}{The decimal of the results. The default value is \code{digits = 3}.}
}
\value{
A matrix contains the RMST-NNT and its confidence interval.
}
\description{
For survival endpoints, the NNT-RMST is defined as the RMST in
  the control group divided by the difference in RMSTs between the treatment
  and control groups up to a chosen time \code{t}.
}
\examples{
library(survival)
dat <- pbc[!is.na(pbc$trt),]
time <- dat$time/365.25
status <- (dat$status == 2) + 0
arm <- (dat$trt == 2) + 0
RM2NNT(time, status, arm, tau = NULL, confint = 0.95, digits = 3)

}
\references{
1. An alternative approach for estimating the number needed to treat for survival endpoints.
 PLoS One. 2019 Oct 18;14(10):e0223301. doi: 10.1371/journal.pone.0223301.
}
