% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_events.R
\name{map_events}
\alias{map_events}
\title{Map storm events for a date range}
\usage{
map_events(
  event_data,
  states = "east",
  plot_type = "any events",
  storm = NULL,
  add_tracks = FALSE
)
}
\arguments{
\item{event_data}{A dataframe of event data, as returned by the \code{find_events}
function.}

\item{states}{A character string specifying either a state name or names or one of
"all" (map all states in the continental US) or "east" (plot states in the
Eastern half of the US. The default is "east".}

\item{plot_type}{Specifies the type of plot wanted. It can be "any
events", "number of events", "direct deaths", "indirect deaths",
"direct injuries", "indirect injuries", "property damage", or "crop damage".}

\item{storm}{A character string with the name of the storm to pull storm
events data for. This string must follow the format
"[storm-name]-[4-digit storm year]" (e.g., \code{"Floyd-1999"}).
Currently, this functionality only works for storms included in the
extended hurricane best tracks, which covers 1988 to 2015.}

\item{add_tracks}{A logical value specifying whether to add the tracks of
a hurricane to the map (default = FALSE).}
}
\description{
This function maps all storm events listed with a starting date within a
specified date range.
}
\note{
Indirect deaths and injuries seem to be reported very rarely, so it is
   likely that trying to map either of these outcomes will result in a note that
   no indirect deaths / injuries were reported for the selected events.
}
\examples{
\dontrun{
# Map for events pulled by a date range
event_data <- find_events(date_range = c("1999-09-10", "1999-09-30"))
map_events(event_data)
map_events(event_data, plot_type = "number of events")

# Map for a specific type of event
event_data <- find_events(date_range = c("1999-09-10", "1999-09-30"),
                          event_types = c("Flood","Flash Flood"))
map_events(event_data, states = "north carolina", plot_type = "number of events")
map_events(event_data, states = "all")

# Map for events identified based on a hurricane storm track
event_data <- find_events(storm = "Floyd-1999", dist_limit = 300)
map_events(event_data, plot_type = "number of events",
           storm = "Floyd-1999", add_tracks = TRUE)
map_events(event_data, plot_type = "crop damage",
           storm = "Floyd-1999", add_tracks = TRUE,
           states = c("north carolina", "virginia", "maryland"))
map_events(event_data, plot_type = "property damage",
           storm = "Floyd-1999", add_tracks = TRUE)
map_events(event_data, plot_type = "direct deaths")

event_data <- find_events(date_range = c("1999-01-01", "1999-12-31"))
map_events(event_data, plot_type = "direct deaths")
map_events(event_data, plot_type = "indirect deaths")
map_events(event_data, plot_type = "direct injuries")
map_events(event_data, plot_type = "indirect injuries")
map_events(event_data, plot_type = "crop damage")
}

}
