% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VEMalgorithm.R
\name{fitNSBM}
\alias{fitNSBM}
\title{VEM algorithm to adjust the noisy stochastic block model to an observed dense adjacency matrix}
\usage{
fitNSBM(
  dataMatrix,
  model = "Gauss0",
  sbmSize = list(Qmin = 1, Qmax = NULL, explor = 1.5),
  filename = NULL,
  initParam = list(nbOfTau = NULL, nbOfPointsPerTau = NULL, maxNbOfPasses = NULL,
    minNbOfPasses = 1),
  nbCores = parallel::detectCores()
)
}
\arguments{
\item{dataMatrix}{observed dense adjacency matrix}

\item{model}{Implemented models:
\describe{
  \item{\code{Gauss}}{all Gaussian parameters of the null and the alternative distributions are unknown ; this is the Gaussian model with maximum number of unknown parameters}
  \item{\code{Gauss0}}{compared to \code{Gauss}, the mean of the null distribution is set to 0}
  \item{\code{Gauss01}}{compared to \code{Gauss}, the null distribution is set to N(0,1)}
  \item{\code{GaussEqVar}}{compared to \code{Gauss}, all Gaussian variances (of both the null and the alternative) are supposed to be equal, but unknown}
  \item{\code{Gauss0EqVar}}{compared to \code{GaussEqVar}, the mean of the null distribution is set to 0}
  \item{\code{Gauss0Var1}}{compared to \code{Gauss}, all Gaussian variances are set to 1 and the null distribution is set to N(0,1)}
  \item{\code{Gauss2distr}}{the alternative distribution is a single Gaussian distribution, i.e. the block memberships of the nodes do not influence on the alternative distribution}
  \item{\code{GaussAffil}}{compared to \code{Gauss}, for the alternative distribution, there's a distribution for inter-group and another for intra-group interactions}
  \item{\code{Exp}}{the null and the alternatives are all exponential distributions (i.e. Gamma distributions with shape parameter equal to one)  with unknown scale parameters}
  \item{\code{ExpGamma}}{the null distribution is an unknown exponential, the alterantive distribution are Gamma distributions with unknown parameters}
}}

\item{sbmSize}{list of parameters determining the size of SBM (the number of latent blocks) to be expored
\describe{
  \item{\code{Qmin}}{minimum number of latent blocks}
  \item{\code{Qmax}}{maximum number of latent blocks}
  \item{\code{explor}}{if \code{Qmax} is not provided, then \code{Qmax} is automatically determined as \code{explor} times the number of blocks where the ICL is maximal}
}}

\item{filename}{results are saved in a file with this name (if provided)}

\item{initParam}{list of parameters that fix the number of initializations
\describe{
  \item{\code{nbOfTau}}{number of initial points for the node clustering (i. e. for the variational parameters \code{tau})}
  \item{\code{nbOfPointsPerTau}}{number of initial points of the latent binary graph}
  \item{\code{maxNbOfPasses}}{maximum number of passes through the SBM models, that is, passes from \code{Qmin} to \code{Qmax} or inversely}
  \item{\code{minNbOfPasses}}{minimum number of passes through the SBM models}
}}

\item{nbCores}{number of cores used for parallelization}
}
\value{
Returns a list of estimation results for all numbers of latent blocks considered by the algorithm.
Every element is a list composed of:
\describe{
  \item{\code{theta}}{estimated parameters of the noisy stochastic block model; a list with the following elements:
  \describe{
    \item{\code{pi}}{parameter estimate of pi}
    \item{\code{w}}{parameter estimate of w}
    \item{\code{nu0}}{parameter estimate of nu0}
    \item{\code{nu}}{parameter estimate of nu}
   }}
  \item{\code{clustering}}{node clustering obtained by the noisy stochastic block model, more precisely, a hard clustering given by the
  maximum aposterior estimate of the variational parameters \code{sbmParam$edgeProba}}
  \item{\code{sbmParam}}{further results concerning the latent binary stochastic block model. A list with the following elements:
  \describe{
    \item{\code{Q}}{number of latent blocks in the noisy stochastic block model}
    \item{\code{clusterProba}}{soft clustering given by the conditional probabilities of a node to belong to a given latent block.
    In other words, these are the variational parameters \code{tau}; (Q x n)-matrix}
    \item{\code{edgeProba}}{conditional probabilities \code{rho} of an edges given the node memberships of the interacting nodes; (N_Q x N)-matrix}
    \item{\code{ICL}}{value of the ICL criterion at the end of the algorithm}
    }}
  \item{\code{convergence}}{a list of convergence indicators:
  \describe{
    \item{\code{J}}{value of the lower bound of the log-likelihood function at the end of the algorithm}
    \item{\code{complLogLik}}{value of the complete log-likelihood function at the end of the algorithm}
    \item{\code{converged}}{indicates if algorithm has converged}
    \item{\code{nbIter}}{number of iterations performed}
 }}
}
}
\description{
\code{fitNSBM()} estimates model parameters of the noisy stochastic block model and provides a clustering of the nodes
}
\details{
\code{fitNSBM()} supports different probability distributions for the edges and can estimate the number of node blocks
}
\examples{
n <- 10
theta <- list(pi= c(0.5,0.5), nu0=c(0,.1),
       nu=matrix(c(-2,10,-2, 1,1,1),3,2),  w=c(.5, .9, .3))
obs <- rnsbm(n, theta, modelFamily='Gauss')
res <- fitNSBM(obs$dataMatrix, sbmSize = list(Qmax=3),
       initParam=list(nbOfTau=1, nbOfPointsPerTau=1), nbCores=1)
}
