% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_private_keys.R
\name{save_private_keys}
\alias{save_private_keys}
\title{Create a place to store API keys}
\usage{
save_private_keys(api_var = NULL, key = NULL,
  name_of_outputted_object = "api_keys", file = "~/r_keychain.rds")
}
\arguments{
\item{api_var}{The name of the api key, this is user defined.}

\item{key}{The actual key.}

\item{name_of_outputted_object}{This is a convenience option, put in the name of the object you are assigning the output of the function to.}

\item{file}{The name and location of the file where you want to store it. Default is unix home.}
}
\description{
This function will look for a 'keychain' file with your keys at the place you tell it to look with the
file parameter. If it doesn't find it, it will make one.
}
\details{
This function WILL NOT actually save the file. Instead, it will return a dataframe with the keys,
and give you the code to save the file to your system.

The intended use is store API keys in the home space.
}
\section{Intended use}{

Save variables in a way that can automatically get read in by my other functions in this package.
For the hue lights the variables I expect to see in api_var are  "hue_ip" and "hue_username", while
for pushover, the variables I expect to see are "pushover_userkey" and "pushover_apitoken".

See the example for a use example.
}

\section{Bugs}{

Code repo: \url{https://github.com/epijim/notifyme}
}
\examples{
\dontrun{api_keys <- save_private_keys("new_key","THE KEY")}
\dontrun{# message returned is Run this code: saveRDS(api_keys, '~/r_keychain.rds')}
\dontrun{saveRDS(api_keys, '~/r_keychain.rds')}
}
\keyword{Hue}
\keyword{R}
\keyword{notify}
\keyword{storekeys}

