#' fixColumnNames changes original column names and into standardized names.
#'
## Copyright(c) 2017-2020 R. Mark Sharp
## This file is part of nprcgenekeepr
#'
#' @return A list object with \code{newColNames} and \code{errorLst} with
#' a record of all changes made.
#'
#' @examples
#' \donttest{
#' library(nprcgenekeepr)
#' fixColumnNames(c("Sire_ID", "EGO", "DAM", "Id", "birth_date"),
#'                errorLst = getEmptyErrorLst())
#' }
#'
#' @param orgCols character vector with ordered list of column names
#' found in a pedigree file.
#' @param errorLst list object with places to store the various column
#' name changes.
#' @export
fixColumnNames <- function(orgCols, errorLst) {
  cols <- tolower(orgCols)
  errorLst$changedCols$caseChange <- colChange(orgCols, cols)
  newCols <- gsub(" ", "", cols)
  errorLst$changedCols$spaceRemoved <- colChange(cols, newCols)
  cols <- newCols
  newCols <- gsub("\\.", "", cols)
  errorLst$changedCols$periodRemoved <- colChange(cols, newCols)
  cols <- newCols
  newCols <- gsub("_", "", cols)
  errorLst$changedCols$underScoreRemoved <- colChange(cols, newCols)
  cols <- newCols
  newCols <- gsub("egoid", "id", cols)
  errorLst$changedCols$egoidToId <- colChange(cols, newCols)
  cols <- newCols
  newCols <- gsub("ego", "id", cols)
  errorLst$changedCols$egoToId <- colChange(cols, newCols)
  cols <- newCols
  newCols <- gsub("sireid", "sire", cols)
  errorLst$changedCols$sireIdToSire <- colChange(cols, newCols)
  cols <- newCols
  newCols <- gsub("damid", "dam", cols)
  errorLst$changedCols$damIdToDam <- colChange(cols, newCols)
  cols <- newCols
  newCols <- gsub("birthdate", "birth", cols)
  errorLst$changedCols$birthdateToBirth <- colChange(cols, newCols)
  cols <- newCols
  newCols <- gsub("deathdate", "death", cols)
  errorLst$changedCols$deathdateToDeath <- colChange(cols, newCols)
  cols <- newCols
  newCols <- gsub("recordstatus", "recordStatus", newCols)
  errorLst$changedCols$recordstatusToRecordStatus <- colChange(cols, newCols)
  cols <- newCols
  newCols <- gsub("fromcenter", "fromCenter", newCols)
  errorLst$changedCols$fromcenterToFromCenter <- colChange(cols, newCols)
  cols <- newCols
  newCols <- gsub("geographicorigin", "geographicOrigin", newCols)
  errorLst$changedCols$geographicoriginToGeographicOrigin <-
    colChange(cols, newCols)
  list(newColNames = newCols, errorLst = errorLst)
}
