% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGVPopulation.R
\name{getGVPopulation}
\alias{getGVPopulation}
\title{Get the population of interest for the Genetic Value analysis.}
\usage{
getGVPopulation(ped, pop)
}
\arguments{
\item{ped}{the pedigree information in datatable format}

\item{pop}{character vector with animal IDs to consider as the population of
interest. The default is NULL.}
}
\value{
A logical vector corresponding to the IDs in the vector of
animal IDs provided to the function in \code{pop}.
}
\description{
If user has limited the population of interest by defining \code{pop},
that information is incorporated via the \code{ped$population} column.
}
\examples{
\donttest{
## Example from Analysis of Founder Representation in Pedigrees: Founder
## Equivalents and Founder Genome Equivalents.
## Zoo Biology 8:111-123, (1989) by Robert C. Lacy
library(nprcgenekeepr)
ped <- data.frame(
id = c("A", "B", "C", "D", "E", "F", "G"),
sire = c(NA, NA, "A", "A", NA, "D", "D"),
dam = c(NA, NA, "B", "B", NA, "E", "E"),
stringsAsFactors = FALSE
)
ped["gen"] <- findGeneration(ped$id, ped$sire, ped$dam)
ped$population <- getGVPopulation(ped, NULL)
}
}
