% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getProbandPedigree.R
\name{getProbandPedigree}
\alias{getProbandPedigree}
\title{Gets pedigree to ancestors of provided group leaving uninformative ancestors.}
\usage{
getProbandPedigree(probands, ped)
}
\arguments{
\item{probands}{a character vector with the list of animals whose ancestors
should be included in the final pedigree.}

\item{ped}{datatable that is the `Pedigree`. It contains pedigree
information. The fields \code{sire} and \code{dam} are required.}
}
\value{
A reduced pedigree.
}
\description{
Filters a pedigree down to only the ancestors of the provided group,
removing unnecessary individuals from the studbook. This version builds
the pedigree back in time starting from a group of probands. This will
include all ancestors of the probands, even ones that might be
uninformative.
}
\examples{
\donttest{
library(nprcgenekeepr)
ped <- nprcgenekeepr::pedWithGenotype
ids <- nprcgenekeepr::qcBreeders
sires <- getPotentialSires(ids, minAge = 1, ped)
head(getProbandPedigree(probands = sires, ped = ped))
}

}
