% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsave.R
\name{gsave}
\alias{gsave}
\title{gsave}
\usage{
gsave(x,x.new,y,ytype,ex,ey,comx,comy,r)
}
\arguments{
\item{x}{input predictor matrix from training set}

\item{x.new}{input predictor matrix from testing set}

\item{y}{response variables}

\item{ytype}{type of response variables}

\item{ex}{tuning parameter for the Tychonoff reguralized inverse for GX}

\item{ey}{tuning parameter for the Tychonoff reguralized inverse for GY}

\item{comx}{tuning parameter for the Gaussian kernel in X}

\item{comy}{tuning parameter for the Gaussian kernel in Y}

\item{r}{number of dimension}
}
\value{
pred: sufficient predictors from GSAVE

obj.mat: objective matrix of GSAVE

eig.val: the first r eigenvalues from the eigendecomposition of the objective matrix

eig.vec: the first r eigenvectors from the eigendecomposition of the objective matrix
}
\description{
gsave
}
\examples{
n = 50; p = 5; sigma = 1;
x = matrix(rnorm(n*p),n,p) ; err = rnorm(n)
y = x[,1]/(0.5+(x[,1]+1)^2) + sigma*err; ex=0.01 ; ey=0.01
gsave_res <- gsave(x,x,y,"scalar",ex,ey,1,1,1)
}
\references{
Li, B. (2018). Sufficient dimension reduction: Methods and applications with R. CRC Press.
}
