% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plot.gppack}
\alias{plot.gppack}
\title{Plots several GP's simultaneously}
\usage{
\method{plot}{gppack}(x, y = NULL, plotdata = TRUE, plotmeans = TRUE,
  plotcovs = TRUE, plotnoises = FALSE, plotnull = FALSE,
  plotratios = "emll", thr = 1, samples = 0, sigma = 2, title = NULL,
  legend = FALSE, plotgradient = TRUE, ...)
}
\arguments{
\item{x}{the \code{gppack}-object}

\item{y}{placeholder variable}

\item{plotdata}{plot the data (default)}

\item{plotmeans}{plot the GP mean (default)}

\item{plotcovs}{plot the GP covariances (default)}

\item{plotnoises}{plot the observational noise (default)}

\item{plotnull}{plots also the null model}

\item{plotratios}{plots the ratios, choices are \code{emll}, \code{mll}, \code{npc}, \code{pc}}

\item{thr}{ratio threshold}

\item{samples}{plot N samples from the GP}

\item{sigma}{variance level to plot}

\item{title}{plot title}

\item{legend}{plot legend}

\item{plotgradient}{use gradient graphics}

\item{...}{...}
}
\description{
Plots the GP's corresponding to the control and case data,
 as well as the null model. Visualizes the log likelihood ratios between
 the null and individual models. Several boolean parameters for modifying
 the plot. By default plots the data, posterior mean and 95\% interval for
 CASE and CONTROL.
}
\details{
The threshold \code{thr} is the logarithmic likelihood ratio between
 null and control+case models. The default value 1 hence corresponds to
 a likelihood ratio of 2.72.
}
\examples{
# read toy data
data(toydata)

\dontrun{can take several minutes
# perform two-sample regression
res = gpr2sample(toydata$ctrl$x, toydata$ctrl$y, toydata$case$x, toydata$case$y, seq(0,22,0.1))

# pre-computed model for toydata
data(toygps)
res = toygps

# basic plot
plot(res)

# plot also the null model, don't plot data, means or noise
plot(res, plotnull=TRUE, plotdata=FALSE, plotmeans=FALSE, plotnoise=FALSE)}
}

