% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draw_rects.R
\name{draw_rects}
\alias{draw_rects}
\title{Draw NSP intervals of significance as shaded rectangular areas on the current plot}
\usage{
draw_rects(nsp.obj, yrange, density = 10, col = "red", x.axis.start = 1)
}
\arguments{
\item{nsp.obj}{Object returned by one of the \code{nsp*} functions.}

\item{yrange}{Vector of length two specifying the (lower, upper) vertical limit of the rectangles.}

\item{density}{Density of the shading.}

\item{col}{Colour of the shading.}

\item{x.axis.start}{Time index the x axis starts from. The NSP intervals of significance get shifted by \code{x.axis.start-1} prior to plotting.}
}
\value{
The function does not return a value.
}
\description{
This function draws intervals of significance returned by one of the \code{nsp*} functions on the current plot. It shows them as shaded
rectangular areas (hence the name of the function).
}
\details{
The NSP algorithm is described in P. Fryzlewicz (2021) "Narrowest Significance Pursuit: inference for multiple change-points in linear
models", preprint.
}
\examples{
set.seed(1)
h <- c(rep(0, 150), 1:150)
x.h <- h + stats::rnorm(300) * 50
x.h.n <- nsp_poly(x.h, 1000, "sim", deg=1)
draw_rects(x.h.n, c(-100, 100))
}
\seealso{
\code{\link{draw_rects_advanced}}, \code{\link{nsp}}
}
\author{
Piotr Fryzlewicz, \email{p.fryzlewicz@lse.ac.uk}
}
