% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spots_combined.R
\name{spots.combined}
\alias{spots.combined}
\title{Find spots using information from two channels}
\usage{
spots.combined(
  red,
  green,
  mask,
  size = NULL,
  voxelsize = NULL,
  thresh.offset = 0.1,
  window = c(5, 5),
  min.sum.intensity = 2,
  max.distance = 0.5,
  use.brightest = FALSE,
  max.spots = NA,
  full.voxel = FALSE
)
}
\arguments{
\item{red}{image}

\item{green}{image}

\item{mask}{image mask}

\item{size}{size of img in microns}

\item{voxelsize}{size of voxel in microns}

\item{thresh.offset}{Thresh offset used in EBImage::thresh()}

\item{window}{Half width and height of the moving rectangular window.}

\item{min.sum.intensity}{spots smaller than min.sum.intensity are ignored}

\item{max.distance}{use only spots with distance to other color spot smaller than max.distance}

\item{use.brightest}{Logical; use only brightest in max.distance?}

\item{max.spots}{maximum of spots (per channel), only when use brightest=TRUE}

\item{full.voxel}{Logical; output contains full voxel instead of rgb intensities}
}
\value{
RGB image with spots will be written to output folder
}
\description{
Find spots using information from two channels
}
