% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/altitude_azimuth_distance.R
\name{altitude_azimuth_distance}
\alias{altitude_azimuth_distance}
\title{Calculate the altitude, azimuth and distance of B from A}
\usage{
altitude_azimuth_distance(a, b)
}
\arguments{
\item{a}{the observer position: a vector of longitude, latitude (in decimal degrees) and
altitude (in meters) in WGS84}

\item{b}{the observed position: a vector of longitude, latitude (in decimal degrees) and
altitude (in meters) in WGS84}
}
\value{
the coordinates in North-East-Up of the observed, B, with respect to the
        observer A.
        A vector of \href{https://en.wikipedia.org/wiki/Horizontal_coordinate_system}{altitude}
        (elevation from the horizon) in decimal degrees,
        \href{https://en.wikipedia.org/wiki/Azimuth}{azimuth}) in decimal degrees and
        distance in meters.
}
\description{
The altitude (elevation from the horizon), azimuth and distance of a point B from A
are the coordinates of the Topocentric Coordinate System as typically used in astronomy to
aim your telescope to a heavenly body.
It can be also of use to know where an airplane is in the sky with respect to an observer
on Earth.
}
\examples{
\dontrun{
# sensor (longitude, latitude, altitude)
a <- c(49.47, 7.697, 274)
# aircraft (longitude, latitude, altitude)
b <- c(49.52, 7.803, 6401)
altitude_azimuth_distance(a, b)
}
}
\seealso{
Other utilities: 
\code{\link{along_track_distance}()},
\code{\link{cross_track_distance}()},
\code{\link{cross_track_intersection}()}
}
\concept{utilities}
