% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{[[<-,ctd-method}
\alias{[[<-,ctd-method}
\title{Replace Parts of a ctd Object}
\usage{
\S4method{[[}{ctd}(x, i, j, ...) <- value
}
\arguments{
\item{x}{a \linkS4class{ctd} object.}

\item{i}{character value naming the item to replace.}

\item{j}{optional additional information on the \code{i} item.}

\item{...}{optional additional information (ignored).}

\item{value}{The value to be placed into \code{x}, somewhere.}
}
\description{
The \code{[[<-} method works for all \linkS4class{oce} objects.
The purpose, as with the related extraction method, \code{[[},
is to insulate users from the internal details of \linkS4class{oce}
objects, by looking for items within the various storage
slots of the object. Items not actually stored can also be
replaced, including units and data-quality
flags.
}
\details{
As with \code{[[} method, the procedure works in steps.

First, the \code{metadata} slot of \code{x} is checked to
see whether it contains something named with \code{i}.
If so, then the named item is replaced with \code{value}.

Otherwise, if the string value of \code{i} ends in \code{Unit}, then the
characters preceding that are taken as the name of a variable, and
the \code{metadata} slot of \code{x} is updated to store that unit, e.g.\preformatted{x[["temperatureUnits"]] <- list(unit=expression(degree*F),scale="")
}

Similarly, if \code{i} ends in \code{Flag}, then quality-control
flags are set up as defined by \code{result}, e.g.\preformatted{o[["temperatureFlags"]] <- c(2,4,2,2)
}

Otherwise, \code{\link[=pmatch]{pmatch()}} is used for a partial-string match with
the names of the items that are in the \code{data} slot of \code{x}.
The first item found (if any) is then updated to hold the value \code{result}.

If none of these conditions is met, a warning is issued.
}
\examples{
data(ctd)
summary(ctd)
# Move the CTD profile a nautical mile north.
ctd[["latitude"]] <- 1/60 + ctd[["latitude"]] # acts in metadata
# Increase the salinity by 0.01.
ctd[["salinity"]] <- 0.01 + ctd[["salinity"]] # acts in data
summary(ctd)

}
\seealso{
Other functions that replace parts of oce objects: 
\code{\link{[[<-,adp-method}},
\code{\link{[[<-,amsr-method}},
\code{\link{[[<-,argo-method}},
\code{\link{[[<-,bremen-method}},
\code{\link{[[<-,cm-method}},
\code{\link{[[<-,coastline-method}},
\code{\link{[[<-,echosounder-method}},
\code{\link{[[<-,g1sst-method}},
\code{\link{[[<-,gps-method}},
\code{\link{[[<-,ladp-method}},
\code{\link{[[<-,landsat-method}},
\code{\link{[[<-,lisst-method}},
\code{\link{[[<-,lobo-method}},
\code{\link{[[<-,met-method}},
\code{\link{[[<-,oce-method}},
\code{\link{[[<-,odf-method}},
\code{\link{[[<-,rsk-method}},
\code{\link{[[<-,sealevel-method}},
\code{\link{[[<-,section-method}},
\code{\link{[[<-,tidem-method}},
\code{\link{[[<-,topo-method}},
\code{\link{[[<-,windrose-method}},
\code{\link{[[<-,xbt-method}}

Other things related to ctd data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{[[,ctd-method}},
\code{\link{as.ctd}()},
\code{\link{cnvName2oceName}()},
\code{\link{ctd-class}},
\code{\link{ctd.cnv}},
\code{\link{ctdDecimate}()},
\code{\link{ctdFindProfiles}()},
\code{\link{ctdRaw}},
\code{\link{ctdRepair}()},
\code{\link{ctdTrim}()},
\code{\link{ctd_aml.csv}},
\code{\link{ctd}},
\code{\link{d200321-001.ctd}},
\code{\link{d201211_0011.cnv}},
\code{\link{handleFlags,ctd-method}},
\code{\link{initialize,ctd-method}},
\code{\link{initializeFlagScheme,ctd-method}},
\code{\link{oceNames2whpNames}()},
\code{\link{oceUnits2whpUnits}()},
\code{\link{plot,ctd-method}},
\code{\link{plotProfile}()},
\code{\link{plotScan}()},
\code{\link{plotTS}()},
\code{\link{read.ctd.itp}()},
\code{\link{read.ctd.odf}()},
\code{\link{read.ctd.odv}()},
\code{\link{read.ctd.sbe}()},
\code{\link{read.ctd.woce.other}()},
\code{\link{read.ctd.woce}()},
\code{\link{read.ctd}()},
\code{\link{setFlags,ctd-method}},
\code{\link{subset,ctd-method}},
\code{\link{summary,ctd-method}},
\code{\link{woceNames2oceNames}()},
\code{\link{woceUnit2oceUnit}()},
\code{\link{write.ctd}()}
}
\concept{functions that replace parts of oce objects}
\concept{things related to ctd data}
