% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OLLL-G.R
\name{OLLLG}
\alias{OLLLG}
\alias{polllg}
\alias{dolllg}
\alias{qolllg}
\alias{rolllg}
\alias{holllg}
\title{Odd log-logistic logarithmic family of distributions (OLLL-G)}
\usage{
polllg(x, alpha = 1, beta = 0.1, G = pnorm, ...)

dolllg(x, alpha = 1, beta = 0.1, G = pnorm, ...)

qolllg(q, alpha = 1, beta = 0.1, G = pnorm, ...)

rolllg(n, alpha = 1, beta = 0.1, G = pnorm, ...)

holllg(x, alpha = 1, beta = 0.1, G = pnorm, ...)
}
\arguments{
\item{x}{scaler or vector of values at which the pdf or cdf needs to be computed.}

\item{alpha}{the value of the first shape parameter, must be positive, the default is 1.}

\item{beta}{the value of the second shape parameter, between 0 and 1, the default is 0.1.}

\item{G}{A baseline continuous cdf.}

\item{...}{The baseline cdf parameters.}

\item{q}{scaler or vector of probabilities at which the quantile needs to be computed.}

\item{n}{number of random numbers to be generated.}
}
\value{
\code{polllg} gives the distribution function,
 \code{dolllg} gives the density,
 \code{qolllg} gives the quantile function,
 \code{holllg} gives the hazard function and
 \code{rolllg} generates random variables from the Odd log-logistic logarithmic family of
 distributions (OLLL-G) for baseline cdf G.
}
\description{
Computes the pdf, cdf, hdf, quantile and random numbers of the beta extended distribution due to Haghbin et al. (2017) specified by the pdf
\deqn{f=\frac{\alpha\beta\,g\,G^{\alpha-1}\bar{G}^{\alpha-1}}{-[G^\alpha+\bar{G}^\alpha][(1-\beta)\,G^\alpha+\bar{G}^\alpha]\log(1-\beta)}}
for \eqn{G} any valid continuous cdf , \eqn{\bar{G}=1-G}, \eqn{g} the corresponding pdf,  \eqn{\alpha > 0}, the first shape parameter, and \eqn{0 < \beta < 1}, the second shape parameter.
}
\examples{
x <- seq(0, 1, length.out = 21)
polllg(x)
polllg(x, alpha = 2, beta = .2, G = pbeta, shape1 = 1, shape2 = 2)

dolllg(x, alpha = 2, beta = .2, G = pbeta, shape1 = 1, shape2 = 2)
curve(dolllg, -3, 3)
qolllg(x, alpha = 2, beta = .2, G = pbeta, shape1 = 1, shape2 = 2)
n <- 10
rolllg(n, alpha = 2, beta = .2, G = pbeta, shape1 = 1, shape2 = 2)
holllg(x, alpha = 2, G = pbeta, beta = .2, shape1 = 1, shape2 = 2)
curve(holllg, -3, 3)
}
\references{
Alizadeh, M., MirMostafee, S. M. T. K., Ortega, E. M., Ramires, T. G., Cordeiro, G. M. (2017). The odd log-logistic logarithmic generated family of distributions with applications in different areas. Journal of Statistical Distributions and Applications, 4(1), 1-25.
}
