% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_summ_route.R
\name{get_summ_route}
\alias{get_summ_route}
\title{Get Summary Route Information}
\usage{
get_summ_route(
  token,
  start,
  end,
  route,
  date = Sys.Date(),
  time = format(Sys.time(), format = "\%T"),
  mode = NULL,
  max_dist = NULL
)
}
\arguments{
\item{token}{User's API token. This can be retrieved using \code{\link{get_token}}}

\item{start}{Vector of c(lat, lon) coordinates for the route start point}

\item{end}{Vector of c(lat, lon) coordinates for the route end point}

\item{route}{Type of route. Accepted values are \code{walk}, \code{drive}, \code{pt} (public transport), or \code{cycle}}

\item{date}{Default = current date. Date for which route is requested.}

\item{time}{Default = current time. Time for which route is requested.}

\item{mode}{Required if \code{route = "pt"}. Accepted values are \code{transit}, \code{bus} or \code{rail}}

\item{max_dist}{Optional if \code{route = "pt"}. Maximum walking distance}
}
\value{
If no error occurs, a tibble of 1 x 2 with the variables:
\describe{
  \item{total_time}{The total time taken for this route}
  \item{total_dist}{The total distance travelled for this route}
}

If an error occurs, the output will be \code{NA}, along with a warning message.
}
\description{
This function is a wrapper for the \href{https://docs.onemap.sg/#route}{Route Service API}. It is similar to \code{\link{get_route}}, except it returns a tibble with only total time and total distance, and also optionally, the start coordinates and end coordinates.
If \code{route = "pt"}, only the best route is chosen (i.e. \code{n_itineraries = 1}).
}
