% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vxapply.R
\name{vxapply}
\alias{vxapply}
\alias{vlapply}
\alias{viapply}
\alias{vnapply}
\alias{vcapply}
\alias{vzapply}
\alias{vrapply}
\title{Specialised vapply methods for atomic classes}
\usage{
vlapply(X, FUN, ..., USE.NAMES = TRUE)

viapply(X, FUN, ..., USE.NAMES = TRUE)

vnapply(X, FUN, ..., USE.NAMES = TRUE)

vcapply(X, FUN, ..., USE.NAMES = TRUE)

vzapply(X, FUN, ..., USE.NAMES = TRUE)

vrapply(X, FUN, ..., USE.NAMES = TRUE)
}
\arguments{
\item{X, ..., USE.NAMES}{See \link{vapply}}

\item{FUN}{Either a function to apply to each element of \code{X}, as in \link{vapply}
or the field/method name of an OOP object (see examples)}
}
\description{
Specialised \code{vapply} functions for scalars of each of the six atomic classes
in R:
}
\details{
\itemize{
\item logical (\code{vlapply})
\item integer (\code{viapply})
\item numeric/real (\code{vnapply})
\item character/string (\code{vcapply})
\item complex (\code{vzapply})
\item raw (\code{vrapply})
}

These are simply wrappers around \link{vapply} where \code{FUN.VALUE} is pre-filled
with a scalar of the given class.

In addition these can be applied to pull-out fields or methods from R6 or
other OOP objects by supplying the field/method name to \code{FUN}. See examples.
}
\examples{
## Specialised vapply
vlapply(logical(10), identity)
vzapply(complex(10), identity)

## For R6 objects
objs <- list(ooplah$new(), ooplah$new())

# Public field
vcapply(objs, "oop")

# Public method
vcapply(objs, "exclaim", "ARGH")
vcapply(objs, "hello")
vnapply(objs, "generate", 1)

# Active binding
vlapply(objs, "logically")
}
