/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.FileInputStream;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.sentdetect.SentenceSampleStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.PlainTextByLineStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SentenceSampleStreamFactory
extends AbstractSampleStreamFactory<SentenceSample> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(SentenceSample.class, "opennlp", new SentenceSampleStreamFactory(Parameters.class));
    }

    protected <P> SentenceSampleStreamFactory(Class<P> params) {
        super(params);
    }

    @Override
    public ObjectStream<SentenceSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        CmdLineUtil.checkInputFile("Data", params.getData());
        FileInputStream sampleDataIn = CmdLineUtil.openInFile(params.getData());
        PlainTextByLineStream lineStream = new PlainTextByLineStream(sampleDataIn.getChannel(), params.getEncoding());
        return new SentenceSampleStream(lineStream);
    }

    static interface Parameters
    extends BasicFormatParams {
    }
}

