% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_flag.R
\name{is_flag}
\alias{is_flag}
\alias{which.flag}
\title{Determine if/which vector element are options flags}
\usage{
is_flag(x)

which.flag(x)
}
\arguments{
\item{x}{vector of options, for example \code{commandArgs()}.}
}
\value{
logical. indicating which arguments are flags.

numeric
}
\description{
Determines if an element of a vector is an option flag (as opposed to a 
value ) by checking against the option style
}
\details{
\code{is_flag} and \code{which.flag} are internal functions not
expected to be called directly.

They are  used to identify which elements of the option vector are
option names (as opposed to option values). Options are identified by
\code{getOptions('optigrab')$style$flag_test}. By defailt, \strong{optigrab}
follows GNU-style command line arguments, i.e. those beginning with
"--" or "-" and are set at the time of package loading.
}
\examples{
  optigrab:::is_flag( c( "--foo", "bar") )
  optigrab:::is_flag( c( "--foo", "bar", "-f", "-b", "text" ) )
  
  optigrab:::which.flag( c( "--foo", "bar") )
  optigrab:::which.flag( c( "--foo", "bar", "-f", "-b", "text" ))

}
