% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optim_refit.R
\name{optim_refit}
\alias{optim_refit}
\title{Refined optimization test.}
\usage{
optim_refit(xsol, fun, maximize = TRUE, maxit = 5000, reltol = 1e-08,
  xopt)
}
\arguments{
\item{xsol}{Potential solution vector of length \code{nx}.}

\item{fun}{Objective function to be maximized (or minimized), with first argument the length-\code{nx} parameter vector over which optimization is to take place.  Should return a scalar result.}

\item{maximize}{Logical, whether a maximum or a minimum of the objective function is sought.}

\item{maxit}{Maximum number of iterations for \code{\link[stats]{optim}} refit (see Details).}

\item{reltol}{Relative tolerance for convergence of \code{\link[stats]{optim}} refit (see Details).}

\item{xopt}{Optional refit solution calculated externally from an optimization algorithm of choice (see Details).}
}
\value{
An object of class \code{optrefit} inheriting from \code{optcheck}, with elements:
\describe{
  \item{\code{xsol}}{The potential solution.}
  \item{\code{ysol}}{The value of \code{fun(xsol)}.}
  \item{\code{maximize}}{Logical indicating whether the potential solution should maximize or minimize the objective function.}
  \item{\code{xopt}}{The solution found by the general-purpose optimizer.}
  \item{\code{yopt}}{The function value at the optimal solution, i.e., \code{fun(xopt)}.}
}
}
\description{
If the potential solution is indeed a local optimum of the objective function, and if it is used to initialize a second optimization, then original and "refined" solutions ought to be close.
}
\details{
By default, a so-called **refi**ned op(**t**)imization (or refit) test is performed by running the default Nelder-Mead simplex method provided by \code{\link[stats]{optim}}, initialized by the potential solution \code{xsol}.  Only a simplified interface to \code{\link[stats]{optim}}'s control parameters are provided here.

Alternatively, the refit test can be performed with any optimization algorithm of choice.  This is done externally, with the refined solution passed to \code{optim_refit} via the argument \code{xopt}.
}
\seealso{
\code{summary}, \code{print}, and \code{diff} for \code{optrefit} objects are available; see \code{\link{summary.optrefit}}, \code{\link{print.optrefit}}, and \code{\link{diff.optrefit}}.
}
