% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcPerformance.R
\name{calcPerformance}
\alias{calcPerformance}
\title{Attach portfolio performance and distance to target}
\usage{
calcPerformance(x)
}
\arguments{
\item{x}{An optimized optimLanduse object.}
}
\value{
An optimized optimLanduse object with attached portfolio performance.
}
\description{
The function calculates and attaches the portfolio performance.
For a comprehensive interpretation the beta values have to be grouped by
their indicator in a plot  (see example).
Each beta describes the relative proportion to the maximum achievable
(the "target") within its indicator, given the current land use distribution
and the uncertainty scenario set. The lowest beta of all indicators
guarantees that under a worst-case scenario, at least this proportion will be
achieved across all indicators. The solveScenario() function maximizes the
guaranteed performance, or minimizes the distance to the maximum possible.
}
\details{
For further information see the supplement of Gosling et al (2020), Formula S5 (in the supplement of the paper).
}
\examples{
require(ggplot2)
require(readxl)

dat <- read_xlsx(exampleData("exampleGosling.xlsx"))
init <- initScenario(dat, uValue = 2,
                     optimisticRule = "expectation",
                     fixDistance = 3)
result <- solveScenario(x = init)
performance <- calcPerformance(result)

# Visualize the distance

ggplot(performance$scenarioTable,
       aes(x = indicator,
           y = performance,
           color = indicator)) +
geom_point() +
geom_hline(yintercept =
           min(performance$scenarioTable$performance),
          linetype = "dashed", color = "red") +
ylim(0, 1)
}
\references{
Gosling, E., Reith, E., Knoke T., Gerique, A., Paul, C. (2020): Exploring
farmer perceptions of agroforestry via multi-objective optimisation: a test application
in Eastern Panama. \emph{Agroforestry Systems} \strong{94}. \doi{10.1007/s10457-020-00519-0}
}
