% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/osm-structures.R
\name{osm_structures}
\alias{osm_structures}
\title{osm_structures}
\usage{
osm_structures(
  structures = c("building", "amenity", "waterway", "grass", "natural", "park",
    "highway", "boundary", "tree"),
  col_scheme = "dark"
)
}
\arguments{
\item{structures}{The vector of types of structures (defaults listed in
\code{\link{extract_osm_objects}}).}

\item{col_scheme}{Colour scheme for the plot (current options include
\code{dark} and \code{light}).}
}
\value{
\code{data.frame} of structures, \code{key-value} pairs,
corresponding prefixes, and colours.
}
\description{
For the given vector of structure types returns a \code{data.frame}
containing two columns of corresponding OpenStreetMap \code{key-value} pairs,
one column of unambiguous suffixes to be appended to the objects returned by
\code{\link{extract_osm_objects}}, and one column specifying colours. This
\code{data.frame} may be subsequently modified as desired, and ultimately
passed to \code{\link{make_osm_map}} to automate map production.
}
\examples{
# Default structures:
osm_structures ()
# user-defined structures:
structures <- c ("highway", "park", "ameniiy", "tree")
structs <- osm_structures (structures = structures, col_scheme = "light")
# make_osm_map returns potentially modified list of data
\dontrun{
dat <- make_osm_map (osm_data = london, structures = structs)
# map contains updated $osm_data and actual map in $map
print_osm_map (dat$map)
}
}
\seealso{
\code{\link{make_osm_map}}.
}
