% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/categorical.R
\name{PlotBarplot}
\alias{PlotBarplot}
\title{Creates a bar plot for a discrete (or binary) variable}
\usage{
PlotBarplot(dataFl, myVar, weightNm = NULL)
}
\arguments{
\item{dataFl}{A \code{data.table} of data; must be the output of the
\code{\link{PrepData}} function.}

\item{myVar}{The name of the variable to be plotted}

\item{weightNm}{Name of the variable containing row weights, or \code{NULL} for 
no weights (all rows receiving weight 1).}
}
\value{
A \code{ggplot} object with a histogram of \code{myVar} ordered by 
  category frequency
}
\description{
Creates a bar plot for a discrete (or binary) variable
}
\section{License}{

Copyright 2017 Capital One Services, LLC Licensed under the Apache License,
Version 2.0 (the "License"); you may not use this file except in compliance
with the License. You may obtain a copy of the  License at
http://www.apache.org/licenses/LICENSE-2.0 Unless required by applicable law
or agreed to in writing, software distributed under the License is 
distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY 
KIND, either express or implied. See the License for the specific language 
governing permissions and limitations under the License.
}

\examples{
data(bankData)
bankData = PrepData(bankData, dateNm = "date", dateGp = "months", 
                    dateGpBp = "quarters", weightNm = NULL)
PlotBarplot(bankData, "job")

## NA will be included as a category if any NA are present
bankData[sample.int(.N)[1:1000], education := NA]
PlotBarplot(bankData, "education")
}
\seealso{
Functions depend on this function:
         \code{\link{PlotCatVar}}.

This function depends on:
         \code{\link{PrepData}}.
}
