% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_model_functions.R
\name{transition_cost_util}
\alias{transition_cost_util}
\title{Create the the values of cost and utility while transition}
\usage{
transition_cost_util(
  no_states,
  tmat_cost_util,
  list_values,
  name_states = NULL
)
}
\arguments{
\item{no_states}{number of the health states}

\item{tmat_cost_util}{A transition matrix for the cost/utility
values in the format from the package 'mstate' use NA to indicate
if the value is zero}

\item{list_values}{list of probabilities as in the order of transitions
(row wise)}

\item{name_states}{names of the health states}
}
\value{
value of the transition matrix
}
\description{
Create the the values of cost and utility while transition
}
\details{
Similar to transition matrix but for denoting one time change
during transitions
}
\examples{
tmat_cost <- rbind(c(NA, 1), c(NA, NA))
colnames(tmat_cost) <- rownames(tmat_cost) <- c("Healthy", "Dead")
transition_cost_util(2, tmat_cost, list_values = c(500))
}
