% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kdffreq.R
\name{plot.kdffreq}
\alias{plot.kdffreq}
\title{plot.kdffreq}
\usage{
\method{plot}{kdffreq}(
  x,
  ylim = NULL,
  xlim = NULL,
  main = NULL,
  xlab = "Age",
  ylab = "FF (#.yr-1)",
  frame = T,
  ...
)
}
\arguments{
\item{x}{Object returned by kdffreq}

\item{ylim}{Numeric, y axis limits}

\item{xlim}{Numeric x axis limits}

\item{main}{char, title of plot}

\item{xlab}{char, x axis legend}

\item{ylab}{char, y axis legend}

\item{frame}{frame around plot}

\item{...}{other arguments}
}
\description{
Plot fire frequency calculated using the \code{\link[paleofire]{kdffreq}} function
}
\seealso{
\code{\link[paleofire]{kdffreq}}
 @examples

 set.seed(123)
 fevent=c(round(abs(rnorm(20,mean=7,sd=5))*1000),round(abs(rnorm(10,mean=8,sd=1))*1000))

 ff=kdffreq(fevent,bandwidth = 1000, nbboot=10)
 plot(ff)
}
