% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/informationtheory_based.R
\docType{methods}
\name{variationOfInformation}
\alias{variationOfInformation}
\alias{variationOfInformation,Partition,Partition-method}
\title{Variation of Information}
\usage{
variationOfInformation(p, q)

\S4method{variationOfInformation}{Partition,Partition}(p, q)
}
\arguments{
\item{p}{The partition \eqn{P}}

\item{q}{The partition \eqn{Q}}
}
\description{
Compute the variation of information 
\deqn{H(P) + H(Q) - 2MI(P, Q)}
where \eqn{MI} is the mutual information, \eqn{H} the partition entropy
}
\section{Methods (by class)}{
\itemize{
\item \code{p = Partition,q = Partition}: Compute given two partitions
}}

\examples{
isTRUE(all.equal(variationOfInformation(new("Partition", c(0, 0, 0, 1, 1)),
                                        new("Partition", c(0, 0, 1, 1, 1))),
                                        0.763817))

}
\references{
\insertRef{Meila2003}{partitionComparison}

\insertRef{Meila2007}{partitionComparison}
}
\seealso{
\code{\link{mutualInformation}}, \code{\link{entropy}}
}
\author{
Fabian Ball \email{fabian.ball@kit.edu}
}
