% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path-chain.R
\name{path_link}
\alias{path_link}
\title{Creates a link of path chain - a directory or a file}
\usage{
path_link(node = NULL, children = NULL)
}
\arguments{
\item{node}{Current node name; character}

\item{children}{list of children - path_chains}
}
\value{
path_chain object
}
\description{
It returns basic package's object: an object representing a link in the chain.
Each link has the path_chain class - it can represents a one-element path chain
}
\examples{
# If we want to create our chain manually, we have start from the leaves
level2.b <- path_link("fileA.RData")
level2.a <- path_link("fileB.RData")
level1   <- path_link("data", list(level2.a = level2.a , level2.b = level2.b))
root     <- path_link("files", list(level1))
# Print root path
root$.
# Print file path using chaining
root$data$level2.a
}
