% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.sens.R
\name{plot.sens}
\alias{plot.sens}
\title{Plot Method for \code{sens} Objects}
\usage{
\method{plot}{sens}(
  x,
  outcome_name = "Outcome",
  x_axis = c("eta_k", "gamma_k"),
  other = list(`eta_k-1` = NULL, `gamma_k-1` = NULL),
  ...
)
}
\arguments{
\item{x}{an object of class \code{sens} returned by the \code{\link{sens}}
function}

\item{outcome_name}{a character string indicating the name of the outcome.}

\item{x_axis}{sensitivity analysis parameter shown on the x axis. Default is \code{"eta_k"},
i.e., the difference in the prevalence of an unobserved confounder \eqn{U} between treated
and untreated units given pretreatment covariates \eqn{X} and mediators \eqn{M_1,\ldots, M_k}.
Alternatively, it can be \code{"gamma_k"}, i.e., the average effect of the unobserved confounder
\eqn{U} on the outcome given pretreatment covariates \eqn{X}, treatment \eqn{A},
and mediators \eqn{M_1,\ldots, M_k}.}

\item{other}{a named list indicating the values at which other sensitivity analysis parameters,
namely, \code{`eta_k-1`} and \code{`gamma_k-1`}, are held. This is needed only when the
bias formula involves \eqn{\eta_{k-1}} and \eqn{\gamma_{k-1}} as well as \eqn{\eta_k} and
\eqn{\gamma_k}. The default is to set both \eqn{\eta_{k-1}} and \eqn{\gamma_{k-1}} at their
average values in the \code{sens} object.}

\item{...}{additional arguments}
}
\value{
a \code{ggplot2} plot, which can be further customized by the user.
}
\description{
Contour plot for sensitivity analysis objects.
}
\examples{
data(tatar)

m1 <- c("trust_g1", "victim_g1", "fear_g1")
m2 <- c("trust_g2", "victim_g2", "fear_g2")
m3 <- c("trust_g3", "victim_g3", "fear_g3")
mediators <- list(m1, m2, m3)

formula_m0 <- annex ~ kulak + prosoviet_pre + religiosity_pre + land_pre +
  orchard_pre + animals_pre + carriage_pre + otherprop_pre + violence
formula_m1 <- update(formula_m0,    ~ . + trust_g1 + victim_g1 + fear_g1)
formula_m2 <- update(formula_m1,    ~ . + trust_g2 + victim_g2 + fear_g2)
formula_m3 <- update(formula_m2,    ~ . + trust_g3 + victim_g3 + fear_g3)
formula_ps <- violence ~ kulak + prosoviet_pre + religiosity_pre +
  land_pre + orchard_pre + animals_pre + carriage_pre + otherprop_pre

####################################################
# Causal Paths Analysis using GLM
####################################################

# outcome models
glm_m0 <- glm(formula_m0, family = binomial("logit"), data = tatar)
glm_m1 <- glm(formula_m1, family = binomial("logit"), data = tatar)
glm_m2 <- glm(formula_m2, family = binomial("logit"), data = tatar)
glm_m3 <- glm(formula_m3, family = binomial("logit"), data = tatar)
glm_ymodels <- list(glm_m0, glm_m1, glm_m2, glm_m3)

# propensity score model
glm_ps <- glm(formula_ps, family = binomial("logit"), data = tatar)

# causal paths analysis using glm
# note: For illustration purposes only a small number of bootstrap replicates are used
paths_glm <- paths(a = "violence", y = "annex", m = mediators,
  glm_ymodels, ps_model = glm_ps, data = tatar, nboot = 3)

# sensitivity analysis for the path-specific effect via M1
sens_glm <- sens(paths_glm, confounded = "M1", estimand = "via M1",
  gamma_values = - seq(0, 0.5, 0.005), eta_values = seq(-0.5, 0.5, 0.005))

plot(sens_glm)

}
