% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytical_functions.R
\name{get_3d_angle}
\alias{get_3d_angle}
\title{Compute an angle in 3D space}
\usage{
get_3d_angle(x1, y1, z1, x2, y2, z2, x3, y3, z3)
}
\arguments{
\item{x1}{x-coordinate of first point}

\item{y1}{y-coordinate of first point}

\item{z1}{z-coordinate of first point}

\item{x2}{x-coordinate of second point (vertex)}

\item{y2}{y-coordinate of second point (vertex)}

\item{z2}{y-coordinate of second point (vertex)}

\item{x3}{x-coordinate of third point}

\item{y3}{y-coordinate of third point}

\item{z3}{z-coordinate of third point}
}
\value{
A numeric vector that provides the angular measurement in degrees.
}
\description{
Compute an angle in 3D space
}
\details{
Everything supplied to arguments must be singular numeric values.
The second point (x2, y2, z2) is treated as the vertex, and the angle between
the three points in 3D space is computed.
}
\examples{
get_3d_angle(
  0, 1, 0,
  0, 0, 0,
  1, 0, 0)
}
\seealso{
Other mathematical functions: 
\code{\link{calc_min_dist_v}()},
\code{\link{deg_2_rad}()},
\code{\link{find_curve_elbow}()},
\code{\link{get_2d_angle}()},
\code{\link{get_3d_cross_prod}()},
\code{\link{get_dist_point_line}()},
\code{\link{get_velocity}()},
\code{\link{rad_2_deg}()}
}
\author{
Vikram B. Baliga
}
\concept{mathematical functions}
