% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytical_functions.R
\name{get_3d_cross_prod}
\alias{get_3d_cross_prod}
\title{Compute the cross product of two 3D vectors}
\usage{
get_3d_cross_prod(v1, v2)
}
\arguments{
\item{v1}{First vector, as c(x,y,z)}

\item{v2}{Second vector, as c(x,y,z)}
}
\value{
A vector of length 3 that describes the cross-product
}
\description{
Compute the cross product of two 3D vectors
}
\examples{
v1 <- c(1, 1, 3)
v2 <- c(3, 1, 3)
get_3d_cross_prod(v1, v2)
}
\seealso{
Other mathematical functions: 
\code{\link{calc_min_dist_v}()},
\code{\link{deg_2_rad}()},
\code{\link{find_curve_elbow}()},
\code{\link{get_2d_angle}()},
\code{\link{get_3d_angle}()},
\code{\link{get_dist_point_line}()},
\code{\link{get_velocity}()},
\code{\link{rad_2_deg}()}
}
\author{
Vikram B. Baliga
}
\concept{mathematical functions}
