% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elasticbeanstalk_operations.R
\name{elasticbeanstalk_create_environment}
\alias{elasticbeanstalk_create_environment}
\title{Launches an AWS Elastic Beanstalk environment for the specified
application using the specified configuration}
\usage{
elasticbeanstalk_create_environment(ApplicationName, EnvironmentName,
  GroupName, Description, CNAMEPrefix, Tier, Tags, VersionLabel,
  TemplateName, SolutionStackName, PlatformArn, OptionSettings,
  OptionsToRemove, OperationsRole)
}
\arguments{
\item{ApplicationName}{[required] The name of the application that is associated with this environment.}

\item{EnvironmentName}{A unique name for the environment.

Constraint: Must be from 4 to 40 characters in length. The name can
contain only letters, numbers, and hyphens. It can't start or end with a
hyphen. This name must be unique within a region in your account. If the
specified name already exists in the region, Elastic Beanstalk returns
an \code{InvalidParameterValue} error.

If you don't specify the \code{CNAMEPrefix} parameter, the environment name
becomes part of the CNAME, and therefore part of the visible URL for
your application.}

\item{GroupName}{The name of the group to which the target environment belongs. Specify a
group name only if the environment's name is specified in an environment
manifest and not with the environment name parameter. See \href{https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html}{Environment Manifest (env.yaml)}
for details.}

\item{Description}{Your description for this environment.}

\item{CNAMEPrefix}{If specified, the environment attempts to use this value as the prefix
for the CNAME in your Elastic Beanstalk environment URL. If not
specified, the CNAME is generated automatically by appending a random
alphanumeric string to the environment name.}

\item{Tier}{Specifies the tier to use in creating this environment. The environment
tier that you choose determines whether Elastic Beanstalk provisions
resources to support a web application that handles HTTP(S) requests or
a web application that handles background-processing tasks.}

\item{Tags}{Specifies the tags applied to resources in the environment.}

\item{VersionLabel}{The name of the application version to deploy.

Default: If not specified, Elastic Beanstalk attempts to deploy the
sample application.}

\item{TemplateName}{The name of the Elastic Beanstalk configuration template to use with the
environment.

If you specify \code{TemplateName}, then don't specify \code{SolutionStackName}.}

\item{SolutionStackName}{The name of an Elastic Beanstalk solution stack (platform version) to
use with the environment. If specified, Elastic Beanstalk sets the
configuration values to the default values associated with the specified
solution stack. For a list of current solution stacks, see \href{https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html}{Elastic Beanstalk Supported Platforms}
in the \emph{AWS Elastic Beanstalk Platforms} guide.

If you specify \code{SolutionStackName}, don't specify \code{PlatformArn} or
\code{TemplateName}.}

\item{PlatformArn}{The Amazon Resource Name (ARN) of the custom platform to use with the
environment. For more information, see \href{https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html}{Custom Platforms}
in the \emph{AWS Elastic Beanstalk Developer Guide}.

If you specify \code{PlatformArn}, don't specify \code{SolutionStackName}.}

\item{OptionSettings}{If specified, AWS Elastic Beanstalk sets the specified configuration
options to the requested value in the configuration set for the new
environment. These override the values obtained from the solution stack
or the configuration template.}

\item{OptionsToRemove}{A list of custom user-defined configuration options to remove from the
configuration set for this new environment.}

\item{OperationsRole}{The Amazon Resource Name (ARN) of an existing IAM role to be used as the
environment's operations role. If specified, Elastic Beanstalk uses the
operations role for permissions to downstream services during this call
and during subsequent calls acting on this environment. To specify an
operations role, you must have the \code{iam:PassRole} permission for the
role. For more information, see \href{https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/}{Operations roles} in the
\emph{AWS Elastic Beanstalk Developer Guide}.}
}
\value{
A list with the following syntax:\preformatted{list(
  EnvironmentName = "string",
  EnvironmentId = "string",
  ApplicationName = "string",
  VersionLabel = "string",
  SolutionStackName = "string",
  PlatformArn = "string",
  TemplateName = "string",
  Description = "string",
  EndpointURL = "string",
  CNAME = "string",
  DateCreated = as.POSIXct(
    "2015-01-01"
  ),
  DateUpdated = as.POSIXct(
    "2015-01-01"
  ),
  Status = "Aborting"|"Launching"|"Updating"|"LinkingFrom"|"LinkingTo"|"Ready"|"Terminating"|"Terminated",
  AbortableOperationInProgress = TRUE|FALSE,
  Health = "Green"|"Yellow"|"Red"|"Grey",
  HealthStatus = "NoData"|"Unknown"|"Pending"|"Ok"|"Info"|"Warning"|"Degraded"|"Severe"|"Suspended",
  Resources = list(
    LoadBalancer = list(
      LoadBalancerName = "string",
      Domain = "string",
      Listeners = list(
        list(
          Protocol = "string",
          Port = 123
        )
      )
    )
  ),
  Tier = list(
    Name = "string",
    Type = "string",
    Version = "string"
  ),
  EnvironmentLinks = list(
    list(
      LinkName = "string",
      EnvironmentName = "string"
    )
  ),
  EnvironmentArn = "string",
  OperationsRole = "string"
)
}
}
\description{
Launches an AWS Elastic Beanstalk environment for the specified
application using the specified configuration.
}
\section{Request syntax}{
\preformatted{svc$create_environment(
  ApplicationName = "string",
  EnvironmentName = "string",
  GroupName = "string",
  Description = "string",
  CNAMEPrefix = "string",
  Tier = list(
    Name = "string",
    Type = "string",
    Version = "string"
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  VersionLabel = "string",
  TemplateName = "string",
  SolutionStackName = "string",
  PlatformArn = "string",
  OptionSettings = list(
    list(
      ResourceName = "string",
      Namespace = "string",
      OptionName = "string",
      Value = "string"
    )
  ),
  OptionsToRemove = list(
    list(
      ResourceName = "string",
      Namespace = "string",
      OptionName = "string"
    )
  ),
  OperationsRole = "string"
)
}
}

\examples{
\dontrun{
# The following operation creates a new environment for version v1 of a
# java application named my-app:
svc$create_environment(
  ApplicationName = "my-app",
  CNAMEPrefix = "my-app",
  EnvironmentName = "my-env",
  SolutionStackName = "64bit Amazon Linux 2015.03 v2.0.0 running Tomcat 8 Java 8",
  VersionLabel = "v1"
)
}

}
\keyword{internal}
