% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_transit_gateway_route}
\alias{ec2_create_transit_gateway_route}
\title{Creates a static route for the specified transit gateway route table}
\usage{
ec2_create_transit_gateway_route(DestinationCidrBlock,
  TransitGatewayRouteTableId, TransitGatewayAttachmentId, Blackhole,
  DryRun)
}
\arguments{
\item{DestinationCidrBlock}{[required] The CIDR range used for destination matches. Routing decisions are based
on the most specific match.}

\item{TransitGatewayRouteTableId}{[required] The ID of the transit gateway route table.}

\item{TransitGatewayAttachmentId}{The ID of the attachment.}

\item{Blackhole}{Indicates whether to drop traffic that matches this route.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Route = list(
    DestinationCidrBlock = "string",
    PrefixListId = "string",
    TransitGatewayAttachments = list(
      list(
        ResourceId = "string",
        TransitGatewayAttachmentId = "string",
        ResourceType = "vpc"|"vpn"|"direct-connect-gateway"|"connect"|"peering"|"tgw-peering"
      )
    ),
    Type = "static"|"propagated",
    State = "pending"|"active"|"blackhole"|"deleting"|"deleted"
  )
)
}
}
\description{
Creates a static route for the specified transit gateway route table.
}
\section{Request syntax}{
\preformatted{svc$create_transit_gateway_route(
  DestinationCidrBlock = "string",
  TransitGatewayRouteTableId = "string",
  TransitGatewayAttachmentId = "string",
  Blackhole = TRUE|FALSE,
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
