% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_fpga_image_attribute}
\alias{ec2_describe_fpga_image_attribute}
\title{Describes the specified attribute of the specified Amazon FPGA Image
(AFI)}
\usage{
ec2_describe_fpga_image_attribute(DryRun, FpgaImageId, Attribute)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{FpgaImageId}{[required] The ID of the AFI.}

\item{Attribute}{[required] The AFI attribute.}
}
\value{
A list with the following syntax:\preformatted{list(
  FpgaImageAttribute = list(
    FpgaImageId = "string",
    Name = "string",
    Description = "string",
    LoadPermissions = list(
      list(
        UserId = "string",
        Group = "all"
      )
    ),
    ProductCodes = list(
      list(
        ProductCodeId = "string",
        ProductCodeType = "devpay"|"marketplace"
      )
    )
  )
)
}
}
\description{
Describes the specified attribute of the specified Amazon FPGA Image
(AFI).
}
\section{Request syntax}{
\preformatted{svc$describe_fpga_image_attribute(
  DryRun = TRUE|FALSE,
  FpgaImageId = "string",
  Attribute = "description"|"name"|"loadPermission"|"productCodes"
)
}
}

\keyword{internal}
