% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_distribution_latest_cache_reset}
\alias{lightsail_get_distribution_latest_cache_reset}
\title{Returns the timestamp and status of the last cache reset of a specific
Amazon Lightsail content delivery network (CDN) distribution}
\usage{
lightsail_get_distribution_latest_cache_reset(distributionName)
}
\arguments{
\item{distributionName}{The name of the distribution for which to return the timestamp of the
last cache reset.

Use the \code{\link[=lightsail_get_distributions]{get_distributions}} action to get
a list of distribution names that you can specify.

When omitted, the response includes the latest cache reset timestamp of
all your distributions.}
}
\value{
A list with the following syntax:\preformatted{list(
  status = "string",
  createTime = as.POSIXct(
    "2015-01-01"
  )
)
}
}
\description{
Returns the timestamp and status of the last cache reset of a specific
Amazon Lightsail content delivery network (CDN) distribution.
}
\section{Request syntax}{
\preformatted{svc$get_distribution_latest_cache_reset(
  distributionName = "string"
)
}
}

\keyword{internal}
