% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pinpoint_operations.R
\name{pinpoint_get_apns_voip_channel}
\alias{pinpoint_get_apns_voip_channel}
\title{Retrieves information about the status and settings of the APNs VoIP
channel for an application}
\usage{
pinpoint_get_apns_voip_channel(ApplicationId)
}
\arguments{
\item{ApplicationId}{[required] The unique identifier for the application. This identifier is displayed
as the \strong{Project ID} on the Amazon Pinpoint console.}
}
\value{
A list with the following syntax:\preformatted{list(
  APNSVoipChannelResponse = list(
    ApplicationId = "string",
    CreationDate = "string",
    DefaultAuthenticationMethod = "string",
    Enabled = TRUE|FALSE,
    HasCredential = TRUE|FALSE,
    HasTokenKey = TRUE|FALSE,
    Id = "string",
    IsArchived = TRUE|FALSE,
    LastModifiedBy = "string",
    LastModifiedDate = "string",
    Platform = "string",
    Version = 123
  )
)
}
}
\description{
Retrieves information about the status and settings of the APNs VoIP
channel for an application.
}
\section{Request syntax}{
\preformatted{svc$get_apns_voip_channel(
  ApplicationId = "string"
)
}
}

\keyword{internal}
