% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rds_operations.R
\name{rds_delete_db_instance_automated_backup}
\alias{rds_delete_db_instance_automated_backup}
\title{Deletes automated backups using the DbiResourceId value of the source DB
instance or the Amazon Resource Name (ARN) of the automated backups}
\usage{
rds_delete_db_instance_automated_backup(DbiResourceId,
  DBInstanceAutomatedBackupsArn)
}
\arguments{
\item{DbiResourceId}{The identifier for the source DB instance, which can't be changed and
which is unique to an AWS Region.}

\item{DBInstanceAutomatedBackupsArn}{The Amazon Resource Name (ARN) of the automated backups to delete, for
example,
\code{arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE}.}
}
\value{
A list with the following syntax:\preformatted{list(
  DBInstanceAutomatedBackup = list(
    DBInstanceArn = "string",
    DbiResourceId = "string",
    Region = "string",
    DBInstanceIdentifier = "string",
    RestoreWindow = list(
      EarliestTime = as.POSIXct(
        "2015-01-01"
      ),
      LatestTime = as.POSIXct(
        "2015-01-01"
      )
    ),
    AllocatedStorage = 123,
    Status = "string",
    Port = 123,
    AvailabilityZone = "string",
    VpcId = "string",
    InstanceCreateTime = as.POSIXct(
      "2015-01-01"
    ),
    MasterUsername = "string",
    Engine = "string",
    EngineVersion = "string",
    LicenseModel = "string",
    Iops = 123,
    OptionGroupName = "string",
    TdeCredentialArn = "string",
    Encrypted = TRUE|FALSE,
    StorageType = "string",
    KmsKeyId = "string",
    Timezone = "string",
    IAMDatabaseAuthenticationEnabled = TRUE|FALSE,
    BackupRetentionPeriod = 123,
    DBInstanceAutomatedBackupsArn = "string",
    DBInstanceAutomatedBackupsReplications = list(
      list(
        DBInstanceAutomatedBackupsArn = "string"
      )
    )
  )
)
}
}
\description{
Deletes automated backups using the \code{DbiResourceId} value of the source
DB instance or the Amazon Resource Name (ARN) of the automated backups.
}
\section{Request syntax}{
\preformatted{svc$delete_db_instance_automated_backup(
  DbiResourceId = "string",
  DBInstanceAutomatedBackupsArn = "string"
)
}
}

\keyword{internal}
