% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloud9_operations.R
\name{cloud9_describe_environments}
\alias{cloud9_describe_environments}
\title{Gets information about AWS Cloud9 development environments}
\usage{
cloud9_describe_environments(environmentIds)
}
\arguments{
\item{environmentIds}{[required] The IDs of individual environments to get information about.}
}
\value{
A list with the following syntax:\preformatted{list(
  environments = list(
    list(
      id = "string",
      name = "string",
      description = "string",
      type = "ssh"|"ec2",
      connectionType = "CONNECT_SSH"|"CONNECT_SSM",
      arn = "string",
      ownerArn = "string",
      lifecycle = list(
        status = "CREATING"|"CREATED"|"CREATE_FAILED"|"DELETING"|"DELETE_FAILED",
        reason = "string",
        failureResource = "string"
      )
    )
  )
)
}
}
\description{
Gets information about AWS Cloud9 development environments.
}
\section{Request syntax}{
\preformatted{svc$describe_environments(
  environmentIds = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# 
svc$describe_environments(
  environmentIds = list(
    "8d9967e2f0624182b74e7690ad69ebEX",
    "349c86d4579e4e7298d500ff57a6b2EX"
  )
)
}

}
\keyword{internal}
