% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_list_projects}
\alias{codebuild_list_projects}
\title{Gets a list of build project names, with each build project name
representing a single build project}
\usage{
codebuild_list_projects(sortBy, sortOrder, nextToken)
}
\arguments{
\item{sortBy}{The criterion to be used to list build project names. Valid values
include:
\itemize{
\item \code{CREATED_TIME}: List based on when each build project was created.
\item \code{LAST_MODIFIED_TIME}: List based on when information about each
build project was last changed.
\item \code{NAME}: List based on each build project's name.
}

Use \code{sortOrder} to specify in what order to list the build project names
based on the preceding criteria.}

\item{sortOrder}{The order in which to list build projects. Valid values include:
\itemize{
\item \code{ASCENDING}: List in ascending order.
\item \code{DESCENDING}: List in descending order.
}

Use \code{sortBy} to specify the criterion to be used to list build project
names.}

\item{nextToken}{During a previous call, if there are more than 100 items in the list,
only the first 100 items are returned, along with a unique string called
a \emph{nextToken}. To get the next batch of items in the list, call this
operation again, adding the next token to the call. To get all of the
items in the list, keep calling this operation with each subsequent next
token that is returned, until no more next tokens are returned.}
}
\value{
A list with the following syntax:\preformatted{list(
  nextToken = "string",
  projects = list(
    "string"
  )
)
}
}
\description{
Gets a list of build project names, with each build project name
representing a single build project.
}
\section{Request syntax}{
\preformatted{svc$list_projects(
  sortBy = "NAME"|"CREATED_TIME"|"LAST_MODIFIED_TIME",
  sortOrder = "ASCENDING"|"DESCENDING",
  nextToken = "string"
)
}
}

\keyword{internal}
