% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_get_file}
\alias{codecommit_get_file}
\title{Returns the base-64 encoded contents of a specified file and its
metadata}
\usage{
codecommit_get_file(repositoryName, commitSpecifier, filePath)
}
\arguments{
\item{repositoryName}{[required] The name of the repository that contains the file.}

\item{commitSpecifier}{The fully quaified reference that identifies the commit that contains
the file. For example, you can specify a full commit ID, a tag, a branch
name, or a reference such as refs/heads/master. If none is provided, the
head commit is used.}

\item{filePath}{[required] The fully qualified path to the file, including the full name and
extension of the file. For example, /examples/file.md is the fully
qualified path to a file named file.md in a folder named examples.}
}
\value{
A list with the following syntax:\preformatted{list(
  commitId = "string",
  blobId = "string",
  filePath = "string",
  fileMode = "EXECUTABLE"|"NORMAL"|"SYMLINK",
  fileSize = 123,
  fileContent = raw
)
}
}
\description{
Returns the base-64 encoded contents of a specified file and its
metadata.
}
\section{Request syntax}{
\preformatted{svc$get_file(
  repositoryName = "string",
  commitSpecifier = "string",
  filePath = "string"
)
}
}

\keyword{internal}
