% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xray_operations.R
\name{xray_get_sampling_targets}
\alias{xray_get_sampling_targets}
\title{Requests a sampling quota for rules that the service is using to sample
requests}
\usage{
xray_get_sampling_targets(SamplingStatisticsDocuments)
}
\arguments{
\item{SamplingStatisticsDocuments}{[required] Information about rules that the service is using to sample requests.}
}
\value{
A list with the following syntax:\preformatted{list(
  SamplingTargetDocuments = list(
    list(
      RuleName = "string",
      FixedRate = 123.0,
      ReservoirQuota = 123,
      ReservoirQuotaTTL = as.POSIXct(
        "2015-01-01"
      ),
      Interval = 123
    )
  ),
  LastRuleModification = as.POSIXct(
    "2015-01-01"
  ),
  UnprocessedStatistics = list(
    list(
      RuleName = "string",
      ErrorCode = "string",
      Message = "string"
    )
  )
)
}
}
\description{
Requests a sampling quota for rules that the service is using to sample
requests.
}
\section{Request syntax}{
\preformatted{svc$get_sampling_targets(
  SamplingStatisticsDocuments = list(
    list(
      RuleName = "string",
      ClientID = "string",
      Timestamp = as.POSIXct(
        "2015-01-01"
      ),
      RequestCount = 123,
      SampledCount = 123,
      BorrowCount = 123
    )
  )
)
}
}

\keyword{internal}
