% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xray_operations.R
\name{xray_untag_resource}
\alias{xray_untag_resource}
\title{Removes tags from an AWS X-Ray group or sampling rule}
\usage{
xray_untag_resource(ResourceARN, TagKeys)
}
\arguments{
\item{ResourceARN}{[required] The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.}

\item{TagKeys}{[required] Keys for one or more tags that you want to remove from an X-Ray group or
sampling rule.}
}
\value{
An empty list.
}
\description{
Removes tags from an AWS X-Ray group or sampling rule. You cannot edit
or delete system tags (those with an \verb{aws:} prefix).
}
\section{Request syntax}{
\preformatted{svc$untag_resource(
  ResourceARN = "string",
  TagKeys = list(
    "string"
  )
)
}
}

\keyword{internal}
