# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codedeploy_service.R
NULL

#' Adds tags to on-premises instances
#'
#' @description
#' Adds tags to on-premises instances.
#'
#' @usage
#' codedeploy_add_tags_to_on_premises_instances(tags, instanceNames)
#'
#' @param tags &#91;required&#93; The tag key-value pairs to add to the on-premises instances.
#' 
#' Keys and values are both required. Keys cannot be null or empty strings.
#' Value-only tags are not allowed.
#' @param instanceNames &#91;required&#93; The names of the on-premises instances to which to add tags.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags_to_on_premises_instances(
#'   tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   instanceNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_add_tags_to_on_premises_instances
codedeploy_add_tags_to_on_premises_instances <- function(tags, instanceNames) {
  op <- new_operation(
    name = "AddTagsToOnPremisesInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$add_tags_to_on_premises_instances_input(tags = tags, instanceNames = instanceNames)
  output <- .codedeploy$add_tags_to_on_premises_instances_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$add_tags_to_on_premises_instances <- codedeploy_add_tags_to_on_premises_instances

#' Gets information about one or more application revisions
#'
#' @description
#' Gets information about one or more application revisions. The maximum
#' number of application revisions that can be returned is 25.
#'
#' @usage
#' codedeploy_batch_get_application_revisions(applicationName, revisions)
#'
#' @param applicationName &#91;required&#93; The name of an AWS CodeDeploy application about which to get revision
#' information.
#' @param revisions &#91;required&#93; An array of `RevisionLocation` objects that specify information to get
#' about the application revisions, including type and location. The
#' maximum number of `RevisionLocation` objects you can specify is 25.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   applicationName = "string",
#'   errorMessage = "string",
#'   revisions = list(
#'     list(
#'       revisionLocation = list(
#'         revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
#'         s3Location = list(
#'           bucket = "string",
#'           key = "string",
#'           bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
#'           version = "string",
#'           eTag = "string"
#'         ),
#'         gitHubLocation = list(
#'           repository = "string",
#'           commitId = "string"
#'         ),
#'         string = list(
#'           content = "string",
#'           sha256 = "string"
#'         ),
#'         appSpecContent = list(
#'           content = "string",
#'           sha256 = "string"
#'         )
#'       ),
#'       genericRevisionInfo = list(
#'         description = "string",
#'         deploymentGroups = list(
#'           "string"
#'         ),
#'         firstUsedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         lastUsedTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         registerTime = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_application_revisions(
#'   applicationName = "string",
#'   revisions = list(
#'     list(
#'       revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
#'       s3Location = list(
#'         bucket = "string",
#'         key = "string",
#'         bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
#'         version = "string",
#'         eTag = "string"
#'       ),
#'       gitHubLocation = list(
#'         repository = "string",
#'         commitId = "string"
#'       ),
#'       string = list(
#'         content = "string",
#'         sha256 = "string"
#'       ),
#'       appSpecContent = list(
#'         content = "string",
#'         sha256 = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_application_revisions
codedeploy_batch_get_application_revisions <- function(applicationName, revisions) {
  op <- new_operation(
    name = "BatchGetApplicationRevisions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_application_revisions_input(applicationName = applicationName, revisions = revisions)
  output <- .codedeploy$batch_get_application_revisions_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_application_revisions <- codedeploy_batch_get_application_revisions

#' Gets information about one or more applications
#'
#' @description
#' Gets information about one or more applications. The maximum number of
#' applications that can be returned is 100.
#'
#' @usage
#' codedeploy_batch_get_applications(applicationNames)
#'
#' @param applicationNames &#91;required&#93; A list of application names separated by spaces. The maximum number of
#' application names you can specify is 100.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   applicationsInfo = list(
#'     list(
#'       applicationId = "string",
#'       applicationName = "string",
#'       createTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       linkedToGitHub = TRUE|FALSE,
#'       gitHubAccountName = "string",
#'       computePlatform = "Server"|"Lambda"|"ECS"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_applications(
#'   applicationNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_applications
codedeploy_batch_get_applications <- function(applicationNames) {
  op <- new_operation(
    name = "BatchGetApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_applications_input(applicationNames = applicationNames)
  output <- .codedeploy$batch_get_applications_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_applications <- codedeploy_batch_get_applications

#' Gets information about one or more deployment groups
#'
#' @description
#' Gets information about one or more deployment groups.
#'
#' @usage
#' codedeploy_batch_get_deployment_groups(applicationName,
#'   deploymentGroupNames)
#'
#' @param applicationName &#91;required&#93; The name of an AWS CodeDeploy application associated with the applicable
#' IAM user or AWS account.
#' @param deploymentGroupNames &#91;required&#93; The names of the deployment groups.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   deploymentGroupsInfo = list(
#'     list(
#'       applicationName = "string",
#'       deploymentGroupId = "string",
#'       deploymentGroupName = "string",
#'       deploymentConfigName = "string",
#'       ec2TagFilters = list(
#'         list(
#'           Key = "string",
#'           Value = "string",
#'           Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'         )
#'       ),
#'       onPremisesInstanceTagFilters = list(
#'         list(
#'           Key = "string",
#'           Value = "string",
#'           Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'         )
#'       ),
#'       autoScalingGroups = list(
#'         list(
#'           name = "string",
#'           hook = "string"
#'         )
#'       ),
#'       serviceRoleArn = "string",
#'       targetRevision = list(
#'         revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
#'         s3Location = list(
#'           bucket = "string",
#'           key = "string",
#'           bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
#'           version = "string",
#'           eTag = "string"
#'         ),
#'         gitHubLocation = list(
#'           repository = "string",
#'           commitId = "string"
#'         ),
#'         string = list(
#'           content = "string",
#'           sha256 = "string"
#'         ),
#'         appSpecContent = list(
#'           content = "string",
#'           sha256 = "string"
#'         )
#'       ),
#'       triggerConfigurations = list(
#'         list(
#'           triggerName = "string",
#'           triggerTargetArn = "string",
#'           triggerEvents = list(
#'             "DeploymentStart"|"DeploymentSuccess"|"DeploymentFailure"|"DeploymentStop"|"DeploymentRollback"|"DeploymentReady"|"InstanceStart"|"InstanceSuccess"|"InstanceFailure"|"InstanceReady"
#'           )
#'         )
#'       ),
#'       alarmConfiguration = list(
#'         enabled = TRUE|FALSE,
#'         ignorePollAlarmFailure = TRUE|FALSE,
#'         alarms = list(
#'           list(
#'             name = "string"
#'           )
#'         )
#'       ),
#'       autoRollbackConfiguration = list(
#'         enabled = TRUE|FALSE,
#'         events = list(
#'           "DEPLOYMENT_FAILURE"|"DEPLOYMENT_STOP_ON_ALARM"|"DEPLOYMENT_STOP_ON_REQUEST"
#'         )
#'       ),
#'       deploymentStyle = list(
#'         deploymentType = "IN_PLACE"|"BLUE_GREEN",
#'         deploymentOption = "WITH_TRAFFIC_CONTROL"|"WITHOUT_TRAFFIC_CONTROL"
#'       ),
#'       blueGreenDeploymentConfiguration = list(
#'         terminateBlueInstancesOnDeploymentSuccess = list(
#'           action = "TERMINATE"|"KEEP_ALIVE",
#'           terminationWaitTimeInMinutes = 123
#'         ),
#'         deploymentReadyOption = list(
#'           actionOnTimeout = "CONTINUE_DEPLOYMENT"|"STOP_DEPLOYMENT",
#'           waitTimeInMinutes = 123
#'         ),
#'         greenFleetProvisioningOption = list(
#'           action = "DISCOVER_EXISTING"|"COPY_AUTO_SCALING_GROUP"
#'         )
#'       ),
#'       loadBalancerInfo = list(
#'         elbInfoList = list(
#'           list(
#'             name = "string"
#'           )
#'         ),
#'         targetGroupInfoList = list(
#'           list(
#'             name = "string"
#'           )
#'         ),
#'         targetGroupPairInfoList = list(
#'           list(
#'             targetGroups = list(
#'               list(
#'                 name = "string"
#'               )
#'             ),
#'             prodTrafficRoute = list(
#'               listenerArns = list(
#'                 "string"
#'               )
#'             ),
#'             testTrafficRoute = list(
#'               listenerArns = list(
#'                 "string"
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       lastSuccessfulDeployment = list(
#'         deploymentId = "string",
#'         status = "Created"|"Queued"|"InProgress"|"Baking"|"Succeeded"|"Failed"|"Stopped"|"Ready",
#'         endTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         createTime = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       ),
#'       lastAttemptedDeployment = list(
#'         deploymentId = "string",
#'         status = "Created"|"Queued"|"InProgress"|"Baking"|"Succeeded"|"Failed"|"Stopped"|"Ready",
#'         endTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         createTime = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       ),
#'       ec2TagSet = list(
#'         ec2TagSetList = list(
#'           list(
#'             list(
#'               Key = "string",
#'               Value = "string",
#'               Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'             )
#'           )
#'         )
#'       ),
#'       onPremisesTagSet = list(
#'         onPremisesTagSetList = list(
#'           list(
#'             list(
#'               Key = "string",
#'               Value = "string",
#'               Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'             )
#'           )
#'         )
#'       ),
#'       computePlatform = "Server"|"Lambda"|"ECS",
#'       ecsServices = list(
#'         list(
#'           serviceName = "string",
#'           clusterName = "string"
#'         )
#'       )
#'     )
#'   ),
#'   errorMessage = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_deployment_groups(
#'   applicationName = "string",
#'   deploymentGroupNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_deployment_groups
codedeploy_batch_get_deployment_groups <- function(applicationName, deploymentGroupNames) {
  op <- new_operation(
    name = "BatchGetDeploymentGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_deployment_groups_input(applicationName = applicationName, deploymentGroupNames = deploymentGroupNames)
  output <- .codedeploy$batch_get_deployment_groups_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_deployment_groups <- codedeploy_batch_get_deployment_groups

#' This method works, but is deprecated
#'
#' @description
#' This method works, but is deprecated. Use
#' [`batch_get_deployment_targets`][codedeploy_batch_get_deployment_targets]
#' instead.
#' 
#' Returns an array of one or more instances associated with a deployment.
#' This method works with EC2/On-premises and AWS Lambda compute platforms.
#' The newer
#' [`batch_get_deployment_targets`][codedeploy_batch_get_deployment_targets]
#' works with all compute platforms. The maximum number of instances that
#' can be returned is 25.
#'
#' @usage
#' codedeploy_batch_get_deployment_instances(deploymentId, instanceIds)
#'
#' @param deploymentId &#91;required&#93; The unique ID of a deployment.
#' @param instanceIds &#91;required&#93; The unique IDs of instances used in the deployment. The maximum number
#' of instance IDs you can specify is 25.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   instancesSummary = list(
#'     list(
#'       deploymentId = "string",
#'       instanceId = "string",
#'       status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lifecycleEvents = list(
#'         list(
#'           lifecycleEventName = "string",
#'           diagnostics = list(
#'             errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
#'             scriptName = "string",
#'             message = "string",
#'             logTail = "string"
#'           ),
#'           startTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           endTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
#'         )
#'       ),
#'       instanceType = "Blue"|"Green"
#'     )
#'   ),
#'   errorMessage = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_deployment_instances(
#'   deploymentId = "string",
#'   instanceIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_deployment_instances
codedeploy_batch_get_deployment_instances <- function(deploymentId, instanceIds) {
  op <- new_operation(
    name = "BatchGetDeploymentInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_deployment_instances_input(deploymentId = deploymentId, instanceIds = instanceIds)
  output <- .codedeploy$batch_get_deployment_instances_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_deployment_instances <- codedeploy_batch_get_deployment_instances

#' Returns an array of one or more targets associated with a deployment
#'
#' @description
#' Returns an array of one or more targets associated with a deployment.
#' This method works with all compute types and should be used instead of
#' the deprecated
#' [`batch_get_deployment_instances`][codedeploy_batch_get_deployment_instances].
#' The maximum number of targets that can be returned is 25.
#' 
#' The type of targets returned depends on the deployment's compute
#' platform or deployment method:
#' 
#' -   **EC2/On-premises**: Information about EC2 instance targets.
#' 
#' -   **AWS Lambda**: Information about Lambda functions targets.
#' 
#' -   **Amazon ECS**: Information about Amazon ECS service targets.
#' 
#' -   **CloudFormation**: Information about targets of blue/green
#'     deployments initiated by a CloudFormation stack update.
#'
#' @usage
#' codedeploy_batch_get_deployment_targets(deploymentId, targetIds)
#'
#' @param deploymentId The unique ID of a deployment.
#' @param targetIds The unique IDs of the deployment targets. The compute platform of the
#' deployment determines the type of the targets and their formats. The
#' maximum number of deployment target IDs you can specify is 25.
#' 
#' -   For deployments that use the EC2/On-premises compute platform, the
#'     target IDs are EC2 or on-premises instances IDs, and their target
#'     type is `instanceTarget`.
#' 
#' -   For deployments that use the AWS Lambda compute platform, the target
#'     IDs are the names of Lambda functions, and their target type is
#'     `instanceTarget`.
#' 
#' -   For deployments that use the Amazon ECS compute platform, the target
#'     IDs are pairs of Amazon ECS clusters and services specified using
#'     the format `<clustername>:<servicename>`. Their target type is
#'     `ecsTarget`.
#' 
#' -   For deployments that are deployed with AWS CloudFormation, the
#'     target IDs are CloudFormation stack IDs. Their target type is
#'     `cloudFormationTarget`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   deploymentTargets = list(
#'     list(
#'       deploymentTargetType = "InstanceTarget"|"LambdaTarget"|"ECSTarget"|"CloudFormationTarget",
#'       instanceTarget = list(
#'         deploymentId = "string",
#'         targetId = "string",
#'         targetArn = "string",
#'         status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
#'         lastUpdatedAt = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         lifecycleEvents = list(
#'           list(
#'             lifecycleEventName = "string",
#'             diagnostics = list(
#'               errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
#'               scriptName = "string",
#'               message = "string",
#'               logTail = "string"
#'             ),
#'             startTime = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             endTime = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
#'           )
#'         ),
#'         instanceLabel = "Blue"|"Green"
#'       ),
#'       lambdaTarget = list(
#'         deploymentId = "string",
#'         targetId = "string",
#'         targetArn = "string",
#'         status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
#'         lastUpdatedAt = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         lifecycleEvents = list(
#'           list(
#'             lifecycleEventName = "string",
#'             diagnostics = list(
#'               errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
#'               scriptName = "string",
#'               message = "string",
#'               logTail = "string"
#'             ),
#'             startTime = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             endTime = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
#'           )
#'         ),
#'         lambdaFunctionInfo = list(
#'           functionName = "string",
#'           functionAlias = "string",
#'           currentVersion = "string",
#'           targetVersion = "string",
#'           targetVersionWeight = 123.0
#'         )
#'       ),
#'       ecsTarget = list(
#'         deploymentId = "string",
#'         targetId = "string",
#'         targetArn = "string",
#'         lastUpdatedAt = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         lifecycleEvents = list(
#'           list(
#'             lifecycleEventName = "string",
#'             diagnostics = list(
#'               errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
#'               scriptName = "string",
#'               message = "string",
#'               logTail = "string"
#'             ),
#'             startTime = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             endTime = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
#'           )
#'         ),
#'         status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
#'         taskSetsInfo = list(
#'           list(
#'             identifer = "string",
#'             desiredCount = 123,
#'             pendingCount = 123,
#'             runningCount = 123,
#'             status = "string",
#'             trafficWeight = 123.0,
#'             targetGroup = list(
#'               name = "string"
#'             ),
#'             taskSetLabel = "Blue"|"Green"
#'           )
#'         )
#'       ),
#'       cloudFormationTarget = list(
#'         deploymentId = "string",
#'         targetId = "string",
#'         lastUpdatedAt = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         lifecycleEvents = list(
#'           list(
#'             lifecycleEventName = "string",
#'             diagnostics = list(
#'               errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
#'               scriptName = "string",
#'               message = "string",
#'               logTail = "string"
#'             ),
#'             startTime = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             endTime = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
#'           )
#'         ),
#'         status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
#'         resourceType = "string",
#'         targetVersionWeight = 123.0
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_deployment_targets(
#'   deploymentId = "string",
#'   targetIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_deployment_targets
codedeploy_batch_get_deployment_targets <- function(deploymentId = NULL, targetIds = NULL) {
  op <- new_operation(
    name = "BatchGetDeploymentTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_deployment_targets_input(deploymentId = deploymentId, targetIds = targetIds)
  output <- .codedeploy$batch_get_deployment_targets_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_deployment_targets <- codedeploy_batch_get_deployment_targets

#' Gets information about one or more deployments
#'
#' @description
#' Gets information about one or more deployments. The maximum number of
#' deployments that can be returned is 25.
#'
#' @usage
#' codedeploy_batch_get_deployments(deploymentIds)
#'
#' @param deploymentIds &#91;required&#93; A list of deployment IDs, separated by spaces. The maximum number of
#' deployment IDs you can specify is 25.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   deploymentsInfo = list(
#'     list(
#'       applicationName = "string",
#'       deploymentGroupName = "string",
#'       deploymentConfigName = "string",
#'       deploymentId = "string",
#'       previousRevision = list(
#'         revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
#'         s3Location = list(
#'           bucket = "string",
#'           key = "string",
#'           bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
#'           version = "string",
#'           eTag = "string"
#'         ),
#'         gitHubLocation = list(
#'           repository = "string",
#'           commitId = "string"
#'         ),
#'         string = list(
#'           content = "string",
#'           sha256 = "string"
#'         ),
#'         appSpecContent = list(
#'           content = "string",
#'           sha256 = "string"
#'         )
#'       ),
#'       revision = list(
#'         revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
#'         s3Location = list(
#'           bucket = "string",
#'           key = "string",
#'           bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
#'           version = "string",
#'           eTag = "string"
#'         ),
#'         gitHubLocation = list(
#'           repository = "string",
#'           commitId = "string"
#'         ),
#'         string = list(
#'           content = "string",
#'           sha256 = "string"
#'         ),
#'         appSpecContent = list(
#'           content = "string",
#'           sha256 = "string"
#'         )
#'       ),
#'       status = "Created"|"Queued"|"InProgress"|"Baking"|"Succeeded"|"Failed"|"Stopped"|"Ready",
#'       errorInformation = list(
#'         code = "AGENT_ISSUE"|"ALARM_ACTIVE"|"APPLICATION_MISSING"|"AUTOSCALING_VALIDATION_ERROR"|"AUTO_SCALING_CONFIGURATION"|"AUTO_SCALING_IAM_ROLE_PERMISSIONS"|"CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND"|"CUSTOMER_APPLICATION_UNHEALTHY"|"DEPLOYMENT_GROUP_MISSING"|"ECS_UPDATE_ERROR"|"ELASTIC_LOAD_BALANCING_INVALID"|"ELB_INVALID_INSTANCE"|"HEALTH_CONSTRAINTS"|"HEALTH_CONSTRAINTS_INVALID"|"HOOK_EXECUTION_FAILURE"|"IAM_ROLE_MISSING"|"IAM_ROLE_PERMISSIONS"|"INTERNAL_ERROR"|"INVALID_ECS_SERVICE"|"INVALID_LAMBDA_CONFIGURATION"|"INVALID_LAMBDA_FUNCTION"|"INVALID_REVISION"|"MANUAL_STOP"|"MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION"|"MISSING_ELB_INFORMATION"|"MISSING_GITHUB_TOKEN"|"NO_EC2_SUBSCRIPTION"|"NO_INSTANCES"|"OVER_MAX_INSTANCES"|"RESOURCE_LIMIT_EXCEEDED"|"REVISION_MISSING"|"THROTTLED"|"TIMEOUT"|"CLOUDFORMATION_STACK_FAILURE",
#'         message = "string"
#'       ),
#'       createTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       startTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       completeTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       deploymentOverview = list(
#'         Pending = 123,
#'         InProgress = 123,
#'         Succeeded = 123,
#'         Failed = 123,
#'         Skipped = 123,
#'         Ready = 123
#'       ),
#'       description = "string",
#'       creator = "user"|"autoscaling"|"codeDeployRollback"|"CodeDeploy"|"CloudFormation"|"CloudFormationRollback",
#'       ignoreApplicationStopFailures = TRUE|FALSE,
#'       autoRollbackConfiguration = list(
#'         enabled = TRUE|FALSE,
#'         events = list(
#'           "DEPLOYMENT_FAILURE"|"DEPLOYMENT_STOP_ON_ALARM"|"DEPLOYMENT_STOP_ON_REQUEST"
#'         )
#'       ),
#'       updateOutdatedInstancesOnly = TRUE|FALSE,
#'       rollbackInfo = list(
#'         rollbackDeploymentId = "string",
#'         rollbackTriggeringDeploymentId = "string",
#'         rollbackMessage = "string"
#'       ),
#'       deploymentStyle = list(
#'         deploymentType = "IN_PLACE"|"BLUE_GREEN",
#'         deploymentOption = "WITH_TRAFFIC_CONTROL"|"WITHOUT_TRAFFIC_CONTROL"
#'       ),
#'       targetInstances = list(
#'         tagFilters = list(
#'           list(
#'             Key = "string",
#'             Value = "string",
#'             Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'           )
#'         ),
#'         autoScalingGroups = list(
#'           "string"
#'         ),
#'         ec2TagSet = list(
#'           ec2TagSetList = list(
#'             list(
#'               list(
#'                 Key = "string",
#'                 Value = "string",
#'                 Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       instanceTerminationWaitTimeStarted = TRUE|FALSE,
#'       blueGreenDeploymentConfiguration = list(
#'         terminateBlueInstancesOnDeploymentSuccess = list(
#'           action = "TERMINATE"|"KEEP_ALIVE",
#'           terminationWaitTimeInMinutes = 123
#'         ),
#'         deploymentReadyOption = list(
#'           actionOnTimeout = "CONTINUE_DEPLOYMENT"|"STOP_DEPLOYMENT",
#'           waitTimeInMinutes = 123
#'         ),
#'         greenFleetProvisioningOption = list(
#'           action = "DISCOVER_EXISTING"|"COPY_AUTO_SCALING_GROUP"
#'         )
#'       ),
#'       loadBalancerInfo = list(
#'         elbInfoList = list(
#'           list(
#'             name = "string"
#'           )
#'         ),
#'         targetGroupInfoList = list(
#'           list(
#'             name = "string"
#'           )
#'         ),
#'         targetGroupPairInfoList = list(
#'           list(
#'             targetGroups = list(
#'               list(
#'                 name = "string"
#'               )
#'             ),
#'             prodTrafficRoute = list(
#'               listenerArns = list(
#'                 "string"
#'               )
#'             ),
#'             testTrafficRoute = list(
#'               listenerArns = list(
#'                 "string"
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       additionalDeploymentStatusInfo = "string",
#'       fileExistsBehavior = "DISALLOW"|"OVERWRITE"|"RETAIN",
#'       deploymentStatusMessages = list(
#'         "string"
#'       ),
#'       computePlatform = "Server"|"Lambda"|"ECS",
#'       externalId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_deployments(
#'   deploymentIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_deployments
codedeploy_batch_get_deployments <- function(deploymentIds) {
  op <- new_operation(
    name = "BatchGetDeployments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_deployments_input(deploymentIds = deploymentIds)
  output <- .codedeploy$batch_get_deployments_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_deployments <- codedeploy_batch_get_deployments

#' Gets information about one or more on-premises instances
#'
#' @description
#' Gets information about one or more on-premises instances. The maximum
#' number of on-premises instances that can be returned is 25.
#'
#' @usage
#' codedeploy_batch_get_on_premises_instances(instanceNames)
#'
#' @param instanceNames &#91;required&#93; The names of the on-premises instances about which to get information.
#' The maximum number of instance names you can specify is 25.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   instanceInfos = list(
#'     list(
#'       instanceName = "string",
#'       iamSessionArn = "string",
#'       iamUserArn = "string",
#'       instanceArn = "string",
#'       registerTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       deregisterTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_on_premises_instances(
#'   instanceNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_batch_get_on_premises_instances
codedeploy_batch_get_on_premises_instances <- function(instanceNames) {
  op <- new_operation(
    name = "BatchGetOnPremisesInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$batch_get_on_premises_instances_input(instanceNames = instanceNames)
  output <- .codedeploy$batch_get_on_premises_instances_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$batch_get_on_premises_instances <- codedeploy_batch_get_on_premises_instances

#' For a blue/green deployment, starts the process of rerouting traffic
#' from instances in the original environment to instances in the
#' replacement environment without waiting for a specified wait time to
#' elapse
#'
#' @description
#' For a blue/green deployment, starts the process of rerouting traffic
#' from instances in the original environment to instances in the
#' replacement environment without waiting for a specified wait time to
#' elapse. (Traffic rerouting, which is achieved by registering instances
#' in the replacement environment with the load balancer, can start as soon
#' as all instances have a status of Ready.)
#'
#' @usage
#' codedeploy_continue_deployment(deploymentId, deploymentWaitType)
#'
#' @param deploymentId The unique ID of a blue/green deployment for which you want to start
#' rerouting traffic to the replacement environment.
#' @param deploymentWaitType The status of the deployment's waiting period. `READY_WAIT` indicates
#' that the deployment is ready to start shifting traffic.
#' `TERMINATION_WAIT` indicates that the traffic is shifted, but the
#' original target is not terminated.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$continue_deployment(
#'   deploymentId = "string",
#'   deploymentWaitType = "READY_WAIT"|"TERMINATION_WAIT"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_continue_deployment
codedeploy_continue_deployment <- function(deploymentId = NULL, deploymentWaitType = NULL) {
  op <- new_operation(
    name = "ContinueDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$continue_deployment_input(deploymentId = deploymentId, deploymentWaitType = deploymentWaitType)
  output <- .codedeploy$continue_deployment_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$continue_deployment <- codedeploy_continue_deployment

#' Creates an application
#'
#' @description
#' Creates an application.
#'
#' @usage
#' codedeploy_create_application(applicationName, computePlatform, tags)
#'
#' @param applicationName &#91;required&#93; The name of the application. This name must be unique with the
#' applicable IAM user or AWS account.
#' @param computePlatform The destination platform type for the deployment (`Lambda`, `Server`, or
#' `ECS`).
#' @param tags The metadata that you apply to CodeDeploy applications to help you
#' organize and categorize them. Each tag consists of a key and an optional
#' value, both of which you define.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   applicationId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_application(
#'   applicationName = "string",
#'   computePlatform = "Server"|"Lambda"|"ECS",
#'   tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_create_application
codedeploy_create_application <- function(applicationName, computePlatform = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$create_application_input(applicationName = applicationName, computePlatform = computePlatform, tags = tags)
  output <- .codedeploy$create_application_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$create_application <- codedeploy_create_application

#' Deploys an application revision through the specified deployment group
#'
#' @description
#' Deploys an application revision through the specified deployment group.
#'
#' @usage
#' codedeploy_create_deployment(applicationName, deploymentGroupName,
#'   revision, deploymentConfigName, description,
#'   ignoreApplicationStopFailures, targetInstances,
#'   autoRollbackConfiguration, updateOutdatedInstancesOnly,
#'   fileExistsBehavior)
#'
#' @param applicationName &#91;required&#93; The name of an AWS CodeDeploy application associated with the IAM user
#' or AWS account.
#' @param deploymentGroupName The name of the deployment group.
#' @param revision The type and location of the revision to deploy.
#' @param deploymentConfigName The name of a deployment configuration associated with the IAM user or
#' AWS account.
#' 
#' If not specified, the value configured in the deployment group is used
#' as the default. If the deployment group does not have a deployment
#' configuration associated with it, `CodeDeployDefault`.`OneAtATime` is
#' used by default.
#' @param description A comment about the deployment.
#' @param ignoreApplicationStopFailures If true, then if an `ApplicationStop`, `BeforeBlockTraffic`, or
#' `AfterBlockTraffic` deployment lifecycle event to an instance fails,
#' then the deployment continues to the next deployment lifecycle event.
#' For example, if `ApplicationStop` fails, the deployment continues with
#' `DownloadBundle`. If `BeforeBlockTraffic` fails, the deployment
#' continues with `BlockTraffic`. If `AfterBlockTraffic` fails, the
#' deployment continues with `ApplicationStop`.
#' 
#' If false or not specified, then if a lifecycle event fails during a
#' deployment to an instance, that deployment fails. If deployment to that
#' instance is part of an overall deployment and the number of healthy
#' hosts is not less than the minimum number of healthy hosts, then a
#' deployment to the next instance is attempted.
#' 
#' During a deployment, the AWS CodeDeploy agent runs the scripts specified
#' for `ApplicationStop`, `BeforeBlockTraffic`, and `AfterBlockTraffic` in
#' the AppSpec file from the previous successful deployment. (All other
#' scripts are run from the AppSpec file in the current deployment.) If one
#' of these scripts contains an error and does not run successfully, the
#' deployment can fail.
#' 
#' If the cause of the failure is a script from the last successful
#' deployment that will never run successfully, create a new deployment and
#' use `ignoreApplicationStopFailures` to specify that the
#' `ApplicationStop`, `BeforeBlockTraffic`, and `AfterBlockTraffic`
#' failures should be ignored.
#' @param targetInstances Information about the instances that belong to the replacement
#' environment in a blue/green deployment.
#' @param autoRollbackConfiguration Configuration information for an automatic rollback that is added when a
#' deployment is created.
#' @param updateOutdatedInstancesOnly Indicates whether to deploy to all instances or only to instances that
#' are not running the latest application revision.
#' @param fileExistsBehavior Information about how AWS CodeDeploy handles files that already exist in
#' a deployment target location but weren't part of the previous successful
#' deployment.
#' 
#' The `fileExistsBehavior` parameter takes any of the following values:
#' 
#' -   DISALLOW: The deployment fails. This is also the default behavior if
#'     no option is specified.
#' 
#' -   OVERWRITE: The version of the file from the application revision
#'     currently being deployed replaces the version already on the
#'     instance.
#' 
#' -   RETAIN: The version of the file already on the instance is kept and
#'     used as part of the new deployment.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   deploymentId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_deployment(
#'   applicationName = "string",
#'   deploymentGroupName = "string",
#'   revision = list(
#'     revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
#'     s3Location = list(
#'       bucket = "string",
#'       key = "string",
#'       bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
#'       version = "string",
#'       eTag = "string"
#'     ),
#'     gitHubLocation = list(
#'       repository = "string",
#'       commitId = "string"
#'     ),
#'     string = list(
#'       content = "string",
#'       sha256 = "string"
#'     ),
#'     appSpecContent = list(
#'       content = "string",
#'       sha256 = "string"
#'     )
#'   ),
#'   deploymentConfigName = "string",
#'   description = "string",
#'   ignoreApplicationStopFailures = TRUE|FALSE,
#'   targetInstances = list(
#'     tagFilters = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'       )
#'     ),
#'     autoScalingGroups = list(
#'       "string"
#'     ),
#'     ec2TagSet = list(
#'       ec2TagSetList = list(
#'         list(
#'           list(
#'             Key = "string",
#'             Value = "string",
#'             Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   autoRollbackConfiguration = list(
#'     enabled = TRUE|FALSE,
#'     events = list(
#'       "DEPLOYMENT_FAILURE"|"DEPLOYMENT_STOP_ON_ALARM"|"DEPLOYMENT_STOP_ON_REQUEST"
#'     )
#'   ),
#'   updateOutdatedInstancesOnly = TRUE|FALSE,
#'   fileExistsBehavior = "DISALLOW"|"OVERWRITE"|"RETAIN"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_create_deployment
codedeploy_create_deployment <- function(applicationName, deploymentGroupName = NULL, revision = NULL, deploymentConfigName = NULL, description = NULL, ignoreApplicationStopFailures = NULL, targetInstances = NULL, autoRollbackConfiguration = NULL, updateOutdatedInstancesOnly = NULL, fileExistsBehavior = NULL) {
  op <- new_operation(
    name = "CreateDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$create_deployment_input(applicationName = applicationName, deploymentGroupName = deploymentGroupName, revision = revision, deploymentConfigName = deploymentConfigName, description = description, ignoreApplicationStopFailures = ignoreApplicationStopFailures, targetInstances = targetInstances, autoRollbackConfiguration = autoRollbackConfiguration, updateOutdatedInstancesOnly = updateOutdatedInstancesOnly, fileExistsBehavior = fileExistsBehavior)
  output <- .codedeploy$create_deployment_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$create_deployment <- codedeploy_create_deployment

#' Creates a deployment configuration
#'
#' @description
#' Creates a deployment configuration.
#'
#' @usage
#' codedeploy_create_deployment_config(deploymentConfigName,
#'   minimumHealthyHosts, trafficRoutingConfig, computePlatform)
#'
#' @param deploymentConfigName &#91;required&#93; The name of the deployment configuration to create.
#' @param minimumHealthyHosts The minimum number of healthy instances that should be available at any
#' time during the deployment. There are two parameters expected in the
#' input: type and value.
#' 
#' The type parameter takes either of the following values:
#' 
#' -   HOST_COUNT: The value parameter represents the minimum number of
#'     healthy instances as an absolute value.
#' 
#' -   FLEET_PERCENT: The value parameter represents the minimum number of
#'     healthy instances as a percentage of the total number of instances
#'     in the deployment. If you specify FLEET_PERCENT, at the start of
#'     the deployment, AWS CodeDeploy converts the percentage to the
#'     equivalent number of instances and rounds up fractional instances.
#' 
#' The value parameter takes an integer.
#' 
#' For example, to set a minimum of 95% healthy instance, specify a type of
#' FLEET_PERCENT and a value of 95.
#' @param trafficRoutingConfig The configuration that specifies how the deployment traffic is routed.
#' @param computePlatform The destination platform type for the deployment (`Lambda`, `Server`, or
#' `ECS`).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   deploymentConfigId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_deployment_config(
#'   deploymentConfigName = "string",
#'   minimumHealthyHosts = list(
#'     value = 123,
#'     type = "HOST_COUNT"|"FLEET_PERCENT"
#'   ),
#'   trafficRoutingConfig = list(
#'     type = "TimeBasedCanary"|"TimeBasedLinear"|"AllAtOnce",
#'     timeBasedCanary = list(
#'       canaryPercentage = 123,
#'       canaryInterval = 123
#'     ),
#'     timeBasedLinear = list(
#'       linearPercentage = 123,
#'       linearInterval = 123
#'     )
#'   ),
#'   computePlatform = "Server"|"Lambda"|"ECS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_create_deployment_config
codedeploy_create_deployment_config <- function(deploymentConfigName, minimumHealthyHosts = NULL, trafficRoutingConfig = NULL, computePlatform = NULL) {
  op <- new_operation(
    name = "CreateDeploymentConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$create_deployment_config_input(deploymentConfigName = deploymentConfigName, minimumHealthyHosts = minimumHealthyHosts, trafficRoutingConfig = trafficRoutingConfig, computePlatform = computePlatform)
  output <- .codedeploy$create_deployment_config_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$create_deployment_config <- codedeploy_create_deployment_config

#' Creates a deployment group to which application revisions are deployed
#'
#' @description
#' Creates a deployment group to which application revisions are deployed.
#'
#' @usage
#' codedeploy_create_deployment_group(applicationName, deploymentGroupName,
#'   deploymentConfigName, ec2TagFilters, onPremisesInstanceTagFilters,
#'   autoScalingGroups, serviceRoleArn, triggerConfigurations,
#'   alarmConfiguration, autoRollbackConfiguration, deploymentStyle,
#'   blueGreenDeploymentConfiguration, loadBalancerInfo, ec2TagSet,
#'   ecsServices, onPremisesTagSet, tags)
#'
#' @param applicationName &#91;required&#93; The name of an AWS CodeDeploy application associated with the IAM user
#' or AWS account.
#' @param deploymentGroupName &#91;required&#93; The name of a new deployment group for the specified application.
#' @param deploymentConfigName If specified, the deployment configuration name can be either one of the
#' predefined configurations provided with AWS CodeDeploy or a custom
#' deployment configuration that you create by calling the create
#' deployment configuration operation.
#' 
#' `CodeDeployDefault.OneAtATime` is the default deployment configuration.
#' It is used if a configuration isn't specified for the deployment or
#' deployment group.
#' 
#' For more information about the predefined deployment configurations in
#' AWS CodeDeploy, see [Working with Deployment Configurations in
#' CodeDeploy](https://docs.aws.amazon.com/codedeploy/latest/userguide/deployment-configurations.html)
#' in the *AWS CodeDeploy User Guide*.
#' @param ec2TagFilters The Amazon EC2 tags on which to filter. The deployment group includes
#' EC2 instances with any of the specified tags. Cannot be used in the same
#' call as ec2TagSet.
#' @param onPremisesInstanceTagFilters The on-premises instance tags on which to filter. The deployment group
#' includes on-premises instances with any of the specified tags. Cannot be
#' used in the same call as `OnPremisesTagSet`.
#' @param autoScalingGroups A list of associated Amazon EC2 Auto Scaling groups.
#' @param serviceRoleArn &#91;required&#93; A service role Amazon Resource Name (ARN) that allows AWS CodeDeploy to
#' act on the user's behalf when interacting with AWS services.
#' @param triggerConfigurations Information about triggers to create when the deployment group is
#' created. For examples, see [Create a Trigger for an AWS CodeDeploy
#' Event](https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-create-trigger.html)
#' in the *AWS CodeDeploy User Guide*.
#' @param alarmConfiguration Information to add about Amazon CloudWatch alarms when the deployment
#' group is created.
#' @param autoRollbackConfiguration Configuration information for an automatic rollback that is added when a
#' deployment group is created.
#' @param deploymentStyle Information about the type of deployment, in-place or blue/green, that
#' you want to run and whether to route deployment traffic behind a load
#' balancer.
#' @param blueGreenDeploymentConfiguration Information about blue/green deployment options for a deployment group.
#' @param loadBalancerInfo Information about the load balancer used in a deployment.
#' @param ec2TagSet Information about groups of tags applied to EC2 instances. The
#' deployment group includes only EC2 instances identified by all the tag
#' groups. Cannot be used in the same call as `ec2TagFilters`.
#' @param ecsServices The target Amazon ECS services in the deployment group. This applies
#' only to deployment groups that use the Amazon ECS compute platform. A
#' target Amazon ECS service is specified as an Amazon ECS cluster and
#' service name pair using the format `<clustername>:<servicename>`.
#' @param onPremisesTagSet Information about groups of tags applied to on-premises instances. The
#' deployment group includes only on-premises instances identified by all
#' of the tag groups. Cannot be used in the same call as
#' `onPremisesInstanceTagFilters`.
#' @param tags The metadata that you apply to CodeDeploy deployment groups to help you
#' organize and categorize them. Each tag consists of a key and an optional
#' value, both of which you define.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   deploymentGroupId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_deployment_group(
#'   applicationName = "string",
#'   deploymentGroupName = "string",
#'   deploymentConfigName = "string",
#'   ec2TagFilters = list(
#'     list(
#'       Key = "string",
#'       Value = "string",
#'       Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'     )
#'   ),
#'   onPremisesInstanceTagFilters = list(
#'     list(
#'       Key = "string",
#'       Value = "string",
#'       Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'     )
#'   ),
#'   autoScalingGroups = list(
#'     "string"
#'   ),
#'   serviceRoleArn = "string",
#'   triggerConfigurations = list(
#'     list(
#'       triggerName = "string",
#'       triggerTargetArn = "string",
#'       triggerEvents = list(
#'         "DeploymentStart"|"DeploymentSuccess"|"DeploymentFailure"|"DeploymentStop"|"DeploymentRollback"|"DeploymentReady"|"InstanceStart"|"InstanceSuccess"|"InstanceFailure"|"InstanceReady"
#'       )
#'     )
#'   ),
#'   alarmConfiguration = list(
#'     enabled = TRUE|FALSE,
#'     ignorePollAlarmFailure = TRUE|FALSE,
#'     alarms = list(
#'       list(
#'         name = "string"
#'       )
#'     )
#'   ),
#'   autoRollbackConfiguration = list(
#'     enabled = TRUE|FALSE,
#'     events = list(
#'       "DEPLOYMENT_FAILURE"|"DEPLOYMENT_STOP_ON_ALARM"|"DEPLOYMENT_STOP_ON_REQUEST"
#'     )
#'   ),
#'   deploymentStyle = list(
#'     deploymentType = "IN_PLACE"|"BLUE_GREEN",
#'     deploymentOption = "WITH_TRAFFIC_CONTROL"|"WITHOUT_TRAFFIC_CONTROL"
#'   ),
#'   blueGreenDeploymentConfiguration = list(
#'     terminateBlueInstancesOnDeploymentSuccess = list(
#'       action = "TERMINATE"|"KEEP_ALIVE",
#'       terminationWaitTimeInMinutes = 123
#'     ),
#'     deploymentReadyOption = list(
#'       actionOnTimeout = "CONTINUE_DEPLOYMENT"|"STOP_DEPLOYMENT",
#'       waitTimeInMinutes = 123
#'     ),
#'     greenFleetProvisioningOption = list(
#'       action = "DISCOVER_EXISTING"|"COPY_AUTO_SCALING_GROUP"
#'     )
#'   ),
#'   loadBalancerInfo = list(
#'     elbInfoList = list(
#'       list(
#'         name = "string"
#'       )
#'     ),
#'     targetGroupInfoList = list(
#'       list(
#'         name = "string"
#'       )
#'     ),
#'     targetGroupPairInfoList = list(
#'       list(
#'         targetGroups = list(
#'           list(
#'             name = "string"
#'           )
#'         ),
#'         prodTrafficRoute = list(
#'           listenerArns = list(
#'             "string"
#'           )
#'         ),
#'         testTrafficRoute = list(
#'           listenerArns = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ec2TagSet = list(
#'     ec2TagSetList = list(
#'       list(
#'         list(
#'           Key = "string",
#'           Value = "string",
#'           Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'         )
#'       )
#'     )
#'   ),
#'   ecsServices = list(
#'     list(
#'       serviceName = "string",
#'       clusterName = "string"
#'     )
#'   ),
#'   onPremisesTagSet = list(
#'     onPremisesTagSetList = list(
#'       list(
#'         list(
#'           Key = "string",
#'           Value = "string",
#'           Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'         )
#'       )
#'     )
#'   ),
#'   tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_create_deployment_group
codedeploy_create_deployment_group <- function(applicationName, deploymentGroupName, deploymentConfigName = NULL, ec2TagFilters = NULL, onPremisesInstanceTagFilters = NULL, autoScalingGroups = NULL, serviceRoleArn, triggerConfigurations = NULL, alarmConfiguration = NULL, autoRollbackConfiguration = NULL, deploymentStyle = NULL, blueGreenDeploymentConfiguration = NULL, loadBalancerInfo = NULL, ec2TagSet = NULL, ecsServices = NULL, onPremisesTagSet = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateDeploymentGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$create_deployment_group_input(applicationName = applicationName, deploymentGroupName = deploymentGroupName, deploymentConfigName = deploymentConfigName, ec2TagFilters = ec2TagFilters, onPremisesInstanceTagFilters = onPremisesInstanceTagFilters, autoScalingGroups = autoScalingGroups, serviceRoleArn = serviceRoleArn, triggerConfigurations = triggerConfigurations, alarmConfiguration = alarmConfiguration, autoRollbackConfiguration = autoRollbackConfiguration, deploymentStyle = deploymentStyle, blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration, loadBalancerInfo = loadBalancerInfo, ec2TagSet = ec2TagSet, ecsServices = ecsServices, onPremisesTagSet = onPremisesTagSet, tags = tags)
  output <- .codedeploy$create_deployment_group_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$create_deployment_group <- codedeploy_create_deployment_group

#' Deletes an application
#'
#' @description
#' Deletes an application.
#'
#' @usage
#' codedeploy_delete_application(applicationName)
#'
#' @param applicationName &#91;required&#93; The name of an AWS CodeDeploy application associated with the IAM user
#' or AWS account.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application(
#'   applicationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_delete_application
codedeploy_delete_application <- function(applicationName) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$delete_application_input(applicationName = applicationName)
  output <- .codedeploy$delete_application_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$delete_application <- codedeploy_delete_application

#' Deletes a deployment configuration
#'
#' @description
#' Deletes a deployment configuration.
#' 
#' A deployment configuration cannot be deleted if it is currently in use.
#' Predefined configurations cannot be deleted.
#'
#' @usage
#' codedeploy_delete_deployment_config(deploymentConfigName)
#'
#' @param deploymentConfigName &#91;required&#93; The name of a deployment configuration associated with the IAM user or
#' AWS account.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_deployment_config(
#'   deploymentConfigName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_delete_deployment_config
codedeploy_delete_deployment_config <- function(deploymentConfigName) {
  op <- new_operation(
    name = "DeleteDeploymentConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$delete_deployment_config_input(deploymentConfigName = deploymentConfigName)
  output <- .codedeploy$delete_deployment_config_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$delete_deployment_config <- codedeploy_delete_deployment_config

#' Deletes a deployment group
#'
#' @description
#' Deletes a deployment group.
#'
#' @usage
#' codedeploy_delete_deployment_group(applicationName, deploymentGroupName)
#'
#' @param applicationName &#91;required&#93; The name of an AWS CodeDeploy application associated with the IAM user
#' or AWS account.
#' @param deploymentGroupName &#91;required&#93; The name of a deployment group for the specified application.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   hooksNotCleanedUp = list(
#'     list(
#'       name = "string",
#'       hook = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_deployment_group(
#'   applicationName = "string",
#'   deploymentGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_delete_deployment_group
codedeploy_delete_deployment_group <- function(applicationName, deploymentGroupName) {
  op <- new_operation(
    name = "DeleteDeploymentGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$delete_deployment_group_input(applicationName = applicationName, deploymentGroupName = deploymentGroupName)
  output <- .codedeploy$delete_deployment_group_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$delete_deployment_group <- codedeploy_delete_deployment_group

#' Deletes a GitHub account connection
#'
#' @description
#' Deletes a GitHub account connection.
#'
#' @usage
#' codedeploy_delete_git_hub_account_token(tokenName)
#'
#' @param tokenName The name of the GitHub account connection to delete.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   tokenName = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_git_hub_account_token(
#'   tokenName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_delete_git_hub_account_token
codedeploy_delete_git_hub_account_token <- function(tokenName = NULL) {
  op <- new_operation(
    name = "DeleteGitHubAccountToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$delete_git_hub_account_token_input(tokenName = tokenName)
  output <- .codedeploy$delete_git_hub_account_token_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$delete_git_hub_account_token <- codedeploy_delete_git_hub_account_token

#' Deletes resources linked to an external ID
#'
#' @description
#' Deletes resources linked to an external ID.
#'
#' @usage
#' codedeploy_delete_resources_by_external_id(externalId)
#'
#' @param externalId The unique ID of an external resource (for example, a CloudFormation
#' stack ID) that is linked to one or more CodeDeploy resources.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_resources_by_external_id(
#'   externalId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_delete_resources_by_external_id
codedeploy_delete_resources_by_external_id <- function(externalId = NULL) {
  op <- new_operation(
    name = "DeleteResourcesByExternalId",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$delete_resources_by_external_id_input(externalId = externalId)
  output <- .codedeploy$delete_resources_by_external_id_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$delete_resources_by_external_id <- codedeploy_delete_resources_by_external_id

#' Deregisters an on-premises instance
#'
#' @description
#' Deregisters an on-premises instance.
#'
#' @usage
#' codedeploy_deregister_on_premises_instance(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the on-premises instance to deregister.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_on_premises_instance(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_deregister_on_premises_instance
codedeploy_deregister_on_premises_instance <- function(instanceName) {
  op <- new_operation(
    name = "DeregisterOnPremisesInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$deregister_on_premises_instance_input(instanceName = instanceName)
  output <- .codedeploy$deregister_on_premises_instance_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$deregister_on_premises_instance <- codedeploy_deregister_on_premises_instance

#' Gets information about an application
#'
#' @description
#' Gets information about an application.
#'
#' @usage
#' codedeploy_get_application(applicationName)
#'
#' @param applicationName &#91;required&#93; The name of an AWS CodeDeploy application associated with the IAM user
#' or AWS account.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   application = list(
#'     applicationId = "string",
#'     applicationName = "string",
#'     createTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     linkedToGitHub = TRUE|FALSE,
#'     gitHubAccountName = "string",
#'     computePlatform = "Server"|"Lambda"|"ECS"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_application(
#'   applicationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_application
codedeploy_get_application <- function(applicationName) {
  op <- new_operation(
    name = "GetApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_application_input(applicationName = applicationName)
  output <- .codedeploy$get_application_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_application <- codedeploy_get_application

#' Gets information about an application revision
#'
#' @description
#' Gets information about an application revision.
#'
#' @usage
#' codedeploy_get_application_revision(applicationName, revision)
#'
#' @param applicationName &#91;required&#93; The name of the application that corresponds to the revision.
#' @param revision &#91;required&#93; Information about the application revision to get, including type and
#' location.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   applicationName = "string",
#'   revision = list(
#'     revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
#'     s3Location = list(
#'       bucket = "string",
#'       key = "string",
#'       bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
#'       version = "string",
#'       eTag = "string"
#'     ),
#'     gitHubLocation = list(
#'       repository = "string",
#'       commitId = "string"
#'     ),
#'     string = list(
#'       content = "string",
#'       sha256 = "string"
#'     ),
#'     appSpecContent = list(
#'       content = "string",
#'       sha256 = "string"
#'     )
#'   ),
#'   revisionInfo = list(
#'     description = "string",
#'     deploymentGroups = list(
#'       "string"
#'     ),
#'     firstUsedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lastUsedTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     registerTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_application_revision(
#'   applicationName = "string",
#'   revision = list(
#'     revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
#'     s3Location = list(
#'       bucket = "string",
#'       key = "string",
#'       bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
#'       version = "string",
#'       eTag = "string"
#'     ),
#'     gitHubLocation = list(
#'       repository = "string",
#'       commitId = "string"
#'     ),
#'     string = list(
#'       content = "string",
#'       sha256 = "string"
#'     ),
#'     appSpecContent = list(
#'       content = "string",
#'       sha256 = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_application_revision
codedeploy_get_application_revision <- function(applicationName, revision) {
  op <- new_operation(
    name = "GetApplicationRevision",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_application_revision_input(applicationName = applicationName, revision = revision)
  output <- .codedeploy$get_application_revision_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_application_revision <- codedeploy_get_application_revision

#' Gets information about a deployment
#'
#' @description
#' Gets information about a deployment.
#' 
#' The `content` property of the `appSpecContent` object in the returned
#' revision is always null. Use
#' [`get_application_revision`][codedeploy_get_application_revision] and
#' the `sha256` property of the returned `appSpecContent` object to get the
#' content of the deployment’s AppSpec file.
#'
#' @usage
#' codedeploy_get_deployment(deploymentId)
#'
#' @param deploymentId &#91;required&#93; The unique ID of a deployment associated with the IAM user or AWS
#' account.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   deploymentInfo = list(
#'     applicationName = "string",
#'     deploymentGroupName = "string",
#'     deploymentConfigName = "string",
#'     deploymentId = "string",
#'     previousRevision = list(
#'       revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
#'       s3Location = list(
#'         bucket = "string",
#'         key = "string",
#'         bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
#'         version = "string",
#'         eTag = "string"
#'       ),
#'       gitHubLocation = list(
#'         repository = "string",
#'         commitId = "string"
#'       ),
#'       string = list(
#'         content = "string",
#'         sha256 = "string"
#'       ),
#'       appSpecContent = list(
#'         content = "string",
#'         sha256 = "string"
#'       )
#'     ),
#'     revision = list(
#'       revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
#'       s3Location = list(
#'         bucket = "string",
#'         key = "string",
#'         bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
#'         version = "string",
#'         eTag = "string"
#'       ),
#'       gitHubLocation = list(
#'         repository = "string",
#'         commitId = "string"
#'       ),
#'       string = list(
#'         content = "string",
#'         sha256 = "string"
#'       ),
#'       appSpecContent = list(
#'         content = "string",
#'         sha256 = "string"
#'       )
#'     ),
#'     status = "Created"|"Queued"|"InProgress"|"Baking"|"Succeeded"|"Failed"|"Stopped"|"Ready",
#'     errorInformation = list(
#'       code = "AGENT_ISSUE"|"ALARM_ACTIVE"|"APPLICATION_MISSING"|"AUTOSCALING_VALIDATION_ERROR"|"AUTO_SCALING_CONFIGURATION"|"AUTO_SCALING_IAM_ROLE_PERMISSIONS"|"CODEDEPLOY_RESOURCE_CANNOT_BE_FOUND"|"CUSTOMER_APPLICATION_UNHEALTHY"|"DEPLOYMENT_GROUP_MISSING"|"ECS_UPDATE_ERROR"|"ELASTIC_LOAD_BALANCING_INVALID"|"ELB_INVALID_INSTANCE"|"HEALTH_CONSTRAINTS"|"HEALTH_CONSTRAINTS_INVALID"|"HOOK_EXECUTION_FAILURE"|"IAM_ROLE_MISSING"|"IAM_ROLE_PERMISSIONS"|"INTERNAL_ERROR"|"INVALID_ECS_SERVICE"|"INVALID_LAMBDA_CONFIGURATION"|"INVALID_LAMBDA_FUNCTION"|"INVALID_REVISION"|"MANUAL_STOP"|"MISSING_BLUE_GREEN_DEPLOYMENT_CONFIGURATION"|"MISSING_ELB_INFORMATION"|"MISSING_GITHUB_TOKEN"|"NO_EC2_SUBSCRIPTION"|"NO_INSTANCES"|"OVER_MAX_INSTANCES"|"RESOURCE_LIMIT_EXCEEDED"|"REVISION_MISSING"|"THROTTLED"|"TIMEOUT"|"CLOUDFORMATION_STACK_FAILURE",
#'       message = "string"
#'     ),
#'     createTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     startTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     completeTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     deploymentOverview = list(
#'       Pending = 123,
#'       InProgress = 123,
#'       Succeeded = 123,
#'       Failed = 123,
#'       Skipped = 123,
#'       Ready = 123
#'     ),
#'     description = "string",
#'     creator = "user"|"autoscaling"|"codeDeployRollback"|"CodeDeploy"|"CloudFormation"|"CloudFormationRollback",
#'     ignoreApplicationStopFailures = TRUE|FALSE,
#'     autoRollbackConfiguration = list(
#'       enabled = TRUE|FALSE,
#'       events = list(
#'         "DEPLOYMENT_FAILURE"|"DEPLOYMENT_STOP_ON_ALARM"|"DEPLOYMENT_STOP_ON_REQUEST"
#'       )
#'     ),
#'     updateOutdatedInstancesOnly = TRUE|FALSE,
#'     rollbackInfo = list(
#'       rollbackDeploymentId = "string",
#'       rollbackTriggeringDeploymentId = "string",
#'       rollbackMessage = "string"
#'     ),
#'     deploymentStyle = list(
#'       deploymentType = "IN_PLACE"|"BLUE_GREEN",
#'       deploymentOption = "WITH_TRAFFIC_CONTROL"|"WITHOUT_TRAFFIC_CONTROL"
#'     ),
#'     targetInstances = list(
#'       tagFilters = list(
#'         list(
#'           Key = "string",
#'           Value = "string",
#'           Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'         )
#'       ),
#'       autoScalingGroups = list(
#'         "string"
#'       ),
#'       ec2TagSet = list(
#'         ec2TagSetList = list(
#'           list(
#'             list(
#'               Key = "string",
#'               Value = "string",
#'               Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     instanceTerminationWaitTimeStarted = TRUE|FALSE,
#'     blueGreenDeploymentConfiguration = list(
#'       terminateBlueInstancesOnDeploymentSuccess = list(
#'         action = "TERMINATE"|"KEEP_ALIVE",
#'         terminationWaitTimeInMinutes = 123
#'       ),
#'       deploymentReadyOption = list(
#'         actionOnTimeout = "CONTINUE_DEPLOYMENT"|"STOP_DEPLOYMENT",
#'         waitTimeInMinutes = 123
#'       ),
#'       greenFleetProvisioningOption = list(
#'         action = "DISCOVER_EXISTING"|"COPY_AUTO_SCALING_GROUP"
#'       )
#'     ),
#'     loadBalancerInfo = list(
#'       elbInfoList = list(
#'         list(
#'           name = "string"
#'         )
#'       ),
#'       targetGroupInfoList = list(
#'         list(
#'           name = "string"
#'         )
#'       ),
#'       targetGroupPairInfoList = list(
#'         list(
#'           targetGroups = list(
#'             list(
#'               name = "string"
#'             )
#'           ),
#'           prodTrafficRoute = list(
#'             listenerArns = list(
#'               "string"
#'             )
#'           ),
#'           testTrafficRoute = list(
#'             listenerArns = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     additionalDeploymentStatusInfo = "string",
#'     fileExistsBehavior = "DISALLOW"|"OVERWRITE"|"RETAIN",
#'     deploymentStatusMessages = list(
#'       "string"
#'     ),
#'     computePlatform = "Server"|"Lambda"|"ECS",
#'     externalId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_deployment(
#'   deploymentId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_deployment
codedeploy_get_deployment <- function(deploymentId) {
  op <- new_operation(
    name = "GetDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_deployment_input(deploymentId = deploymentId)
  output <- .codedeploy$get_deployment_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_deployment <- codedeploy_get_deployment

#' Gets information about a deployment configuration
#'
#' @description
#' Gets information about a deployment configuration.
#'
#' @usage
#' codedeploy_get_deployment_config(deploymentConfigName)
#'
#' @param deploymentConfigName &#91;required&#93; The name of a deployment configuration associated with the IAM user or
#' AWS account.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   deploymentConfigInfo = list(
#'     deploymentConfigId = "string",
#'     deploymentConfigName = "string",
#'     minimumHealthyHosts = list(
#'       value = 123,
#'       type = "HOST_COUNT"|"FLEET_PERCENT"
#'     ),
#'     createTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     computePlatform = "Server"|"Lambda"|"ECS",
#'     trafficRoutingConfig = list(
#'       type = "TimeBasedCanary"|"TimeBasedLinear"|"AllAtOnce",
#'       timeBasedCanary = list(
#'         canaryPercentage = 123,
#'         canaryInterval = 123
#'       ),
#'       timeBasedLinear = list(
#'         linearPercentage = 123,
#'         linearInterval = 123
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_deployment_config(
#'   deploymentConfigName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_deployment_config
codedeploy_get_deployment_config <- function(deploymentConfigName) {
  op <- new_operation(
    name = "GetDeploymentConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_deployment_config_input(deploymentConfigName = deploymentConfigName)
  output <- .codedeploy$get_deployment_config_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_deployment_config <- codedeploy_get_deployment_config

#' Gets information about a deployment group
#'
#' @description
#' Gets information about a deployment group.
#'
#' @usage
#' codedeploy_get_deployment_group(applicationName, deploymentGroupName)
#'
#' @param applicationName &#91;required&#93; The name of an AWS CodeDeploy application associated with the IAM user
#' or AWS account.
#' @param deploymentGroupName &#91;required&#93; The name of a deployment group for the specified application.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   deploymentGroupInfo = list(
#'     applicationName = "string",
#'     deploymentGroupId = "string",
#'     deploymentGroupName = "string",
#'     deploymentConfigName = "string",
#'     ec2TagFilters = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'       )
#'     ),
#'     onPremisesInstanceTagFilters = list(
#'       list(
#'         Key = "string",
#'         Value = "string",
#'         Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'       )
#'     ),
#'     autoScalingGroups = list(
#'       list(
#'         name = "string",
#'         hook = "string"
#'       )
#'     ),
#'     serviceRoleArn = "string",
#'     targetRevision = list(
#'       revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
#'       s3Location = list(
#'         bucket = "string",
#'         key = "string",
#'         bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
#'         version = "string",
#'         eTag = "string"
#'       ),
#'       gitHubLocation = list(
#'         repository = "string",
#'         commitId = "string"
#'       ),
#'       string = list(
#'         content = "string",
#'         sha256 = "string"
#'       ),
#'       appSpecContent = list(
#'         content = "string",
#'         sha256 = "string"
#'       )
#'     ),
#'     triggerConfigurations = list(
#'       list(
#'         triggerName = "string",
#'         triggerTargetArn = "string",
#'         triggerEvents = list(
#'           "DeploymentStart"|"DeploymentSuccess"|"DeploymentFailure"|"DeploymentStop"|"DeploymentRollback"|"DeploymentReady"|"InstanceStart"|"InstanceSuccess"|"InstanceFailure"|"InstanceReady"
#'         )
#'       )
#'     ),
#'     alarmConfiguration = list(
#'       enabled = TRUE|FALSE,
#'       ignorePollAlarmFailure = TRUE|FALSE,
#'       alarms = list(
#'         list(
#'           name = "string"
#'         )
#'       )
#'     ),
#'     autoRollbackConfiguration = list(
#'       enabled = TRUE|FALSE,
#'       events = list(
#'         "DEPLOYMENT_FAILURE"|"DEPLOYMENT_STOP_ON_ALARM"|"DEPLOYMENT_STOP_ON_REQUEST"
#'       )
#'     ),
#'     deploymentStyle = list(
#'       deploymentType = "IN_PLACE"|"BLUE_GREEN",
#'       deploymentOption = "WITH_TRAFFIC_CONTROL"|"WITHOUT_TRAFFIC_CONTROL"
#'     ),
#'     blueGreenDeploymentConfiguration = list(
#'       terminateBlueInstancesOnDeploymentSuccess = list(
#'         action = "TERMINATE"|"KEEP_ALIVE",
#'         terminationWaitTimeInMinutes = 123
#'       ),
#'       deploymentReadyOption = list(
#'         actionOnTimeout = "CONTINUE_DEPLOYMENT"|"STOP_DEPLOYMENT",
#'         waitTimeInMinutes = 123
#'       ),
#'       greenFleetProvisioningOption = list(
#'         action = "DISCOVER_EXISTING"|"COPY_AUTO_SCALING_GROUP"
#'       )
#'     ),
#'     loadBalancerInfo = list(
#'       elbInfoList = list(
#'         list(
#'           name = "string"
#'         )
#'       ),
#'       targetGroupInfoList = list(
#'         list(
#'           name = "string"
#'         )
#'       ),
#'       targetGroupPairInfoList = list(
#'         list(
#'           targetGroups = list(
#'             list(
#'               name = "string"
#'             )
#'           ),
#'           prodTrafficRoute = list(
#'             listenerArns = list(
#'               "string"
#'             )
#'           ),
#'           testTrafficRoute = list(
#'             listenerArns = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     lastSuccessfulDeployment = list(
#'       deploymentId = "string",
#'       status = "Created"|"Queued"|"InProgress"|"Baking"|"Succeeded"|"Failed"|"Stopped"|"Ready",
#'       endTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       createTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     lastAttemptedDeployment = list(
#'       deploymentId = "string",
#'       status = "Created"|"Queued"|"InProgress"|"Baking"|"Succeeded"|"Failed"|"Stopped"|"Ready",
#'       endTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       createTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     ec2TagSet = list(
#'       ec2TagSetList = list(
#'         list(
#'           list(
#'             Key = "string",
#'             Value = "string",
#'             Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'           )
#'         )
#'       )
#'     ),
#'     onPremisesTagSet = list(
#'       onPremisesTagSetList = list(
#'         list(
#'           list(
#'             Key = "string",
#'             Value = "string",
#'             Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'           )
#'         )
#'       )
#'     ),
#'     computePlatform = "Server"|"Lambda"|"ECS",
#'     ecsServices = list(
#'       list(
#'         serviceName = "string",
#'         clusterName = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_deployment_group(
#'   applicationName = "string",
#'   deploymentGroupName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_deployment_group
codedeploy_get_deployment_group <- function(applicationName, deploymentGroupName) {
  op <- new_operation(
    name = "GetDeploymentGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_deployment_group_input(applicationName = applicationName, deploymentGroupName = deploymentGroupName)
  output <- .codedeploy$get_deployment_group_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_deployment_group <- codedeploy_get_deployment_group

#' Gets information about an instance as part of a deployment
#'
#' @description
#' Gets information about an instance as part of a deployment.
#'
#' @usage
#' codedeploy_get_deployment_instance(deploymentId, instanceId)
#'
#' @param deploymentId &#91;required&#93; The unique ID of a deployment.
#' @param instanceId &#91;required&#93; The unique ID of an instance in the deployment group.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   instanceSummary = list(
#'     deploymentId = "string",
#'     instanceId = "string",
#'     status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
#'     lastUpdatedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     lifecycleEvents = list(
#'       list(
#'         lifecycleEventName = "string",
#'         diagnostics = list(
#'           errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
#'           scriptName = "string",
#'           message = "string",
#'           logTail = "string"
#'         ),
#'         startTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         endTime = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
#'       )
#'     ),
#'     instanceType = "Blue"|"Green"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_deployment_instance(
#'   deploymentId = "string",
#'   instanceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_deployment_instance
codedeploy_get_deployment_instance <- function(deploymentId, instanceId) {
  op <- new_operation(
    name = "GetDeploymentInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_deployment_instance_input(deploymentId = deploymentId, instanceId = instanceId)
  output <- .codedeploy$get_deployment_instance_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_deployment_instance <- codedeploy_get_deployment_instance

#' Returns information about a deployment target
#'
#' @description
#' Returns information about a deployment target.
#'
#' @usage
#' codedeploy_get_deployment_target(deploymentId, targetId)
#'
#' @param deploymentId The unique ID of a deployment.
#' @param targetId The unique ID of a deployment target.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   deploymentTarget = list(
#'     deploymentTargetType = "InstanceTarget"|"LambdaTarget"|"ECSTarget"|"CloudFormationTarget",
#'     instanceTarget = list(
#'       deploymentId = "string",
#'       targetId = "string",
#'       targetArn = "string",
#'       status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lifecycleEvents = list(
#'         list(
#'           lifecycleEventName = "string",
#'           diagnostics = list(
#'             errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
#'             scriptName = "string",
#'             message = "string",
#'             logTail = "string"
#'           ),
#'           startTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           endTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
#'         )
#'       ),
#'       instanceLabel = "Blue"|"Green"
#'     ),
#'     lambdaTarget = list(
#'       deploymentId = "string",
#'       targetId = "string",
#'       targetArn = "string",
#'       status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lifecycleEvents = list(
#'         list(
#'           lifecycleEventName = "string",
#'           diagnostics = list(
#'             errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
#'             scriptName = "string",
#'             message = "string",
#'             logTail = "string"
#'           ),
#'           startTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           endTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
#'         )
#'       ),
#'       lambdaFunctionInfo = list(
#'         functionName = "string",
#'         functionAlias = "string",
#'         currentVersion = "string",
#'         targetVersion = "string",
#'         targetVersionWeight = 123.0
#'       )
#'     ),
#'     ecsTarget = list(
#'       deploymentId = "string",
#'       targetId = "string",
#'       targetArn = "string",
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lifecycleEvents = list(
#'         list(
#'           lifecycleEventName = "string",
#'           diagnostics = list(
#'             errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
#'             scriptName = "string",
#'             message = "string",
#'             logTail = "string"
#'           ),
#'           startTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           endTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
#'         )
#'       ),
#'       status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
#'       taskSetsInfo = list(
#'         list(
#'           identifer = "string",
#'           desiredCount = 123,
#'           pendingCount = 123,
#'           runningCount = 123,
#'           status = "string",
#'           trafficWeight = 123.0,
#'           targetGroup = list(
#'             name = "string"
#'           ),
#'           taskSetLabel = "Blue"|"Green"
#'         )
#'       )
#'     ),
#'     cloudFormationTarget = list(
#'       deploymentId = "string",
#'       targetId = "string",
#'       lastUpdatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lifecycleEvents = list(
#'         list(
#'           lifecycleEventName = "string",
#'           diagnostics = list(
#'             errorCode = "Success"|"ScriptMissing"|"ScriptNotExecutable"|"ScriptTimedOut"|"ScriptFailed"|"UnknownError",
#'             scriptName = "string",
#'             message = "string",
#'             logTail = "string"
#'           ),
#'           startTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           endTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
#'         )
#'       ),
#'       status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready",
#'       resourceType = "string",
#'       targetVersionWeight = 123.0
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_deployment_target(
#'   deploymentId = "string",
#'   targetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_deployment_target
codedeploy_get_deployment_target <- function(deploymentId = NULL, targetId = NULL) {
  op <- new_operation(
    name = "GetDeploymentTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_deployment_target_input(deploymentId = deploymentId, targetId = targetId)
  output <- .codedeploy$get_deployment_target_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_deployment_target <- codedeploy_get_deployment_target

#' Gets information about an on-premises instance
#'
#' @description
#' Gets information about an on-premises instance.
#'
#' @usage
#' codedeploy_get_on_premises_instance(instanceName)
#'
#' @param instanceName &#91;required&#93; The name of the on-premises instance about which to get information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   instanceInfo = list(
#'     instanceName = "string",
#'     iamSessionArn = "string",
#'     iamUserArn = "string",
#'     instanceArn = "string",
#'     registerTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     deregisterTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     tags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_on_premises_instance(
#'   instanceName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_get_on_premises_instance
codedeploy_get_on_premises_instance <- function(instanceName) {
  op <- new_operation(
    name = "GetOnPremisesInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$get_on_premises_instance_input(instanceName = instanceName)
  output <- .codedeploy$get_on_premises_instance_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$get_on_premises_instance <- codedeploy_get_on_premises_instance

#' Lists information about revisions for an application
#'
#' @description
#' Lists information about revisions for an application.
#'
#' @usage
#' codedeploy_list_application_revisions(applicationName, sortBy,
#'   sortOrder, s3Bucket, s3KeyPrefix, deployed, nextToken)
#'
#' @param applicationName &#91;required&#93; The name of an AWS CodeDeploy application associated with the IAM user
#' or AWS account.
#' @param sortBy The column name to use to sort the list results:
#' 
#' -   `registerTime`: Sort by the time the revisions were registered with
#'     AWS CodeDeploy.
#' 
#' -   `firstUsedTime`: Sort by the time the revisions were first used in a
#'     deployment.
#' 
#' -   `lastUsedTime`: Sort by the time the revisions were last used in a
#'     deployment.
#' 
#' If not specified or set to null, the results are returned in an
#' arbitrary order.
#' @param sortOrder The order in which to sort the list results:
#' 
#' -   `ascending`: ascending order.
#' 
#' -   `descending`: descending order.
#' 
#' If not specified, the results are sorted in ascending order.
#' 
#' If set to null, the results are sorted in an arbitrary order.
#' @param s3Bucket An Amazon S3 bucket name to limit the search for revisions.
#' 
#' If set to null, all of the user's buckets are searched.
#' @param s3KeyPrefix A key prefix for the set of Amazon S3 objects to limit the search for
#' revisions.
#' @param deployed Whether to list revisions based on whether the revision is the target
#' revision of a deployment group:
#' 
#' -   `include`: List revisions that are target revisions of a deployment
#'     group.
#' 
#' -   `exclude`: Do not list revisions that are target revisions of a
#'     deployment group.
#' 
#' -   `ignore`: List all revisions.
#' @param nextToken An identifier returned from the previous
#' [`list_application_revisions`][codedeploy_list_application_revisions]
#' call. It can be used to return the next set of applications in the list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   revisions = list(
#'     list(
#'       revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
#'       s3Location = list(
#'         bucket = "string",
#'         key = "string",
#'         bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
#'         version = "string",
#'         eTag = "string"
#'       ),
#'       gitHubLocation = list(
#'         repository = "string",
#'         commitId = "string"
#'       ),
#'       string = list(
#'         content = "string",
#'         sha256 = "string"
#'       ),
#'       appSpecContent = list(
#'         content = "string",
#'         sha256 = "string"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_application_revisions(
#'   applicationName = "string",
#'   sortBy = "registerTime"|"firstUsedTime"|"lastUsedTime",
#'   sortOrder = "ascending"|"descending",
#'   s3Bucket = "string",
#'   s3KeyPrefix = "string",
#'   deployed = "include"|"exclude"|"ignore",
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_application_revisions
codedeploy_list_application_revisions <- function(applicationName, sortBy = NULL, sortOrder = NULL, s3Bucket = NULL, s3KeyPrefix = NULL, deployed = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListApplicationRevisions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_application_revisions_input(applicationName = applicationName, sortBy = sortBy, sortOrder = sortOrder, s3Bucket = s3Bucket, s3KeyPrefix = s3KeyPrefix, deployed = deployed, nextToken = nextToken)
  output <- .codedeploy$list_application_revisions_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_application_revisions <- codedeploy_list_application_revisions

#' Lists the applications registered with the IAM user or AWS account
#'
#' @description
#' Lists the applications registered with the IAM user or AWS account.
#'
#' @usage
#' codedeploy_list_applications(nextToken)
#'
#' @param nextToken An identifier returned from the previous list applications call. It can
#' be used to return the next set of applications in the list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   applications = list(
#'     "string"
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_applications(
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_applications
codedeploy_list_applications <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_applications_input(nextToken = nextToken)
  output <- .codedeploy$list_applications_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_applications <- codedeploy_list_applications

#' Lists the deployment configurations with the IAM user or AWS account
#'
#' @description
#' Lists the deployment configurations with the IAM user or AWS account.
#'
#' @usage
#' codedeploy_list_deployment_configs(nextToken)
#'
#' @param nextToken An identifier returned from the previous
#' [`list_deployment_configs`][codedeploy_list_deployment_configs] call. It
#' can be used to return the next set of deployment configurations in the
#' list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   deploymentConfigsList = list(
#'     "string"
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_deployment_configs(
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_deployment_configs
codedeploy_list_deployment_configs <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListDeploymentConfigs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_deployment_configs_input(nextToken = nextToken)
  output <- .codedeploy$list_deployment_configs_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_deployment_configs <- codedeploy_list_deployment_configs

#' Lists the deployment groups for an application registered with the IAM
#' user or AWS account
#'
#' @description
#' Lists the deployment groups for an application registered with the IAM
#' user or AWS account.
#'
#' @usage
#' codedeploy_list_deployment_groups(applicationName, nextToken)
#'
#' @param applicationName &#91;required&#93; The name of an AWS CodeDeploy application associated with the IAM user
#' or AWS account.
#' @param nextToken An identifier returned from the previous list deployment groups call. It
#' can be used to return the next set of deployment groups in the list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   applicationName = "string",
#'   deploymentGroups = list(
#'     "string"
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_deployment_groups(
#'   applicationName = "string",
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_deployment_groups
codedeploy_list_deployment_groups <- function(applicationName, nextToken = NULL) {
  op <- new_operation(
    name = "ListDeploymentGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_deployment_groups_input(applicationName = applicationName, nextToken = nextToken)
  output <- .codedeploy$list_deployment_groups_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_deployment_groups <- codedeploy_list_deployment_groups

#' The newer BatchGetDeploymentTargets should be used instead because it
#' works with all compute types
#'
#' @description
#' The newer
#' [`batch_get_deployment_targets`][codedeploy_batch_get_deployment_targets]
#' should be used instead because it works with all compute types.
#' [`list_deployment_instances`][codedeploy_list_deployment_instances]
#' throws an exception if it is used with a compute platform other than
#' EC2/On-premises or AWS Lambda.
#' 
#' Lists the instance for a deployment associated with the IAM user or AWS
#' account.
#'
#' @usage
#' codedeploy_list_deployment_instances(deploymentId, nextToken,
#'   instanceStatusFilter, instanceTypeFilter)
#'
#' @param deploymentId &#91;required&#93; The unique ID of a deployment.
#' @param nextToken An identifier returned from the previous list deployment instances call.
#' It can be used to return the next set of deployment instances in the
#' list.
#' @param instanceStatusFilter A subset of instances to list by status:
#' 
#' -   `Pending`: Include those instances with pending deployments.
#' 
#' -   `InProgress`: Include those instances where deployments are still in
#'     progress.
#' 
#' -   `Succeeded`: Include those instances with successful deployments.
#' 
#' -   `Failed`: Include those instances with failed deployments.
#' 
#' -   `Skipped`: Include those instances with skipped deployments.
#' 
#' -   `Unknown`: Include those instances with deployments in an unknown
#'     state.
#' @param instanceTypeFilter The set of instances in a blue/green deployment, either those in the
#' original environment ("BLUE") or those in the replacement environment
#' ("GREEN"), for which you want to view instance information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   instancesList = list(
#'     "string"
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_deployment_instances(
#'   deploymentId = "string",
#'   nextToken = "string",
#'   instanceStatusFilter = list(
#'     "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"|"Ready"
#'   ),
#'   instanceTypeFilter = list(
#'     "Blue"|"Green"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_deployment_instances
codedeploy_list_deployment_instances <- function(deploymentId, nextToken = NULL, instanceStatusFilter = NULL, instanceTypeFilter = NULL) {
  op <- new_operation(
    name = "ListDeploymentInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_deployment_instances_input(deploymentId = deploymentId, nextToken = nextToken, instanceStatusFilter = instanceStatusFilter, instanceTypeFilter = instanceTypeFilter)
  output <- .codedeploy$list_deployment_instances_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_deployment_instances <- codedeploy_list_deployment_instances

#' Returns an array of target IDs that are associated a deployment
#'
#' @description
#' Returns an array of target IDs that are associated a deployment.
#'
#' @usage
#' codedeploy_list_deployment_targets(deploymentId, nextToken,
#'   targetFilters)
#'
#' @param deploymentId The unique ID of a deployment.
#' @param nextToken A token identifier returned from the previous
#' [`list_deployment_targets`][codedeploy_list_deployment_targets] call. It
#' can be used to return the next set of deployment targets in the list.
#' @param targetFilters A key used to filter the returned targets. The two valid values are:
#' 
#' -   `TargetStatus` - A `TargetStatus` filter string can be `Failed`,
#'     `InProgress`, `Pending`, `Ready`, `Skipped`, `Succeeded`, or
#'     `Unknown`.
#' 
#' -   `ServerInstanceLabel` - A `ServerInstanceLabel` filter string can be
#'     `Blue` or `Green`.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   targetIds = list(
#'     "string"
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_deployment_targets(
#'   deploymentId = "string",
#'   nextToken = "string",
#'   targetFilters = list(
#'     list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_deployment_targets
codedeploy_list_deployment_targets <- function(deploymentId = NULL, nextToken = NULL, targetFilters = NULL) {
  op <- new_operation(
    name = "ListDeploymentTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_deployment_targets_input(deploymentId = deploymentId, nextToken = nextToken, targetFilters = targetFilters)
  output <- .codedeploy$list_deployment_targets_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_deployment_targets <- codedeploy_list_deployment_targets

#' Lists the deployments in a deployment group for an application
#' registered with the IAM user or AWS account
#'
#' @description
#' Lists the deployments in a deployment group for an application
#' registered with the IAM user or AWS account.
#'
#' @usage
#' codedeploy_list_deployments(applicationName, deploymentGroupName,
#'   externalId, includeOnlyStatuses, createTimeRange, nextToken)
#'
#' @param applicationName The name of an AWS CodeDeploy application associated with the IAM user
#' or AWS account.
#' 
#' If `applicationName` is specified, then `deploymentGroupName` must be
#' specified. If it is not specified, then `deploymentGroupName` must not
#' be specified.
#' @param deploymentGroupName The name of a deployment group for the specified application.
#' 
#' If `deploymentGroupName` is specified, then `applicationName` must be
#' specified. If it is not specified, then `applicationName` must not be
#' specified.
#' @param externalId The unique ID of an external resource for returning deployments linked
#' to the external resource.
#' @param includeOnlyStatuses A subset of deployments to list by status:
#' 
#' -   `Created`: Include created deployments in the resulting list.
#' 
#' -   `Queued`: Include queued deployments in the resulting list.
#' 
#' -   `In Progress`: Include in-progress deployments in the resulting
#'     list.
#' 
#' -   `Succeeded`: Include successful deployments in the resulting list.
#' 
#' -   `Failed`: Include failed deployments in the resulting list.
#' 
#' -   `Stopped`: Include stopped deployments in the resulting list.
#' @param createTimeRange A time range (start and end) for returning a subset of the list of
#' deployments.
#' @param nextToken An identifier returned from the previous list deployments call. It can
#' be used to return the next set of deployments in the list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   deployments = list(
#'     "string"
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_deployments(
#'   applicationName = "string",
#'   deploymentGroupName = "string",
#'   externalId = "string",
#'   includeOnlyStatuses = list(
#'     "Created"|"Queued"|"InProgress"|"Baking"|"Succeeded"|"Failed"|"Stopped"|"Ready"
#'   ),
#'   createTimeRange = list(
#'     start = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     end = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_deployments
codedeploy_list_deployments <- function(applicationName = NULL, deploymentGroupName = NULL, externalId = NULL, includeOnlyStatuses = NULL, createTimeRange = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListDeployments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_deployments_input(applicationName = applicationName, deploymentGroupName = deploymentGroupName, externalId = externalId, includeOnlyStatuses = includeOnlyStatuses, createTimeRange = createTimeRange, nextToken = nextToken)
  output <- .codedeploy$list_deployments_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_deployments <- codedeploy_list_deployments

#' Lists the names of stored connections to GitHub accounts
#'
#' @description
#' Lists the names of stored connections to GitHub accounts.
#'
#' @usage
#' codedeploy_list_git_hub_account_token_names(nextToken)
#'
#' @param nextToken An identifier returned from the previous
#' [`list_git_hub_account_token_names`][codedeploy_list_git_hub_account_token_names]
#' call. It can be used to return the next set of names in the list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   tokenNameList = list(
#'     "string"
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_git_hub_account_token_names(
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_git_hub_account_token_names
codedeploy_list_git_hub_account_token_names <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListGitHubAccountTokenNames",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_git_hub_account_token_names_input(nextToken = nextToken)
  output <- .codedeploy$list_git_hub_account_token_names_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_git_hub_account_token_names <- codedeploy_list_git_hub_account_token_names

#' Gets a list of names for one or more on-premises instances
#'
#' @description
#' Gets a list of names for one or more on-premises instances.
#' 
#' Unless otherwise specified, both registered and deregistered on-premises
#' instance names are listed. To list only registered or deregistered
#' on-premises instance names, use the registration status parameter.
#'
#' @usage
#' codedeploy_list_on_premises_instances(registrationStatus, tagFilters,
#'   nextToken)
#'
#' @param registrationStatus The registration status of the on-premises instances:
#' 
#' -   `Deregistered`: Include deregistered on-premises instances in the
#'     resulting list.
#' 
#' -   `Registered`: Include registered on-premises instances in the
#'     resulting list.
#' @param tagFilters The on-premises instance tags that are used to restrict the on-premises
#' instance names returned.
#' @param nextToken An identifier returned from the previous list on-premises instances
#' call. It can be used to return the next set of on-premises instances in
#' the list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   instanceNames = list(
#'     "string"
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_on_premises_instances(
#'   registrationStatus = "Registered"|"Deregistered",
#'   tagFilters = list(
#'     list(
#'       Key = "string",
#'       Value = "string",
#'       Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_on_premises_instances
codedeploy_list_on_premises_instances <- function(registrationStatus = NULL, tagFilters = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListOnPremisesInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_on_premises_instances_input(registrationStatus = registrationStatus, tagFilters = tagFilters, nextToken = nextToken)
  output <- .codedeploy$list_on_premises_instances_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_on_premises_instances <- codedeploy_list_on_premises_instances

#' Returns a list of tags for the resource identified by a specified Amazon
#' Resource Name (ARN)
#'
#' @description
#' Returns a list of tags for the resource identified by a specified Amazon
#' Resource Name (ARN). Tags are used to organize and categorize your
#' CodeDeploy resources.
#'
#' @usage
#' codedeploy_list_tags_for_resource(ResourceArn, NextToken)
#'
#' @param ResourceArn &#91;required&#93; The ARN of a CodeDeploy resource.
#' [`list_tags_for_resource`][codedeploy_list_tags_for_resource] returns
#' all the tags associated with the resource that is identified by the
#' `ResourceArn`.
#' @param NextToken An identifier returned from the previous
#' [`list_tags_for_resource`][codedeploy_list_tags_for_resource] call. It
#' can be used to return the next set of applications in the list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_list_tags_for_resource
codedeploy_list_tags_for_resource <- function(ResourceArn, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$list_tags_for_resource_input(ResourceArn = ResourceArn, NextToken = NextToken)
  output <- .codedeploy$list_tags_for_resource_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$list_tags_for_resource <- codedeploy_list_tags_for_resource

#' Sets the result of a Lambda validation function
#'
#' @description
#' Sets the result of a Lambda validation function. The function validates
#' lifecycle hooks during a deployment that uses the AWS Lambda or Amazon
#' ECS compute platform. For AWS Lambda deployments, the available
#' lifecycle hooks are `BeforeAllowTraffic` and `AfterAllowTraffic`. For
#' Amazon ECS deployments, the available lifecycle hooks are
#' `BeforeInstall`, `AfterInstall`, `AfterAllowTestTraffic`,
#' `BeforeAllowTraffic`, and `AfterAllowTraffic`. Lambda validation
#' functions return `Succeeded` or `Failed`. For more information, see
#' [AppSpec 'hooks' Section for an AWS Lambda
#' Deployment](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-lambda)
#' and [AppSpec 'hooks' Section for an Amazon ECS
#' Deployment](https://docs.aws.amazon.com/codedeploy/latest/userguide/reference-appspec-file-structure-hooks.html#appspec-hooks-ecs).
#'
#' @usage
#' codedeploy_put_lifecycle_event_hook_execution_status(deploymentId,
#'   lifecycleEventHookExecutionId, status)
#'
#' @param deploymentId The unique ID of a deployment. Pass this ID to a Lambda function that
#' validates a deployment lifecycle event.
#' @param lifecycleEventHookExecutionId The execution ID of a deployment's lifecycle hook. A deployment
#' lifecycle hook is specified in the `hooks` section of the AppSpec file.
#' @param status The result of a Lambda function that validates a deployment lifecycle
#' event (`Succeeded` or `Failed`).
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   lifecycleEventHookExecutionId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_lifecycle_event_hook_execution_status(
#'   deploymentId = "string",
#'   lifecycleEventHookExecutionId = "string",
#'   status = "Pending"|"InProgress"|"Succeeded"|"Failed"|"Skipped"|"Unknown"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_put_lifecycle_event_hook_execution_status
codedeploy_put_lifecycle_event_hook_execution_status <- function(deploymentId = NULL, lifecycleEventHookExecutionId = NULL, status = NULL) {
  op <- new_operation(
    name = "PutLifecycleEventHookExecutionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$put_lifecycle_event_hook_execution_status_input(deploymentId = deploymentId, lifecycleEventHookExecutionId = lifecycleEventHookExecutionId, status = status)
  output <- .codedeploy$put_lifecycle_event_hook_execution_status_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$put_lifecycle_event_hook_execution_status <- codedeploy_put_lifecycle_event_hook_execution_status

#' Registers with AWS CodeDeploy a revision for the specified application
#'
#' @description
#' Registers with AWS CodeDeploy a revision for the specified application.
#'
#' @usage
#' codedeploy_register_application_revision(applicationName, description,
#'   revision)
#'
#' @param applicationName &#91;required&#93; The name of an AWS CodeDeploy application associated with the IAM user
#' or AWS account.
#' @param description A comment about the revision.
#' @param revision &#91;required&#93; Information about the application revision to register, including type
#' and location.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$register_application_revision(
#'   applicationName = "string",
#'   description = "string",
#'   revision = list(
#'     revisionType = "S3"|"GitHub"|"String"|"AppSpecContent",
#'     s3Location = list(
#'       bucket = "string",
#'       key = "string",
#'       bundleType = "tar"|"tgz"|"zip"|"YAML"|"JSON",
#'       version = "string",
#'       eTag = "string"
#'     ),
#'     gitHubLocation = list(
#'       repository = "string",
#'       commitId = "string"
#'     ),
#'     string = list(
#'       content = "string",
#'       sha256 = "string"
#'     ),
#'     appSpecContent = list(
#'       content = "string",
#'       sha256 = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_register_application_revision
codedeploy_register_application_revision <- function(applicationName, description = NULL, revision) {
  op <- new_operation(
    name = "RegisterApplicationRevision",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$register_application_revision_input(applicationName = applicationName, description = description, revision = revision)
  output <- .codedeploy$register_application_revision_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$register_application_revision <- codedeploy_register_application_revision

#' Registers an on-premises instance
#'
#' @description
#' Registers an on-premises instance.
#' 
#' Only one IAM ARN (an IAM session ARN or IAM user ARN) is supported in
#' the request. You cannot use both.
#'
#' @usage
#' codedeploy_register_on_premises_instance(instanceName, iamSessionArn,
#'   iamUserArn)
#'
#' @param instanceName &#91;required&#93; The name of the on-premises instance to register.
#' @param iamSessionArn The ARN of the IAM session to associate with the on-premises instance.
#' @param iamUserArn The ARN of the IAM user to associate with the on-premises instance.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$register_on_premises_instance(
#'   instanceName = "string",
#'   iamSessionArn = "string",
#'   iamUserArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_register_on_premises_instance
codedeploy_register_on_premises_instance <- function(instanceName, iamSessionArn = NULL, iamUserArn = NULL) {
  op <- new_operation(
    name = "RegisterOnPremisesInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$register_on_premises_instance_input(instanceName = instanceName, iamSessionArn = iamSessionArn, iamUserArn = iamUserArn)
  output <- .codedeploy$register_on_premises_instance_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$register_on_premises_instance <- codedeploy_register_on_premises_instance

#' Removes one or more tags from one or more on-premises instances
#'
#' @description
#' Removes one or more tags from one or more on-premises instances.
#'
#' @usage
#' codedeploy_remove_tags_from_on_premises_instances(tags, instanceNames)
#'
#' @param tags &#91;required&#93; The tag key-value pairs to remove from the on-premises instances.
#' @param instanceNames &#91;required&#93; The names of the on-premises instances from which to remove tags.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags_from_on_premises_instances(
#'   tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   instanceNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_remove_tags_from_on_premises_instances
codedeploy_remove_tags_from_on_premises_instances <- function(tags, instanceNames) {
  op <- new_operation(
    name = "RemoveTagsFromOnPremisesInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$remove_tags_from_on_premises_instances_input(tags = tags, instanceNames = instanceNames)
  output <- .codedeploy$remove_tags_from_on_premises_instances_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$remove_tags_from_on_premises_instances <- codedeploy_remove_tags_from_on_premises_instances

#' In a blue/green deployment, overrides any specified wait time and starts
#' terminating instances immediately after the traffic routing is complete
#'
#' @description
#' In a blue/green deployment, overrides any specified wait time and starts
#' terminating instances immediately after the traffic routing is complete.
#'
#' @usage
#' codedeploy_skip_wait_time_for_instance_termination(deploymentId)
#'
#' @param deploymentId The unique ID of a blue/green deployment for which you want to skip the
#' instance termination wait time.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$skip_wait_time_for_instance_termination(
#'   deploymentId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_skip_wait_time_for_instance_termination
codedeploy_skip_wait_time_for_instance_termination <- function(deploymentId = NULL) {
  op <- new_operation(
    name = "SkipWaitTimeForInstanceTermination",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$skip_wait_time_for_instance_termination_input(deploymentId = deploymentId)
  output <- .codedeploy$skip_wait_time_for_instance_termination_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$skip_wait_time_for_instance_termination <- codedeploy_skip_wait_time_for_instance_termination

#' Attempts to stop an ongoing deployment
#'
#' @description
#' Attempts to stop an ongoing deployment.
#'
#' @usage
#' codedeploy_stop_deployment(deploymentId, autoRollbackEnabled)
#'
#' @param deploymentId &#91;required&#93; The unique ID of a deployment.
#' @param autoRollbackEnabled Indicates, when a deployment is stopped, whether instances that have
#' been updated should be rolled back to the previous version of the
#' application revision.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   status = "Pending"|"Succeeded",
#'   statusMessage = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$stop_deployment(
#'   deploymentId = "string",
#'   autoRollbackEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_stop_deployment
codedeploy_stop_deployment <- function(deploymentId, autoRollbackEnabled = NULL) {
  op <- new_operation(
    name = "StopDeployment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$stop_deployment_input(deploymentId = deploymentId, autoRollbackEnabled = autoRollbackEnabled)
  output <- .codedeploy$stop_deployment_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$stop_deployment <- codedeploy_stop_deployment

#' Associates the list of tags in the input Tags parameter with the
#' resource identified by the ResourceArn input parameter
#'
#' @description
#' Associates the list of tags in the input `Tags` parameter with the
#' resource identified by the `ResourceArn` input parameter.
#'
#' @usage
#' codedeploy_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; The ARN of a resource, such as a CodeDeploy application or deployment
#' group.
#' @param Tags &#91;required&#93; A list of tags that [`tag_resource`][codedeploy_tag_resource] associates
#' with a resource. The resource is identified by the `ResourceArn` input
#' parameter.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_tag_resource
codedeploy_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .codedeploy$tag_resource_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$tag_resource <- codedeploy_tag_resource

#' Disassociates a resource from a list of tags
#'
#' @description
#' Disassociates a resource from a list of tags. The resource is identified
#' by the `ResourceArn` input parameter. The tags are identified by the
#' list of keys in the `TagKeys` input parameter.
#'
#' @usage
#' codedeploy_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) that specifies from which resource to
#' disassociate the tags with the keys in the `TagKeys` input parameter.
#' @param TagKeys &#91;required&#93; A list of keys of `Tag` objects. The `Tag` objects identified by the
#' keys are disassociated from the resource specified by the `ResourceArn`
#' input parameter.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_untag_resource
codedeploy_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .codedeploy$untag_resource_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$untag_resource <- codedeploy_untag_resource

#' Changes the name of an application
#'
#' @description
#' Changes the name of an application.
#'
#' @usage
#' codedeploy_update_application(applicationName, newApplicationName)
#'
#' @param applicationName The current name of the application you want to change.
#' @param newApplicationName The new name to give the application.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_application(
#'   applicationName = "string",
#'   newApplicationName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_update_application
codedeploy_update_application <- function(applicationName = NULL, newApplicationName = NULL) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$update_application_input(applicationName = applicationName, newApplicationName = newApplicationName)
  output <- .codedeploy$update_application_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$update_application <- codedeploy_update_application

#' Changes information about a deployment group
#'
#' @description
#' Changes information about a deployment group.
#'
#' @usage
#' codedeploy_update_deployment_group(applicationName,
#'   currentDeploymentGroupName, newDeploymentGroupName,
#'   deploymentConfigName, ec2TagFilters, onPremisesInstanceTagFilters,
#'   autoScalingGroups, serviceRoleArn, triggerConfigurations,
#'   alarmConfiguration, autoRollbackConfiguration, deploymentStyle,
#'   blueGreenDeploymentConfiguration, loadBalancerInfo, ec2TagSet,
#'   ecsServices, onPremisesTagSet)
#'
#' @param applicationName &#91;required&#93; The application name that corresponds to the deployment group to update.
#' @param currentDeploymentGroupName &#91;required&#93; The current name of the deployment group.
#' @param newDeploymentGroupName The new name of the deployment group, if you want to change it.
#' @param deploymentConfigName The replacement deployment configuration name to use, if you want to
#' change it.
#' @param ec2TagFilters The replacement set of Amazon EC2 tags on which to filter, if you want
#' to change them. To keep the existing tags, enter their names. To remove
#' tags, do not enter any tag names.
#' @param onPremisesInstanceTagFilters The replacement set of on-premises instance tags on which to filter, if
#' you want to change them. To keep the existing tags, enter their names.
#' To remove tags, do not enter any tag names.
#' @param autoScalingGroups The replacement list of Auto Scaling groups to be included in the
#' deployment group, if you want to change them. To keep the Auto Scaling
#' groups, enter their names. To remove Auto Scaling groups, do not enter
#' any Auto Scaling group names.
#' @param serviceRoleArn A replacement ARN for the service role, if you want to change it.
#' @param triggerConfigurations Information about triggers to change when the deployment group is
#' updated. For examples, see [Edit a Trigger in a CodeDeploy Deployment
#' Group](https://docs.aws.amazon.com/codedeploy/latest/userguide/monitoring-sns-event-notifications-edit-trigger.html)
#' in the *AWS CodeDeploy User Guide*.
#' @param alarmConfiguration Information to add or change about Amazon CloudWatch alarms when the
#' deployment group is updated.
#' @param autoRollbackConfiguration Information for an automatic rollback configuration that is added or
#' changed when a deployment group is updated.
#' @param deploymentStyle Information about the type of deployment, either in-place or blue/green,
#' you want to run and whether to route deployment traffic behind a load
#' balancer.
#' @param blueGreenDeploymentConfiguration Information about blue/green deployment options for a deployment group.
#' @param loadBalancerInfo Information about the load balancer used in a deployment.
#' @param ec2TagSet Information about groups of tags applied to on-premises instances. The
#' deployment group includes only EC2 instances identified by all the tag
#' groups.
#' @param ecsServices The target Amazon ECS services in the deployment group. This applies
#' only to deployment groups that use the Amazon ECS compute platform. A
#' target Amazon ECS service is specified as an Amazon ECS cluster and
#' service name pair using the format `<clustername>:<servicename>`.
#' @param onPremisesTagSet Information about an on-premises instance tag set. The deployment group
#' includes only on-premises instances identified by all the tag groups.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   hooksNotCleanedUp = list(
#'     list(
#'       name = "string",
#'       hook = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_deployment_group(
#'   applicationName = "string",
#'   currentDeploymentGroupName = "string",
#'   newDeploymentGroupName = "string",
#'   deploymentConfigName = "string",
#'   ec2TagFilters = list(
#'     list(
#'       Key = "string",
#'       Value = "string",
#'       Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'     )
#'   ),
#'   onPremisesInstanceTagFilters = list(
#'     list(
#'       Key = "string",
#'       Value = "string",
#'       Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'     )
#'   ),
#'   autoScalingGroups = list(
#'     "string"
#'   ),
#'   serviceRoleArn = "string",
#'   triggerConfigurations = list(
#'     list(
#'       triggerName = "string",
#'       triggerTargetArn = "string",
#'       triggerEvents = list(
#'         "DeploymentStart"|"DeploymentSuccess"|"DeploymentFailure"|"DeploymentStop"|"DeploymentRollback"|"DeploymentReady"|"InstanceStart"|"InstanceSuccess"|"InstanceFailure"|"InstanceReady"
#'       )
#'     )
#'   ),
#'   alarmConfiguration = list(
#'     enabled = TRUE|FALSE,
#'     ignorePollAlarmFailure = TRUE|FALSE,
#'     alarms = list(
#'       list(
#'         name = "string"
#'       )
#'     )
#'   ),
#'   autoRollbackConfiguration = list(
#'     enabled = TRUE|FALSE,
#'     events = list(
#'       "DEPLOYMENT_FAILURE"|"DEPLOYMENT_STOP_ON_ALARM"|"DEPLOYMENT_STOP_ON_REQUEST"
#'     )
#'   ),
#'   deploymentStyle = list(
#'     deploymentType = "IN_PLACE"|"BLUE_GREEN",
#'     deploymentOption = "WITH_TRAFFIC_CONTROL"|"WITHOUT_TRAFFIC_CONTROL"
#'   ),
#'   blueGreenDeploymentConfiguration = list(
#'     terminateBlueInstancesOnDeploymentSuccess = list(
#'       action = "TERMINATE"|"KEEP_ALIVE",
#'       terminationWaitTimeInMinutes = 123
#'     ),
#'     deploymentReadyOption = list(
#'       actionOnTimeout = "CONTINUE_DEPLOYMENT"|"STOP_DEPLOYMENT",
#'       waitTimeInMinutes = 123
#'     ),
#'     greenFleetProvisioningOption = list(
#'       action = "DISCOVER_EXISTING"|"COPY_AUTO_SCALING_GROUP"
#'     )
#'   ),
#'   loadBalancerInfo = list(
#'     elbInfoList = list(
#'       list(
#'         name = "string"
#'       )
#'     ),
#'     targetGroupInfoList = list(
#'       list(
#'         name = "string"
#'       )
#'     ),
#'     targetGroupPairInfoList = list(
#'       list(
#'         targetGroups = list(
#'           list(
#'             name = "string"
#'           )
#'         ),
#'         prodTrafficRoute = list(
#'           listenerArns = list(
#'             "string"
#'           )
#'         ),
#'         testTrafficRoute = list(
#'           listenerArns = list(
#'             "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ec2TagSet = list(
#'     ec2TagSetList = list(
#'       list(
#'         list(
#'           Key = "string",
#'           Value = "string",
#'           Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'         )
#'       )
#'     )
#'   ),
#'   ecsServices = list(
#'     list(
#'       serviceName = "string",
#'       clusterName = "string"
#'     )
#'   ),
#'   onPremisesTagSet = list(
#'     onPremisesTagSetList = list(
#'       list(
#'         list(
#'           Key = "string",
#'           Value = "string",
#'           Type = "KEY_ONLY"|"VALUE_ONLY"|"KEY_AND_VALUE"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codedeploy_update_deployment_group
codedeploy_update_deployment_group <- function(applicationName, currentDeploymentGroupName, newDeploymentGroupName = NULL, deploymentConfigName = NULL, ec2TagFilters = NULL, onPremisesInstanceTagFilters = NULL, autoScalingGroups = NULL, serviceRoleArn = NULL, triggerConfigurations = NULL, alarmConfiguration = NULL, autoRollbackConfiguration = NULL, deploymentStyle = NULL, blueGreenDeploymentConfiguration = NULL, loadBalancerInfo = NULL, ec2TagSet = NULL, ecsServices = NULL, onPremisesTagSet = NULL) {
  op <- new_operation(
    name = "UpdateDeploymentGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codedeploy$update_deployment_group_input(applicationName = applicationName, currentDeploymentGroupName = currentDeploymentGroupName, newDeploymentGroupName = newDeploymentGroupName, deploymentConfigName = deploymentConfigName, ec2TagFilters = ec2TagFilters, onPremisesInstanceTagFilters = onPremisesInstanceTagFilters, autoScalingGroups = autoScalingGroups, serviceRoleArn = serviceRoleArn, triggerConfigurations = triggerConfigurations, alarmConfiguration = alarmConfiguration, autoRollbackConfiguration = autoRollbackConfiguration, deploymentStyle = deploymentStyle, blueGreenDeploymentConfiguration = blueGreenDeploymentConfiguration, loadBalancerInfo = loadBalancerInfo, ec2TagSet = ec2TagSet, ecsServices = ecsServices, onPremisesTagSet = onPremisesTagSet)
  output <- .codedeploy$update_deployment_group_output()
  config <- get_config()
  svc <- .codedeploy$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codedeploy$operations$update_deployment_group <- codedeploy_update_deployment_group
