# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include codepipeline_service.R
NULL

#' Returns information about a specified job and whether that job has been
#' received by the job worker
#'
#' @description
#' Returns information about a specified job and whether that job has been
#' received by the job worker. Used for custom actions only.
#'
#' @usage
#' codepipeline_acknowledge_job(jobId, nonce)
#'
#' @param jobId &#91;required&#93; The unique system-generated ID of the job for which you want to confirm
#' receipt.
#' @param nonce &#91;required&#93; A system-generated random number that AWS CodePipeline uses to ensure
#' that the job is being worked on by only one job worker. Get this number
#' from the response of the [`poll_for_jobs`][codepipeline_poll_for_jobs]
#' request that returned this job.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   status = "Created"|"Queued"|"Dispatched"|"InProgress"|"TimedOut"|"Succeeded"|"Failed"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$acknowledge_job(
#'   jobId = "string",
#'   nonce = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_acknowledge_job
codepipeline_acknowledge_job <- function(jobId, nonce) {
  op <- new_operation(
    name = "AcknowledgeJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$acknowledge_job_input(jobId = jobId, nonce = nonce)
  output <- .codepipeline$acknowledge_job_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$acknowledge_job <- codepipeline_acknowledge_job

#' Confirms a job worker has received the specified job
#'
#' @description
#' Confirms a job worker has received the specified job. Used for partner
#' actions only.
#'
#' @usage
#' codepipeline_acknowledge_third_party_job(jobId, nonce, clientToken)
#'
#' @param jobId &#91;required&#93; The unique system-generated ID of the job.
#' @param nonce &#91;required&#93; A system-generated random number that AWS CodePipeline uses to ensure
#' that the job is being worked on by only one job worker. Get this number
#' from the response to a
#' [`get_third_party_job_details`][codepipeline_get_third_party_job_details]
#' request.
#' @param clientToken &#91;required&#93; The clientToken portion of the clientId and clientToken pair used to
#' verify that the calling entity is allowed access to the job and its
#' details.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   status = "Created"|"Queued"|"Dispatched"|"InProgress"|"TimedOut"|"Succeeded"|"Failed"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$acknowledge_third_party_job(
#'   jobId = "string",
#'   nonce = "string",
#'   clientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_acknowledge_third_party_job
codepipeline_acknowledge_third_party_job <- function(jobId, nonce, clientToken) {
  op <- new_operation(
    name = "AcknowledgeThirdPartyJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$acknowledge_third_party_job_input(jobId = jobId, nonce = nonce, clientToken = clientToken)
  output <- .codepipeline$acknowledge_third_party_job_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$acknowledge_third_party_job <- codepipeline_acknowledge_third_party_job

#' Creates a new custom action that can be used in all pipelines associated
#' with the AWS account
#'
#' @description
#' Creates a new custom action that can be used in all pipelines associated
#' with the AWS account. Only used for custom actions.
#'
#' @usage
#' codepipeline_create_custom_action_type(category, provider, version,
#'   settings, configurationProperties, inputArtifactDetails,
#'   outputArtifactDetails, tags)
#'
#' @param category &#91;required&#93; The category of the custom action, such as a build action or a test
#' action.
#' @param provider &#91;required&#93; The provider of the service used in the custom action, such as AWS
#' CodeDeploy.
#' @param version &#91;required&#93; The version identifier of the custom action.
#' @param settings URLs that provide users information about this custom action.
#' @param configurationProperties The configuration properties for the custom action.
#' 
#' You can refer to a name in the configuration properties of the custom
#' action within the URL templates by following the format of
#' \{Config:name\}, as long as the configuration property is both
#' required and not secret. For more information, see [Create a Custom
#' Action for a
#' Pipeline](https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-create-custom-action.html).
#' @param inputArtifactDetails &#91;required&#93; The details of the input artifact for the action, such as its commit ID.
#' @param outputArtifactDetails &#91;required&#93; The details of the output artifact of the action, such as its commit ID.
#' @param tags The tags for the custom action.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   actionType = list(
#'     id = list(
#'       category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'       owner = "AWS"|"ThirdParty"|"Custom",
#'       provider = "string",
#'       version = "string"
#'     ),
#'     settings = list(
#'       thirdPartyConfigurationUrl = "string",
#'       entityUrlTemplate = "string",
#'       executionUrlTemplate = "string",
#'       revisionUrlTemplate = "string"
#'     ),
#'     actionConfigurationProperties = list(
#'       list(
#'         name = "string",
#'         required = TRUE|FALSE,
#'         key = TRUE|FALSE,
#'         secret = TRUE|FALSE,
#'         queryable = TRUE|FALSE,
#'         description = "string",
#'         type = "String"|"Number"|"Boolean"
#'       )
#'     ),
#'     inputArtifactDetails = list(
#'       minimumCount = 123,
#'       maximumCount = 123
#'     ),
#'     outputArtifactDetails = list(
#'       minimumCount = 123,
#'       maximumCount = 123
#'     )
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_custom_action_type(
#'   category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'   provider = "string",
#'   version = "string",
#'   settings = list(
#'     thirdPartyConfigurationUrl = "string",
#'     entityUrlTemplate = "string",
#'     executionUrlTemplate = "string",
#'     revisionUrlTemplate = "string"
#'   ),
#'   configurationProperties = list(
#'     list(
#'       name = "string",
#'       required = TRUE|FALSE,
#'       key = TRUE|FALSE,
#'       secret = TRUE|FALSE,
#'       queryable = TRUE|FALSE,
#'       description = "string",
#'       type = "String"|"Number"|"Boolean"
#'     )
#'   ),
#'   inputArtifactDetails = list(
#'     minimumCount = 123,
#'     maximumCount = 123
#'   ),
#'   outputArtifactDetails = list(
#'     minimumCount = 123,
#'     maximumCount = 123
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_create_custom_action_type
codepipeline_create_custom_action_type <- function(category, provider, version, settings = NULL, configurationProperties = NULL, inputArtifactDetails, outputArtifactDetails, tags = NULL) {
  op <- new_operation(
    name = "CreateCustomActionType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$create_custom_action_type_input(category = category, provider = provider, version = version, settings = settings, configurationProperties = configurationProperties, inputArtifactDetails = inputArtifactDetails, outputArtifactDetails = outputArtifactDetails, tags = tags)
  output <- .codepipeline$create_custom_action_type_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$create_custom_action_type <- codepipeline_create_custom_action_type

#' Creates a pipeline
#'
#' @description
#' Creates a pipeline.
#' 
#' In the pipeline structure, you must include either `artifactStore` or
#' `artifactStores` in your pipeline, but you cannot use both. If you
#' create a cross-region action in your pipeline, you must use
#' `artifactStores`.
#'
#' @usage
#' codepipeline_create_pipeline(pipeline, tags)
#'
#' @param pipeline &#91;required&#93; Represents the structure of actions and stages to be performed in the
#' pipeline.
#' @param tags The tags for the pipeline.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   pipeline = list(
#'     name = "string",
#'     roleArn = "string",
#'     artifactStore = list(
#'       type = "S3",
#'       location = "string",
#'       encryptionKey = list(
#'         id = "string",
#'         type = "KMS"
#'       )
#'     ),
#'     artifactStores = list(
#'       list(
#'         type = "S3",
#'         location = "string",
#'         encryptionKey = list(
#'           id = "string",
#'           type = "KMS"
#'         )
#'       )
#'     ),
#'     stages = list(
#'       list(
#'         name = "string",
#'         blockers = list(
#'           list(
#'             name = "string",
#'             type = "Schedule"
#'           )
#'         ),
#'         actions = list(
#'           list(
#'             name = "string",
#'             actionTypeId = list(
#'               category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'               owner = "AWS"|"ThirdParty"|"Custom",
#'               provider = "string",
#'               version = "string"
#'             ),
#'             runOrder = 123,
#'             configuration = list(
#'               "string"
#'             ),
#'             outputArtifacts = list(
#'               list(
#'                 name = "string"
#'               )
#'             ),
#'             inputArtifacts = list(
#'               list(
#'                 name = "string"
#'               )
#'             ),
#'             roleArn = "string",
#'             region = "string",
#'             namespace = "string"
#'           )
#'         )
#'       )
#'     ),
#'     version = 123
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_pipeline(
#'   pipeline = list(
#'     name = "string",
#'     roleArn = "string",
#'     artifactStore = list(
#'       type = "S3",
#'       location = "string",
#'       encryptionKey = list(
#'         id = "string",
#'         type = "KMS"
#'       )
#'     ),
#'     artifactStores = list(
#'       list(
#'         type = "S3",
#'         location = "string",
#'         encryptionKey = list(
#'           id = "string",
#'           type = "KMS"
#'         )
#'       )
#'     ),
#'     stages = list(
#'       list(
#'         name = "string",
#'         blockers = list(
#'           list(
#'             name = "string",
#'             type = "Schedule"
#'           )
#'         ),
#'         actions = list(
#'           list(
#'             name = "string",
#'             actionTypeId = list(
#'               category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'               owner = "AWS"|"ThirdParty"|"Custom",
#'               provider = "string",
#'               version = "string"
#'             ),
#'             runOrder = 123,
#'             configuration = list(
#'               "string"
#'             ),
#'             outputArtifacts = list(
#'               list(
#'                 name = "string"
#'               )
#'             ),
#'             inputArtifacts = list(
#'               list(
#'                 name = "string"
#'               )
#'             ),
#'             roleArn = "string",
#'             region = "string",
#'             namespace = "string"
#'           )
#'         )
#'       )
#'     ),
#'     version = 123
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_create_pipeline
codepipeline_create_pipeline <- function(pipeline, tags = NULL) {
  op <- new_operation(
    name = "CreatePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$create_pipeline_input(pipeline = pipeline, tags = tags)
  output <- .codepipeline$create_pipeline_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$create_pipeline <- codepipeline_create_pipeline

#' Marks a custom action as deleted
#'
#' @description
#' Marks a custom action as deleted.
#' [`poll_for_jobs`][codepipeline_poll_for_jobs] for the custom action
#' fails after the action is marked for deletion. Used for custom actions
#' only.
#' 
#' To re-create a custom action after it has been deleted you must use a
#' string in the version field that has never been used before. This string
#' can be an incremented version number, for example. To restore a deleted
#' custom action, use a JSON file that is identical to the deleted action,
#' including the original string in the version field.
#'
#' @usage
#' codepipeline_delete_custom_action_type(category, provider, version)
#'
#' @param category &#91;required&#93; The category of the custom action that you want to delete, such as
#' source or deploy.
#' @param provider &#91;required&#93; The provider of the service used in the custom action, such as AWS
#' CodeDeploy.
#' @param version &#91;required&#93; The version of the custom action to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_custom_action_type(
#'   category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'   provider = "string",
#'   version = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_delete_custom_action_type
codepipeline_delete_custom_action_type <- function(category, provider, version) {
  op <- new_operation(
    name = "DeleteCustomActionType",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$delete_custom_action_type_input(category = category, provider = provider, version = version)
  output <- .codepipeline$delete_custom_action_type_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$delete_custom_action_type <- codepipeline_delete_custom_action_type

#' Deletes the specified pipeline
#'
#' @description
#' Deletes the specified pipeline.
#'
#' @usage
#' codepipeline_delete_pipeline(name)
#'
#' @param name &#91;required&#93; The name of the pipeline to be deleted.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_pipeline(
#'   name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_delete_pipeline
codepipeline_delete_pipeline <- function(name) {
  op <- new_operation(
    name = "DeletePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$delete_pipeline_input(name = name)
  output <- .codepipeline$delete_pipeline_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$delete_pipeline <- codepipeline_delete_pipeline

#' Deletes a previously created webhook by name
#'
#' @description
#' Deletes a previously created webhook by name. Deleting the webhook stops
#' AWS CodePipeline from starting a pipeline every time an external event
#' occurs. The API returns successfully when trying to delete a webhook
#' that is already deleted. If a deleted webhook is re-created by calling
#' PutWebhook with the same name, it will have a different URL.
#'
#' @usage
#' codepipeline_delete_webhook(name)
#'
#' @param name &#91;required&#93; The name of the webhook you want to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_webhook(
#'   name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_delete_webhook
codepipeline_delete_webhook <- function(name) {
  op <- new_operation(
    name = "DeleteWebhook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$delete_webhook_input(name = name)
  output <- .codepipeline$delete_webhook_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$delete_webhook <- codepipeline_delete_webhook

#' Removes the connection between the webhook that was created by
#' CodePipeline and the external tool with events to be detected
#'
#' @description
#' Removes the connection between the webhook that was created by
#' CodePipeline and the external tool with events to be detected. Currently
#' supported only for webhooks that target an action type of GitHub.
#'
#' @usage
#' codepipeline_deregister_webhook_with_third_party(webhookName)
#'
#' @param webhookName The name of the webhook you want to deregister.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_webhook_with_third_party(
#'   webhookName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_deregister_webhook_with_third_party
codepipeline_deregister_webhook_with_third_party <- function(webhookName = NULL) {
  op <- new_operation(
    name = "DeregisterWebhookWithThirdParty",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$deregister_webhook_with_third_party_input(webhookName = webhookName)
  output <- .codepipeline$deregister_webhook_with_third_party_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$deregister_webhook_with_third_party <- codepipeline_deregister_webhook_with_third_party

#' Prevents artifacts in a pipeline from transitioning to the next stage in
#' the pipeline
#'
#' @description
#' Prevents artifacts in a pipeline from transitioning to the next stage in
#' the pipeline.
#'
#' @usage
#' codepipeline_disable_stage_transition(pipelineName, stageName,
#'   transitionType, reason)
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline in which you want to disable the flow of
#' artifacts from one stage to another.
#' @param stageName &#91;required&#93; The name of the stage where you want to disable the inbound or outbound
#' transition of artifacts.
#' @param transitionType &#91;required&#93; Specifies whether artifacts are prevented from transitioning into the
#' stage and being processed by the actions in that stage (inbound), or
#' prevented from transitioning from the stage after they have been
#' processed by the actions in that stage (outbound).
#' @param reason &#91;required&#93; The reason given to the user that a stage is disabled, such as waiting
#' for manual approval or manual tests. This message is displayed in the
#' pipeline console UI.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disable_stage_transition(
#'   pipelineName = "string",
#'   stageName = "string",
#'   transitionType = "Inbound"|"Outbound",
#'   reason = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_disable_stage_transition
codepipeline_disable_stage_transition <- function(pipelineName, stageName, transitionType, reason) {
  op <- new_operation(
    name = "DisableStageTransition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$disable_stage_transition_input(pipelineName = pipelineName, stageName = stageName, transitionType = transitionType, reason = reason)
  output <- .codepipeline$disable_stage_transition_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$disable_stage_transition <- codepipeline_disable_stage_transition

#' Enables artifacts in a pipeline to transition to a stage in a pipeline
#'
#' @description
#' Enables artifacts in a pipeline to transition to a stage in a pipeline.
#'
#' @usage
#' codepipeline_enable_stage_transition(pipelineName, stageName,
#'   transitionType)
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline in which you want to enable the flow of
#' artifacts from one stage to another.
#' @param stageName &#91;required&#93; The name of the stage where you want to enable the transition of
#' artifacts, either into the stage (inbound) or from that stage to the
#' next stage (outbound).
#' @param transitionType &#91;required&#93; Specifies whether artifacts are allowed to enter the stage and be
#' processed by the actions in that stage (inbound) or whether already
#' processed artifacts are allowed to transition to the next stage
#' (outbound).
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$enable_stage_transition(
#'   pipelineName = "string",
#'   stageName = "string",
#'   transitionType = "Inbound"|"Outbound"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_enable_stage_transition
codepipeline_enable_stage_transition <- function(pipelineName, stageName, transitionType) {
  op <- new_operation(
    name = "EnableStageTransition",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$enable_stage_transition_input(pipelineName = pipelineName, stageName = stageName, transitionType = transitionType)
  output <- .codepipeline$enable_stage_transition_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$enable_stage_transition <- codepipeline_enable_stage_transition

#' Returns information about a job
#'
#' @description
#' Returns information about a job. Used for custom actions only.
#' 
#' When this API is called, AWS CodePipeline returns temporary credentials
#' for the S3 bucket used to store artifacts for the pipeline, if the
#' action requires access to that S3 bucket for input or output artifacts.
#' This API also returns any secret values defined for the action.
#'
#' @usage
#' codepipeline_get_job_details(jobId)
#'
#' @param jobId &#91;required&#93; The unique system-generated ID for the job.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   jobDetails = list(
#'     id = "string",
#'     data = list(
#'       actionTypeId = list(
#'         category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'         owner = "AWS"|"ThirdParty"|"Custom",
#'         provider = "string",
#'         version = "string"
#'       ),
#'       actionConfiguration = list(
#'         configuration = list(
#'           "string"
#'         )
#'       ),
#'       pipelineContext = list(
#'         pipelineName = "string",
#'         stage = list(
#'           name = "string"
#'         ),
#'         action = list(
#'           name = "string",
#'           actionExecutionId = "string"
#'         ),
#'         pipelineArn = "string",
#'         pipelineExecutionId = "string"
#'       ),
#'       inputArtifacts = list(
#'         list(
#'           name = "string",
#'           revision = "string",
#'           location = list(
#'             type = "S3",
#'             s3Location = list(
#'               bucketName = "string",
#'               objectKey = "string"
#'             )
#'           )
#'         )
#'       ),
#'       outputArtifacts = list(
#'         list(
#'           name = "string",
#'           revision = "string",
#'           location = list(
#'             type = "S3",
#'             s3Location = list(
#'               bucketName = "string",
#'               objectKey = "string"
#'             )
#'           )
#'         )
#'       ),
#'       artifactCredentials = list(
#'         accessKeyId = "string",
#'         secretAccessKey = "string",
#'         sessionToken = "string"
#'       ),
#'       continuationToken = "string",
#'       encryptionKey = list(
#'         id = "string",
#'         type = "KMS"
#'       )
#'     ),
#'     accountId = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_job_details(
#'   jobId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_get_job_details
codepipeline_get_job_details <- function(jobId) {
  op <- new_operation(
    name = "GetJobDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$get_job_details_input(jobId = jobId)
  output <- .codepipeline$get_job_details_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$get_job_details <- codepipeline_get_job_details

#' Returns the metadata, structure, stages, and actions of a pipeline
#'
#' @description
#' Returns the metadata, structure, stages, and actions of a pipeline. Can
#' be used to return the entire structure of a pipeline in JSON format,
#' which can then be modified and used to update the pipeline structure
#' with [`update_pipeline`][codepipeline_update_pipeline].
#'
#' @usage
#' codepipeline_get_pipeline(name, version)
#'
#' @param name &#91;required&#93; The name of the pipeline for which you want to get information. Pipeline
#' names must be unique under an AWS user account.
#' @param version The version number of the pipeline. If you do not specify a version,
#' defaults to the current version.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   pipeline = list(
#'     name = "string",
#'     roleArn = "string",
#'     artifactStore = list(
#'       type = "S3",
#'       location = "string",
#'       encryptionKey = list(
#'         id = "string",
#'         type = "KMS"
#'       )
#'     ),
#'     artifactStores = list(
#'       list(
#'         type = "S3",
#'         location = "string",
#'         encryptionKey = list(
#'           id = "string",
#'           type = "KMS"
#'         )
#'       )
#'     ),
#'     stages = list(
#'       list(
#'         name = "string",
#'         blockers = list(
#'           list(
#'             name = "string",
#'             type = "Schedule"
#'           )
#'         ),
#'         actions = list(
#'           list(
#'             name = "string",
#'             actionTypeId = list(
#'               category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'               owner = "AWS"|"ThirdParty"|"Custom",
#'               provider = "string",
#'               version = "string"
#'             ),
#'             runOrder = 123,
#'             configuration = list(
#'               "string"
#'             ),
#'             outputArtifacts = list(
#'               list(
#'                 name = "string"
#'               )
#'             ),
#'             inputArtifacts = list(
#'               list(
#'                 name = "string"
#'               )
#'             ),
#'             roleArn = "string",
#'             region = "string",
#'             namespace = "string"
#'           )
#'         )
#'       )
#'     ),
#'     version = 123
#'   ),
#'   metadata = list(
#'     pipelineArn = "string",
#'     created = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     updated = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_pipeline(
#'   name = "string",
#'   version = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_get_pipeline
codepipeline_get_pipeline <- function(name, version = NULL) {
  op <- new_operation(
    name = "GetPipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$get_pipeline_input(name = name, version = version)
  output <- .codepipeline$get_pipeline_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$get_pipeline <- codepipeline_get_pipeline

#' Returns information about an execution of a pipeline, including details
#' about artifacts, the pipeline execution ID, and the name, version, and
#' status of the pipeline
#'
#' @description
#' Returns information about an execution of a pipeline, including details
#' about artifacts, the pipeline execution ID, and the name, version, and
#' status of the pipeline.
#'
#' @usage
#' codepipeline_get_pipeline_execution(pipelineName, pipelineExecutionId)
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline about which you want to get execution details.
#' @param pipelineExecutionId &#91;required&#93; The ID of the pipeline execution about which you want to get execution
#' details.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   pipelineExecution = list(
#'     pipelineName = "string",
#'     pipelineVersion = 123,
#'     pipelineExecutionId = "string",
#'     status = "Cancelled"|"InProgress"|"Stopped"|"Stopping"|"Succeeded"|"Superseded"|"Failed",
#'     statusSummary = "string",
#'     artifactRevisions = list(
#'       list(
#'         name = "string",
#'         revisionId = "string",
#'         revisionChangeIdentifier = "string",
#'         revisionSummary = "string",
#'         created = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         revisionUrl = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_pipeline_execution(
#'   pipelineName = "string",
#'   pipelineExecutionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_get_pipeline_execution
codepipeline_get_pipeline_execution <- function(pipelineName, pipelineExecutionId) {
  op <- new_operation(
    name = "GetPipelineExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$get_pipeline_execution_input(pipelineName = pipelineName, pipelineExecutionId = pipelineExecutionId)
  output <- .codepipeline$get_pipeline_execution_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$get_pipeline_execution <- codepipeline_get_pipeline_execution

#' Returns information about the state of a pipeline, including the stages
#' and actions
#'
#' @description
#' Returns information about the state of a pipeline, including the stages
#' and actions.
#' 
#' Values returned in the `revisionId` and `revisionUrl` fields indicate
#' the source revision information, such as the commit ID, for the current
#' state.
#'
#' @usage
#' codepipeline_get_pipeline_state(name)
#'
#' @param name &#91;required&#93; The name of the pipeline about which you want to get information.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   pipelineName = "string",
#'   pipelineVersion = 123,
#'   stageStates = list(
#'     list(
#'       stageName = "string",
#'       inboundExecution = list(
#'         pipelineExecutionId = "string",
#'         status = "Cancelled"|"InProgress"|"Failed"|"Stopped"|"Stopping"|"Succeeded"
#'       ),
#'       inboundTransitionState = list(
#'         enabled = TRUE|FALSE,
#'         lastChangedBy = "string",
#'         lastChangedAt = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         disabledReason = "string"
#'       ),
#'       actionStates = list(
#'         list(
#'           actionName = "string",
#'           currentRevision = list(
#'             revisionId = "string",
#'             revisionChangeId = "string",
#'             created = as.POSIXct(
#'               "2015-01-01"
#'             )
#'           ),
#'           latestExecution = list(
#'             actionExecutionId = "string",
#'             status = "InProgress"|"Abandoned"|"Succeeded"|"Failed",
#'             summary = "string",
#'             lastStatusChange = as.POSIXct(
#'               "2015-01-01"
#'             ),
#'             token = "string",
#'             lastUpdatedBy = "string",
#'             externalExecutionId = "string",
#'             externalExecutionUrl = "string",
#'             percentComplete = 123,
#'             errorDetails = list(
#'               code = "string",
#'               message = "string"
#'             )
#'           ),
#'           entityUrl = "string",
#'           revisionUrl = "string"
#'         )
#'       ),
#'       latestExecution = list(
#'         pipelineExecutionId = "string",
#'         status = "Cancelled"|"InProgress"|"Failed"|"Stopped"|"Stopping"|"Succeeded"
#'       )
#'     )
#'   ),
#'   created = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   updated = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_pipeline_state(
#'   name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_get_pipeline_state
codepipeline_get_pipeline_state <- function(name) {
  op <- new_operation(
    name = "GetPipelineState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$get_pipeline_state_input(name = name)
  output <- .codepipeline$get_pipeline_state_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$get_pipeline_state <- codepipeline_get_pipeline_state

#' Requests the details of a job for a third party action
#'
#' @description
#' Requests the details of a job for a third party action. Used for partner
#' actions only.
#' 
#' When this API is called, AWS CodePipeline returns temporary credentials
#' for the S3 bucket used to store artifacts for the pipeline, if the
#' action requires access to that S3 bucket for input or output artifacts.
#' This API also returns any secret values defined for the action.
#'
#' @usage
#' codepipeline_get_third_party_job_details(jobId, clientToken)
#'
#' @param jobId &#91;required&#93; The unique system-generated ID used for identifying the job.
#' @param clientToken &#91;required&#93; The clientToken portion of the clientId and clientToken pair used to
#' verify that the calling entity is allowed access to the job and its
#' details.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   jobDetails = list(
#'     id = "string",
#'     data = list(
#'       actionTypeId = list(
#'         category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'         owner = "AWS"|"ThirdParty"|"Custom",
#'         provider = "string",
#'         version = "string"
#'       ),
#'       actionConfiguration = list(
#'         configuration = list(
#'           "string"
#'         )
#'       ),
#'       pipelineContext = list(
#'         pipelineName = "string",
#'         stage = list(
#'           name = "string"
#'         ),
#'         action = list(
#'           name = "string",
#'           actionExecutionId = "string"
#'         ),
#'         pipelineArn = "string",
#'         pipelineExecutionId = "string"
#'       ),
#'       inputArtifacts = list(
#'         list(
#'           name = "string",
#'           revision = "string",
#'           location = list(
#'             type = "S3",
#'             s3Location = list(
#'               bucketName = "string",
#'               objectKey = "string"
#'             )
#'           )
#'         )
#'       ),
#'       outputArtifacts = list(
#'         list(
#'           name = "string",
#'           revision = "string",
#'           location = list(
#'             type = "S3",
#'             s3Location = list(
#'               bucketName = "string",
#'               objectKey = "string"
#'             )
#'           )
#'         )
#'       ),
#'       artifactCredentials = list(
#'         accessKeyId = "string",
#'         secretAccessKey = "string",
#'         sessionToken = "string"
#'       ),
#'       continuationToken = "string",
#'       encryptionKey = list(
#'         id = "string",
#'         type = "KMS"
#'       )
#'     ),
#'     nonce = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_third_party_job_details(
#'   jobId = "string",
#'   clientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_get_third_party_job_details
codepipeline_get_third_party_job_details <- function(jobId, clientToken) {
  op <- new_operation(
    name = "GetThirdPartyJobDetails",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$get_third_party_job_details_input(jobId = jobId, clientToken = clientToken)
  output <- .codepipeline$get_third_party_job_details_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$get_third_party_job_details <- codepipeline_get_third_party_job_details

#' Lists the action executions that have occurred in a pipeline
#'
#' @description
#' Lists the action executions that have occurred in a pipeline.
#'
#' @usage
#' codepipeline_list_action_executions(pipelineName, filter, maxResults,
#'   nextToken)
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline for which you want to list action execution
#' history.
#' @param filter Input information used to filter action execution history.
#' @param maxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned nextToken
#' value. Action execution history is retained for up to 12 months, based
#' on action execution start times. Default value is 100.
#' 
#' Detailed execution history is available for executions run on or after
#' February 21, 2019.
#' @param nextToken The token that was returned from the previous
#' [`list_action_executions`][codepipeline_list_action_executions] call,
#' which can be used to return the next set of action executions in the
#' list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   actionExecutionDetails = list(
#'     list(
#'       pipelineExecutionId = "string",
#'       actionExecutionId = "string",
#'       pipelineVersion = 123,
#'       stageName = "string",
#'       actionName = "string",
#'       startTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       status = "InProgress"|"Abandoned"|"Succeeded"|"Failed",
#'       input = list(
#'         actionTypeId = list(
#'           category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'           owner = "AWS"|"ThirdParty"|"Custom",
#'           provider = "string",
#'           version = "string"
#'         ),
#'         configuration = list(
#'           "string"
#'         ),
#'         resolvedConfiguration = list(
#'           "string"
#'         ),
#'         roleArn = "string",
#'         region = "string",
#'         inputArtifacts = list(
#'           list(
#'             name = "string",
#'             s3location = list(
#'               bucket = "string",
#'               key = "string"
#'             )
#'           )
#'         ),
#'         namespace = "string"
#'       ),
#'       output = list(
#'         outputArtifacts = list(
#'           list(
#'             name = "string",
#'             s3location = list(
#'               bucket = "string",
#'               key = "string"
#'             )
#'           )
#'         ),
#'         executionResult = list(
#'           externalExecutionId = "string",
#'           externalExecutionSummary = "string",
#'           externalExecutionUrl = "string"
#'         ),
#'         outputVariables = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_action_executions(
#'   pipelineName = "string",
#'   filter = list(
#'     pipelineExecutionId = "string"
#'   ),
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_list_action_executions
codepipeline_list_action_executions <- function(pipelineName, filter = NULL, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListActionExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$list_action_executions_input(pipelineName = pipelineName, filter = filter, maxResults = maxResults, nextToken = nextToken)
  output <- .codepipeline$list_action_executions_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$list_action_executions <- codepipeline_list_action_executions

#' Gets a summary of all AWS CodePipeline action types associated with your
#' account
#'
#' @description
#' Gets a summary of all AWS CodePipeline action types associated with your
#' account.
#'
#' @usage
#' codepipeline_list_action_types(actionOwnerFilter, nextToken)
#'
#' @param actionOwnerFilter Filters the list of action types to those created by a specified entity.
#' @param nextToken An identifier that was returned from the previous list action types
#' call, which can be used to return the next set of action types in the
#' list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   actionTypes = list(
#'     list(
#'       id = list(
#'         category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'         owner = "AWS"|"ThirdParty"|"Custom",
#'         provider = "string",
#'         version = "string"
#'       ),
#'       settings = list(
#'         thirdPartyConfigurationUrl = "string",
#'         entityUrlTemplate = "string",
#'         executionUrlTemplate = "string",
#'         revisionUrlTemplate = "string"
#'       ),
#'       actionConfigurationProperties = list(
#'         list(
#'           name = "string",
#'           required = TRUE|FALSE,
#'           key = TRUE|FALSE,
#'           secret = TRUE|FALSE,
#'           queryable = TRUE|FALSE,
#'           description = "string",
#'           type = "String"|"Number"|"Boolean"
#'         )
#'       ),
#'       inputArtifactDetails = list(
#'         minimumCount = 123,
#'         maximumCount = 123
#'       ),
#'       outputArtifactDetails = list(
#'         minimumCount = 123,
#'         maximumCount = 123
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_action_types(
#'   actionOwnerFilter = "AWS"|"ThirdParty"|"Custom",
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_list_action_types
codepipeline_list_action_types <- function(actionOwnerFilter = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListActionTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$list_action_types_input(actionOwnerFilter = actionOwnerFilter, nextToken = nextToken)
  output <- .codepipeline$list_action_types_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$list_action_types <- codepipeline_list_action_types

#' Gets a summary of the most recent executions for a pipeline
#'
#' @description
#' Gets a summary of the most recent executions for a pipeline.
#'
#' @usage
#' codepipeline_list_pipeline_executions(pipelineName, maxResults,
#'   nextToken)
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline for which you want to get execution summary
#' information.
#' @param maxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned nextToken
#' value. Pipeline history is limited to the most recent 12 months, based
#' on pipeline execution start times. Default value is 100.
#' @param nextToken The token that was returned from the previous
#' [`list_pipeline_executions`][codepipeline_list_pipeline_executions]
#' call, which can be used to return the next set of pipeline executions in
#' the list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   pipelineExecutionSummaries = list(
#'     list(
#'       pipelineExecutionId = "string",
#'       status = "Cancelled"|"InProgress"|"Stopped"|"Stopping"|"Succeeded"|"Superseded"|"Failed",
#'       startTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       lastUpdateTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       sourceRevisions = list(
#'         list(
#'           actionName = "string",
#'           revisionId = "string",
#'           revisionSummary = "string",
#'           revisionUrl = "string"
#'         )
#'       ),
#'       trigger = list(
#'         triggerType = "CreatePipeline"|"StartPipelineExecution"|"PollForSourceChanges"|"Webhook"|"CloudWatchEvent"|"PutActionRevision",
#'         triggerDetail = "string"
#'       ),
#'       stopTrigger = list(
#'         reason = "string"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_pipeline_executions(
#'   pipelineName = "string",
#'   maxResults = 123,
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_list_pipeline_executions
codepipeline_list_pipeline_executions <- function(pipelineName, maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListPipelineExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$list_pipeline_executions_input(pipelineName = pipelineName, maxResults = maxResults, nextToken = nextToken)
  output <- .codepipeline$list_pipeline_executions_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$list_pipeline_executions <- codepipeline_list_pipeline_executions

#' Gets a summary of all of the pipelines associated with your account
#'
#' @description
#' Gets a summary of all of the pipelines associated with your account.
#'
#' @usage
#' codepipeline_list_pipelines(nextToken)
#'
#' @param nextToken An identifier that was returned from the previous list pipelines call.
#' It can be used to return the next set of pipelines in the list.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   pipelines = list(
#'     list(
#'       name = "string",
#'       version = 123,
#'       created = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       updated = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_pipelines(
#'   nextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_list_pipelines
codepipeline_list_pipelines <- function(nextToken = NULL) {
  op <- new_operation(
    name = "ListPipelines",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$list_pipelines_input(nextToken = nextToken)
  output <- .codepipeline$list_pipelines_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$list_pipelines <- codepipeline_list_pipelines

#' Gets the set of key-value pairs (metadata) that are used to manage the
#' resource
#'
#' @description
#' Gets the set of key-value pairs (metadata) that are used to manage the
#' resource.
#'
#' @usage
#' codepipeline_list_tags_for_resource(resourceArn, nextToken, maxResults)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to get tags for.
#' @param nextToken The token that was returned from the previous API call, which would be
#' used to return the next page of the list. The ListTagsforResource call
#' lists all available tags in one call and does not use pagination.
#' @param maxResults The maximum number of results to return in a single call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   ),
#'   nextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   resourceArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_list_tags_for_resource
codepipeline_list_tags_for_resource <- function(resourceArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$list_tags_for_resource_input(resourceArn = resourceArn, nextToken = nextToken, maxResults = maxResults)
  output <- .codepipeline$list_tags_for_resource_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$list_tags_for_resource <- codepipeline_list_tags_for_resource

#' Gets a listing of all the webhooks in this AWS Region for this account
#'
#' @description
#' Gets a listing of all the webhooks in this AWS Region for this account.
#' The output lists all webhooks and includes the webhook URL and ARN and
#' the configuration for each webhook.
#'
#' @usage
#' codepipeline_list_webhooks(NextToken, MaxResults)
#'
#' @param NextToken The token that was returned from the previous ListWebhooks call, which
#' can be used to return the next set of webhooks in the list.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned nextToken
#' value.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   webhooks = list(
#'     list(
#'       definition = list(
#'         name = "string",
#'         targetPipeline = "string",
#'         targetAction = "string",
#'         filters = list(
#'           list(
#'             jsonPath = "string",
#'             matchEquals = "string"
#'           )
#'         ),
#'         authentication = "GITHUB_HMAC"|"IP"|"UNAUTHENTICATED",
#'         authenticationConfiguration = list(
#'           AllowedIPRange = "string",
#'           SecretToken = "string"
#'         )
#'       ),
#'       url = "string",
#'       errorMessage = "string",
#'       errorCode = "string",
#'       lastTriggered = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       arn = "string",
#'       tags = list(
#'         list(
#'           key = "string",
#'           value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_webhooks(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_list_webhooks
codepipeline_list_webhooks <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListWebhooks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$list_webhooks_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .codepipeline$list_webhooks_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$list_webhooks <- codepipeline_list_webhooks

#' Returns information about any jobs for AWS CodePipeline to act on
#'
#' @description
#' Returns information about any jobs for AWS CodePipeline to act on.
#' [`poll_for_jobs`][codepipeline_poll_for_jobs] is valid only for action
#' types with "Custom" in the owner field. If the action type contains
#' "AWS" or "ThirdParty" in the owner field, the
#' [`poll_for_jobs`][codepipeline_poll_for_jobs] action returns an error.
#' 
#' When this API is called, AWS CodePipeline returns temporary credentials
#' for the S3 bucket used to store artifacts for the pipeline, if the
#' action requires access to that S3 bucket for input or output artifacts.
#' This API also returns any secret values defined for the action.
#'
#' @usage
#' codepipeline_poll_for_jobs(actionTypeId, maxBatchSize, queryParam)
#'
#' @param actionTypeId &#91;required&#93; Represents information about an action type.
#' @param maxBatchSize The maximum number of jobs to return in a poll for jobs call.
#' @param queryParam A map of property names and values. For an action type with no queryable
#' properties, this value must be null or an empty map. For an action type
#' with a queryable property, you must supply that property as a key in the
#' map. Only jobs whose action configuration matches the mapped value are
#' returned.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   jobs = list(
#'     list(
#'       id = "string",
#'       data = list(
#'         actionTypeId = list(
#'           category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'           owner = "AWS"|"ThirdParty"|"Custom",
#'           provider = "string",
#'           version = "string"
#'         ),
#'         actionConfiguration = list(
#'           configuration = list(
#'             "string"
#'           )
#'         ),
#'         pipelineContext = list(
#'           pipelineName = "string",
#'           stage = list(
#'             name = "string"
#'           ),
#'           action = list(
#'             name = "string",
#'             actionExecutionId = "string"
#'           ),
#'           pipelineArn = "string",
#'           pipelineExecutionId = "string"
#'         ),
#'         inputArtifacts = list(
#'           list(
#'             name = "string",
#'             revision = "string",
#'             location = list(
#'               type = "S3",
#'               s3Location = list(
#'                 bucketName = "string",
#'                 objectKey = "string"
#'               )
#'             )
#'           )
#'         ),
#'         outputArtifacts = list(
#'           list(
#'             name = "string",
#'             revision = "string",
#'             location = list(
#'               type = "S3",
#'               s3Location = list(
#'                 bucketName = "string",
#'                 objectKey = "string"
#'               )
#'             )
#'           )
#'         ),
#'         artifactCredentials = list(
#'           accessKeyId = "string",
#'           secretAccessKey = "string",
#'           sessionToken = "string"
#'         ),
#'         continuationToken = "string",
#'         encryptionKey = list(
#'           id = "string",
#'           type = "KMS"
#'         )
#'       ),
#'       nonce = "string",
#'       accountId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$poll_for_jobs(
#'   actionTypeId = list(
#'     category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'     owner = "AWS"|"ThirdParty"|"Custom",
#'     provider = "string",
#'     version = "string"
#'   ),
#'   maxBatchSize = 123,
#'   queryParam = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_poll_for_jobs
codepipeline_poll_for_jobs <- function(actionTypeId, maxBatchSize = NULL, queryParam = NULL) {
  op <- new_operation(
    name = "PollForJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$poll_for_jobs_input(actionTypeId = actionTypeId, maxBatchSize = maxBatchSize, queryParam = queryParam)
  output <- .codepipeline$poll_for_jobs_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$poll_for_jobs <- codepipeline_poll_for_jobs

#' Determines whether there are any third party jobs for a job worker to
#' act on
#'
#' @description
#' Determines whether there are any third party jobs for a job worker to
#' act on. Used for partner actions only.
#' 
#' When this API is called, AWS CodePipeline returns temporary credentials
#' for the S3 bucket used to store artifacts for the pipeline, if the
#' action requires access to that S3 bucket for input or output artifacts.
#'
#' @usage
#' codepipeline_poll_for_third_party_jobs(actionTypeId, maxBatchSize)
#'
#' @param actionTypeId &#91;required&#93; Represents information about an action type.
#' @param maxBatchSize The maximum number of jobs to return in a poll for jobs call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   jobs = list(
#'     list(
#'       clientId = "string",
#'       jobId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$poll_for_third_party_jobs(
#'   actionTypeId = list(
#'     category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'     owner = "AWS"|"ThirdParty"|"Custom",
#'     provider = "string",
#'     version = "string"
#'   ),
#'   maxBatchSize = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_poll_for_third_party_jobs
codepipeline_poll_for_third_party_jobs <- function(actionTypeId, maxBatchSize = NULL) {
  op <- new_operation(
    name = "PollForThirdPartyJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$poll_for_third_party_jobs_input(actionTypeId = actionTypeId, maxBatchSize = maxBatchSize)
  output <- .codepipeline$poll_for_third_party_jobs_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$poll_for_third_party_jobs <- codepipeline_poll_for_third_party_jobs

#' Provides information to AWS CodePipeline about new revisions to a source
#'
#' @description
#' Provides information to AWS CodePipeline about new revisions to a
#' source.
#'
#' @usage
#' codepipeline_put_action_revision(pipelineName, stageName, actionName,
#'   actionRevision)
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline that starts processing the revision to the
#' source.
#' @param stageName &#91;required&#93; The name of the stage that contains the action that acts on the
#' revision.
#' @param actionName &#91;required&#93; The name of the action that processes the revision.
#' @param actionRevision &#91;required&#93; Represents information about the version (or revision) of an action.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   newRevision = TRUE|FALSE,
#'   pipelineExecutionId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_action_revision(
#'   pipelineName = "string",
#'   stageName = "string",
#'   actionName = "string",
#'   actionRevision = list(
#'     revisionId = "string",
#'     revisionChangeId = "string",
#'     created = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_action_revision
codepipeline_put_action_revision <- function(pipelineName, stageName, actionName, actionRevision) {
  op <- new_operation(
    name = "PutActionRevision",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_action_revision_input(pipelineName = pipelineName, stageName = stageName, actionName = actionName, actionRevision = actionRevision)
  output <- .codepipeline$put_action_revision_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_action_revision <- codepipeline_put_action_revision

#' Provides the response to a manual approval request to AWS CodePipeline
#'
#' @description
#' Provides the response to a manual approval request to AWS CodePipeline.
#' Valid responses include Approved and Rejected.
#'
#' @usage
#' codepipeline_put_approval_result(pipelineName, stageName, actionName,
#'   result, token)
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline that contains the action.
#' @param stageName &#91;required&#93; The name of the stage that contains the action.
#' @param actionName &#91;required&#93; The name of the action for which approval is requested.
#' @param result &#91;required&#93; Represents information about the result of the approval request.
#' @param token &#91;required&#93; The system-generated token used to identify a unique approval request.
#' The token for each open approval request can be obtained using the
#' [`get_pipeline_state`][codepipeline_get_pipeline_state] action. It is
#' used to validate that the approval request corresponding to this token
#' is still valid.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   approvedAt = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_approval_result(
#'   pipelineName = "string",
#'   stageName = "string",
#'   actionName = "string",
#'   result = list(
#'     summary = "string",
#'     status = "Approved"|"Rejected"
#'   ),
#'   token = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_approval_result
codepipeline_put_approval_result <- function(pipelineName, stageName, actionName, result, token) {
  op <- new_operation(
    name = "PutApprovalResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_approval_result_input(pipelineName = pipelineName, stageName = stageName, actionName = actionName, result = result, token = token)
  output <- .codepipeline$put_approval_result_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_approval_result <- codepipeline_put_approval_result

#' Represents the failure of a job as returned to the pipeline by a job
#' worker
#'
#' @description
#' Represents the failure of a job as returned to the pipeline by a job
#' worker. Used for custom actions only.
#'
#' @usage
#' codepipeline_put_job_failure_result(jobId, failureDetails)
#'
#' @param jobId &#91;required&#93; The unique system-generated ID of the job that failed. This is the same
#' ID returned from [`poll_for_jobs`][codepipeline_poll_for_jobs].
#' @param failureDetails &#91;required&#93; The details about the failure of a job.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$put_job_failure_result(
#'   jobId = "string",
#'   failureDetails = list(
#'     type = "JobFailed"|"ConfigurationError"|"PermissionError"|"RevisionOutOfSync"|"RevisionUnavailable"|"SystemUnavailable",
#'     message = "string",
#'     externalExecutionId = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_job_failure_result
codepipeline_put_job_failure_result <- function(jobId, failureDetails) {
  op <- new_operation(
    name = "PutJobFailureResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_job_failure_result_input(jobId = jobId, failureDetails = failureDetails)
  output <- .codepipeline$put_job_failure_result_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_job_failure_result <- codepipeline_put_job_failure_result

#' Represents the success of a job as returned to the pipeline by a job
#' worker
#'
#' @description
#' Represents the success of a job as returned to the pipeline by a job
#' worker. Used for custom actions only.
#'
#' @usage
#' codepipeline_put_job_success_result(jobId, currentRevision,
#'   continuationToken, executionDetails, outputVariables)
#'
#' @param jobId &#91;required&#93; The unique system-generated ID of the job that succeeded. This is the
#' same ID returned from [`poll_for_jobs`][codepipeline_poll_for_jobs].
#' @param currentRevision The ID of the current revision of the artifact successfully worked on by
#' the job.
#' @param continuationToken A token generated by a job worker, such as an AWS CodeDeploy deployment
#' ID, that a successful job provides to identify a custom action in
#' progress. Future jobs use this token to identify the running instance of
#' the action. It can be reused to return more information about the
#' progress of the custom action. When the action is complete, no
#' continuation token should be supplied.
#' @param executionDetails The execution details of the successful job, such as the actions taken
#' by the job worker.
#' @param outputVariables Key-value pairs produced as output by a job worker that can be made
#' available to a downstream action configuration. `outputVariables` can be
#' included only when there is no continuation token on the request.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$put_job_success_result(
#'   jobId = "string",
#'   currentRevision = list(
#'     revision = "string",
#'     changeIdentifier = "string",
#'     created = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     revisionSummary = "string"
#'   ),
#'   continuationToken = "string",
#'   executionDetails = list(
#'     summary = "string",
#'     externalExecutionId = "string",
#'     percentComplete = 123
#'   ),
#'   outputVariables = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_job_success_result
codepipeline_put_job_success_result <- function(jobId, currentRevision = NULL, continuationToken = NULL, executionDetails = NULL, outputVariables = NULL) {
  op <- new_operation(
    name = "PutJobSuccessResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_job_success_result_input(jobId = jobId, currentRevision = currentRevision, continuationToken = continuationToken, executionDetails = executionDetails, outputVariables = outputVariables)
  output <- .codepipeline$put_job_success_result_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_job_success_result <- codepipeline_put_job_success_result

#' Represents the failure of a third party job as returned to the pipeline
#' by a job worker
#'
#' @description
#' Represents the failure of a third party job as returned to the pipeline
#' by a job worker. Used for partner actions only.
#'
#' @usage
#' codepipeline_put_third_party_job_failure_result(jobId, clientToken,
#'   failureDetails)
#'
#' @param jobId &#91;required&#93; The ID of the job that failed. This is the same ID returned from
#' [`poll_for_third_party_jobs`][codepipeline_poll_for_third_party_jobs].
#' @param clientToken &#91;required&#93; The clientToken portion of the clientId and clientToken pair used to
#' verify that the calling entity is allowed access to the job and its
#' details.
#' @param failureDetails &#91;required&#93; Represents information about failure details.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$put_third_party_job_failure_result(
#'   jobId = "string",
#'   clientToken = "string",
#'   failureDetails = list(
#'     type = "JobFailed"|"ConfigurationError"|"PermissionError"|"RevisionOutOfSync"|"RevisionUnavailable"|"SystemUnavailable",
#'     message = "string",
#'     externalExecutionId = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_third_party_job_failure_result
codepipeline_put_third_party_job_failure_result <- function(jobId, clientToken, failureDetails) {
  op <- new_operation(
    name = "PutThirdPartyJobFailureResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_third_party_job_failure_result_input(jobId = jobId, clientToken = clientToken, failureDetails = failureDetails)
  output <- .codepipeline$put_third_party_job_failure_result_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_third_party_job_failure_result <- codepipeline_put_third_party_job_failure_result

#' Represents the success of a third party job as returned to the pipeline
#' by a job worker
#'
#' @description
#' Represents the success of a third party job as returned to the pipeline
#' by a job worker. Used for partner actions only.
#'
#' @usage
#' codepipeline_put_third_party_job_success_result(jobId, clientToken,
#'   currentRevision, continuationToken, executionDetails)
#'
#' @param jobId &#91;required&#93; The ID of the job that successfully completed. This is the same ID
#' returned from
#' [`poll_for_third_party_jobs`][codepipeline_poll_for_third_party_jobs].
#' @param clientToken &#91;required&#93; The clientToken portion of the clientId and clientToken pair used to
#' verify that the calling entity is allowed access to the job and its
#' details.
#' @param currentRevision Represents information about a current revision.
#' @param continuationToken A token generated by a job worker, such as an AWS CodeDeploy deployment
#' ID, that a successful job provides to identify a partner action in
#' progress. Future jobs use this token to identify the running instance of
#' the action. It can be reused to return more information about the
#' progress of the partner action. When the action is complete, no
#' continuation token should be supplied.
#' @param executionDetails The details of the actions taken and results produced on an artifact as
#' it passes through stages in the pipeline.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$put_third_party_job_success_result(
#'   jobId = "string",
#'   clientToken = "string",
#'   currentRevision = list(
#'     revision = "string",
#'     changeIdentifier = "string",
#'     created = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     revisionSummary = "string"
#'   ),
#'   continuationToken = "string",
#'   executionDetails = list(
#'     summary = "string",
#'     externalExecutionId = "string",
#'     percentComplete = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_third_party_job_success_result
codepipeline_put_third_party_job_success_result <- function(jobId, clientToken, currentRevision = NULL, continuationToken = NULL, executionDetails = NULL) {
  op <- new_operation(
    name = "PutThirdPartyJobSuccessResult",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_third_party_job_success_result_input(jobId = jobId, clientToken = clientToken, currentRevision = currentRevision, continuationToken = continuationToken, executionDetails = executionDetails)
  output <- .codepipeline$put_third_party_job_success_result_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_third_party_job_success_result <- codepipeline_put_third_party_job_success_result

#' Defines a webhook and returns a unique webhook URL generated by
#' CodePipeline
#'
#' @description
#' Defines a webhook and returns a unique webhook URL generated by
#' CodePipeline. This URL can be supplied to third party source hosting
#' providers to call every time there's a code change. When CodePipeline
#' receives a POST request on this URL, the pipeline defined in the webhook
#' is started as long as the POST request satisfied the authentication and
#' filtering requirements supplied when defining the webhook.
#' RegisterWebhookWithThirdParty and DeregisterWebhookWithThirdParty APIs
#' can be used to automatically configure supported third parties to call
#' the generated webhook URL.
#'
#' @usage
#' codepipeline_put_webhook(webhook, tags)
#'
#' @param webhook &#91;required&#93; The detail provided in an input file to create the webhook, such as the
#' webhook name, the pipeline name, and the action name. Give the webhook a
#' unique name that helps you identify it. You might name the webhook after
#' the pipeline and action it targets so that you can easily recognize what
#' it's used for later.
#' @param tags The tags for the webhook.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   webhook = list(
#'     definition = list(
#'       name = "string",
#'       targetPipeline = "string",
#'       targetAction = "string",
#'       filters = list(
#'         list(
#'           jsonPath = "string",
#'           matchEquals = "string"
#'         )
#'       ),
#'       authentication = "GITHUB_HMAC"|"IP"|"UNAUTHENTICATED",
#'       authenticationConfiguration = list(
#'         AllowedIPRange = "string",
#'         SecretToken = "string"
#'       )
#'     ),
#'     url = "string",
#'     errorMessage = "string",
#'     errorCode = "string",
#'     lastTriggered = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     arn = "string",
#'     tags = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_webhook(
#'   webhook = list(
#'     name = "string",
#'     targetPipeline = "string",
#'     targetAction = "string",
#'     filters = list(
#'       list(
#'         jsonPath = "string",
#'         matchEquals = "string"
#'       )
#'     ),
#'     authentication = "GITHUB_HMAC"|"IP"|"UNAUTHENTICATED",
#'     authenticationConfiguration = list(
#'       AllowedIPRange = "string",
#'       SecretToken = "string"
#'     )
#'   ),
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_put_webhook
codepipeline_put_webhook <- function(webhook, tags = NULL) {
  op <- new_operation(
    name = "PutWebhook",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$put_webhook_input(webhook = webhook, tags = tags)
  output <- .codepipeline$put_webhook_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$put_webhook <- codepipeline_put_webhook

#' Configures a connection between the webhook that was created and the
#' external tool with events to be detected
#'
#' @description
#' Configures a connection between the webhook that was created and the
#' external tool with events to be detected.
#'
#' @usage
#' codepipeline_register_webhook_with_third_party(webhookName)
#'
#' @param webhookName The name of an existing webhook created with PutWebhook to register with
#' a supported third party.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$register_webhook_with_third_party(
#'   webhookName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_register_webhook_with_third_party
codepipeline_register_webhook_with_third_party <- function(webhookName = NULL) {
  op <- new_operation(
    name = "RegisterWebhookWithThirdParty",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$register_webhook_with_third_party_input(webhookName = webhookName)
  output <- .codepipeline$register_webhook_with_third_party_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$register_webhook_with_third_party <- codepipeline_register_webhook_with_third_party

#' Resumes the pipeline execution by retrying the last failed actions in a
#' stage
#'
#' @description
#' Resumes the pipeline execution by retrying the last failed actions in a
#' stage. You can retry a stage immediately if any of the actions in the
#' stage fail. When you retry, all actions that are still in progress
#' continue working, and failed actions are triggered again.
#'
#' @usage
#' codepipeline_retry_stage_execution(pipelineName, stageName,
#'   pipelineExecutionId, retryMode)
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline that contains the failed stage.
#' @param stageName &#91;required&#93; The name of the failed stage to be retried.
#' @param pipelineExecutionId &#91;required&#93; The ID of the pipeline execution in the failed stage to be retried. Use
#' the [`get_pipeline_state`][codepipeline_get_pipeline_state] action to
#' retrieve the current pipelineExecutionId of the failed stage
#' @param retryMode &#91;required&#93; The scope of the retry attempt. Currently, the only supported value is
#' FAILED_ACTIONS.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   pipelineExecutionId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$retry_stage_execution(
#'   pipelineName = "string",
#'   stageName = "string",
#'   pipelineExecutionId = "string",
#'   retryMode = "FAILED_ACTIONS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_retry_stage_execution
codepipeline_retry_stage_execution <- function(pipelineName, stageName, pipelineExecutionId, retryMode) {
  op <- new_operation(
    name = "RetryStageExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$retry_stage_execution_input(pipelineName = pipelineName, stageName = stageName, pipelineExecutionId = pipelineExecutionId, retryMode = retryMode)
  output <- .codepipeline$retry_stage_execution_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$retry_stage_execution <- codepipeline_retry_stage_execution

#' Starts the specified pipeline
#'
#' @description
#' Starts the specified pipeline. Specifically, it begins processing the
#' latest commit to the source location specified as part of the pipeline.
#'
#' @usage
#' codepipeline_start_pipeline_execution(name, clientRequestToken)
#'
#' @param name &#91;required&#93; The name of the pipeline to start.
#' @param clientRequestToken The system-generated unique ID used to identify a unique execution
#' request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   pipelineExecutionId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$start_pipeline_execution(
#'   name = "string",
#'   clientRequestToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_start_pipeline_execution
codepipeline_start_pipeline_execution <- function(name, clientRequestToken = NULL) {
  op <- new_operation(
    name = "StartPipelineExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$start_pipeline_execution_input(name = name, clientRequestToken = clientRequestToken)
  output <- .codepipeline$start_pipeline_execution_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$start_pipeline_execution <- codepipeline_start_pipeline_execution

#' Stops the specified pipeline execution
#'
#' @description
#' Stops the specified pipeline execution. You choose to either stop the
#' pipeline execution by completing in-progress actions without starting
#' subsequent actions, or by abandoning in-progress actions. While
#' completing or abandoning in-progress actions, the pipeline execution is
#' in a `Stopping` state. After all in-progress actions are completed or
#' abandoned, the pipeline execution is in a `Stopped` state.
#'
#' @usage
#' codepipeline_stop_pipeline_execution(pipelineName, pipelineExecutionId,
#'   abandon, reason)
#'
#' @param pipelineName &#91;required&#93; The name of the pipeline to stop.
#' @param pipelineExecutionId &#91;required&#93; The ID of the pipeline execution to be stopped in the current stage. Use
#' the [`get_pipeline_state`][codepipeline_get_pipeline_state] action to
#' retrieve the current pipelineExecutionId.
#' @param abandon Use this option to stop the pipeline execution by abandoning, rather
#' than finishing, in-progress actions.
#' 
#' This option can lead to failed or out-of-sequence tasks.
#' @param reason Use this option to enter comments, such as the reason the pipeline was
#' stopped.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   pipelineExecutionId = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$stop_pipeline_execution(
#'   pipelineName = "string",
#'   pipelineExecutionId = "string",
#'   abandon = TRUE|FALSE,
#'   reason = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_stop_pipeline_execution
codepipeline_stop_pipeline_execution <- function(pipelineName, pipelineExecutionId, abandon = NULL, reason = NULL) {
  op <- new_operation(
    name = "StopPipelineExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$stop_pipeline_execution_input(pipelineName = pipelineName, pipelineExecutionId = pipelineExecutionId, abandon = abandon, reason = reason)
  output <- .codepipeline$stop_pipeline_execution_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$stop_pipeline_execution <- codepipeline_stop_pipeline_execution

#' Adds to or modifies the tags of the given resource
#'
#' @description
#' Adds to or modifies the tags of the given resource. Tags are metadata
#' that can be used to manage a resource.
#'
#' @usage
#' codepipeline_tag_resource(resourceArn, tags)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource you want to add tags to.
#' @param tags &#91;required&#93; The tags you want to modify or add to the resource.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   resourceArn = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_tag_resource
codepipeline_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .codepipeline$tag_resource_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$tag_resource <- codepipeline_tag_resource

#' Removes tags from an AWS resource
#'
#' @description
#' Removes tags from an AWS resource.
#'
#' @usage
#' codepipeline_untag_resource(resourceArn, tagKeys)
#'
#' @param resourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to remove tags from.
#' @param tagKeys &#91;required&#93; The list of keys for the tags to be removed from the resource.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   resourceArn = "string",
#'   tagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_untag_resource
codepipeline_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .codepipeline$untag_resource_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$untag_resource <- codepipeline_untag_resource

#' Updates a specified pipeline with edits or changes to its structure
#'
#' @description
#' Updates a specified pipeline with edits or changes to its structure. Use
#' a JSON file with the pipeline structure and
#' [`update_pipeline`][codepipeline_update_pipeline] to provide the full
#' structure of the pipeline. Updating the pipeline increases the version
#' number of the pipeline by 1.
#'
#' @usage
#' codepipeline_update_pipeline(pipeline)
#'
#' @param pipeline &#91;required&#93; The name of the pipeline to be updated.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   pipeline = list(
#'     name = "string",
#'     roleArn = "string",
#'     artifactStore = list(
#'       type = "S3",
#'       location = "string",
#'       encryptionKey = list(
#'         id = "string",
#'         type = "KMS"
#'       )
#'     ),
#'     artifactStores = list(
#'       list(
#'         type = "S3",
#'         location = "string",
#'         encryptionKey = list(
#'           id = "string",
#'           type = "KMS"
#'         )
#'       )
#'     ),
#'     stages = list(
#'       list(
#'         name = "string",
#'         blockers = list(
#'           list(
#'             name = "string",
#'             type = "Schedule"
#'           )
#'         ),
#'         actions = list(
#'           list(
#'             name = "string",
#'             actionTypeId = list(
#'               category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'               owner = "AWS"|"ThirdParty"|"Custom",
#'               provider = "string",
#'               version = "string"
#'             ),
#'             runOrder = 123,
#'             configuration = list(
#'               "string"
#'             ),
#'             outputArtifacts = list(
#'               list(
#'                 name = "string"
#'               )
#'             ),
#'             inputArtifacts = list(
#'               list(
#'                 name = "string"
#'               )
#'             ),
#'             roleArn = "string",
#'             region = "string",
#'             namespace = "string"
#'           )
#'         )
#'       )
#'     ),
#'     version = 123
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_pipeline(
#'   pipeline = list(
#'     name = "string",
#'     roleArn = "string",
#'     artifactStore = list(
#'       type = "S3",
#'       location = "string",
#'       encryptionKey = list(
#'         id = "string",
#'         type = "KMS"
#'       )
#'     ),
#'     artifactStores = list(
#'       list(
#'         type = "S3",
#'         location = "string",
#'         encryptionKey = list(
#'           id = "string",
#'           type = "KMS"
#'         )
#'       )
#'     ),
#'     stages = list(
#'       list(
#'         name = "string",
#'         blockers = list(
#'           list(
#'             name = "string",
#'             type = "Schedule"
#'           )
#'         ),
#'         actions = list(
#'           list(
#'             name = "string",
#'             actionTypeId = list(
#'               category = "Source"|"Build"|"Deploy"|"Test"|"Invoke"|"Approval",
#'               owner = "AWS"|"ThirdParty"|"Custom",
#'               provider = "string",
#'               version = "string"
#'             ),
#'             runOrder = 123,
#'             configuration = list(
#'               "string"
#'             ),
#'             outputArtifacts = list(
#'               list(
#'                 name = "string"
#'               )
#'             ),
#'             inputArtifacts = list(
#'               list(
#'                 name = "string"
#'               )
#'             ),
#'             roleArn = "string",
#'             region = "string",
#'             namespace = "string"
#'           )
#'         )
#'       )
#'     ),
#'     version = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname codepipeline_update_pipeline
codepipeline_update_pipeline <- function(pipeline) {
  op <- new_operation(
    name = "UpdatePipeline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .codepipeline$update_pipeline_input(pipeline = pipeline)
  output <- .codepipeline$update_pipeline_output()
  config <- get_config()
  svc <- .codepipeline$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.codepipeline$operations$update_pipeline <- codepipeline_update_pipeline
