# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include xray_service.R
NULL

#' Retrieves a list of traces specified by ID
#'
#' @description
#' Retrieves a list of traces specified by ID. Each trace is a collection
#' of segment documents that originates from a single request. Use
#' [`get_trace_summaries`][xray_get_trace_summaries] to get a list of trace
#' IDs.
#'
#' @usage
#' xray_batch_get_traces(TraceIds, NextToken)
#'
#' @param TraceIds &#91;required&#93; Specify the trace IDs of requests for which to retrieve segments.
#' @param NextToken Pagination token.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Traces = list(
#'     list(
#'       Id = "string",
#'       Duration = 123.0,
#'       LimitExceeded = TRUE|FALSE,
#'       Segments = list(
#'         list(
#'           Id = "string",
#'           Document = "string"
#'         )
#'       )
#'     )
#'   ),
#'   UnprocessedTraceIds = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$batch_get_traces(
#'   TraceIds = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_batch_get_traces
xray_batch_get_traces <- function(TraceIds, NextToken = NULL) {
  op <- new_operation(
    name = "BatchGetTraces",
    http_method = "POST",
    http_path = "/Traces",
    paginator = list()
  )
  input <- .xray$batch_get_traces_input(TraceIds = TraceIds, NextToken = NextToken)
  output <- .xray$batch_get_traces_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$batch_get_traces <- xray_batch_get_traces

#' Creates a group resource with a name and a filter expression
#'
#' @description
#' Creates a group resource with a name and a filter expression.
#'
#' @usage
#' xray_create_group(GroupName, FilterExpression, InsightsConfiguration,
#'   Tags)
#'
#' @param GroupName &#91;required&#93; The case-sensitive name of the new group. Default is a reserved name and
#' names must be unique.
#' @param FilterExpression The filter expression defining criteria by which to group traces.
#' @param InsightsConfiguration The structure containing configurations related to insights.
#' 
#' -   The InsightsEnabled boolean can be set to true to enable insights
#'     for the new group or false to disable insights for the new group.
#' 
#' -   The NotifcationsEnabled boolean can be set to true to enable
#'     insights notifications for the new group. Notifications may only be
#'     enabled on a group with InsightsEnabled set to true.
#' @param Tags A map that contains one or more tag keys and tag values to attach to an
#' X-Ray group. For more information about ways to use tags, see [Tagging
#' AWS
#' resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
#' in the *AWS General Reference*.
#' 
#' The following restrictions apply to tags:
#' 
#' -   Maximum number of user-applied tags per resource: 50
#' 
#' -   Maximum tag key length: 128 Unicode characters
#' 
#' -   Maximum tag value length: 256 Unicode characters
#' 
#' -   Valid values for key and value: a-z, A-Z, 0-9, space, and the
#'     following characters: _ . : / = + - and @@
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Don't use `aws:` as a prefix for keys; it's reserved for AWS use.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Group = list(
#'     GroupName = "string",
#'     GroupARN = "string",
#'     FilterExpression = "string",
#'     InsightsConfiguration = list(
#'       InsightsEnabled = TRUE|FALSE,
#'       NotificationsEnabled = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_group(
#'   GroupName = "string",
#'   FilterExpression = "string",
#'   InsightsConfiguration = list(
#'     InsightsEnabled = TRUE|FALSE,
#'     NotificationsEnabled = TRUE|FALSE
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_create_group
xray_create_group <- function(GroupName, FilterExpression = NULL, InsightsConfiguration = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateGroup",
    http_method = "POST",
    http_path = "/CreateGroup",
    paginator = list()
  )
  input <- .xray$create_group_input(GroupName = GroupName, FilterExpression = FilterExpression, InsightsConfiguration = InsightsConfiguration, Tags = Tags)
  output <- .xray$create_group_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$create_group <- xray_create_group

#' Creates a rule to control sampling behavior for instrumented
#' applications
#'
#' @description
#' Creates a rule to control sampling behavior for instrumented
#' applications. Services retrieve rules with
#' [`get_sampling_rules`][xray_get_sampling_rules], and evaluate each rule
#' in ascending order of *priority* for each request. If a rule matches,
#' the service records a trace, borrowing it from the reservoir size. After
#' 10 seconds, the service reports back to X-Ray with
#' [`get_sampling_targets`][xray_get_sampling_targets] to get updated
#' versions of each in-use rule. The updated rule contains a trace quota
#' that the service can use instead of borrowing from the reservoir.
#'
#' @usage
#' xray_create_sampling_rule(SamplingRule, Tags)
#'
#' @param SamplingRule &#91;required&#93; The rule definition.
#' @param Tags A map that contains one or more tag keys and tag values to attach to an
#' X-Ray sampling rule. For more information about ways to use tags, see
#' [Tagging AWS
#' resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
#' in the *AWS General Reference*.
#' 
#' The following restrictions apply to tags:
#' 
#' -   Maximum number of user-applied tags per resource: 50
#' 
#' -   Maximum tag key length: 128 Unicode characters
#' 
#' -   Maximum tag value length: 256 Unicode characters
#' 
#' -   Valid values for key and value: a-z, A-Z, 0-9, space, and the
#'     following characters: _ . : / = + - and @@
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Don't use `aws:` as a prefix for keys; it's reserved for AWS use.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SamplingRuleRecord = list(
#'     SamplingRule = list(
#'       RuleName = "string",
#'       RuleARN = "string",
#'       ResourceARN = "string",
#'       Priority = 123,
#'       FixedRate = 123.0,
#'       ReservoirSize = 123,
#'       ServiceName = "string",
#'       ServiceType = "string",
#'       Host = "string",
#'       HTTPMethod = "string",
#'       URLPath = "string",
#'       Version = 123,
#'       Attributes = list(
#'         "string"
#'       )
#'     ),
#'     CreatedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ModifiedAt = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_sampling_rule(
#'   SamplingRule = list(
#'     RuleName = "string",
#'     RuleARN = "string",
#'     ResourceARN = "string",
#'     Priority = 123,
#'     FixedRate = 123.0,
#'     ReservoirSize = 123,
#'     ServiceName = "string",
#'     ServiceType = "string",
#'     Host = "string",
#'     HTTPMethod = "string",
#'     URLPath = "string",
#'     Version = 123,
#'     Attributes = list(
#'       "string"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_create_sampling_rule
xray_create_sampling_rule <- function(SamplingRule, Tags = NULL) {
  op <- new_operation(
    name = "CreateSamplingRule",
    http_method = "POST",
    http_path = "/CreateSamplingRule",
    paginator = list()
  )
  input <- .xray$create_sampling_rule_input(SamplingRule = SamplingRule, Tags = Tags)
  output <- .xray$create_sampling_rule_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$create_sampling_rule <- xray_create_sampling_rule

#' Deletes a group resource
#'
#' @description
#' Deletes a group resource.
#'
#' @usage
#' xray_delete_group(GroupName, GroupARN)
#'
#' @param GroupName The case-sensitive name of the group.
#' @param GroupARN The ARN of the group that was generated on creation.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_group(
#'   GroupName = "string",
#'   GroupARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_delete_group
xray_delete_group <- function(GroupName = NULL, GroupARN = NULL) {
  op <- new_operation(
    name = "DeleteGroup",
    http_method = "POST",
    http_path = "/DeleteGroup",
    paginator = list()
  )
  input <- .xray$delete_group_input(GroupName = GroupName, GroupARN = GroupARN)
  output <- .xray$delete_group_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$delete_group <- xray_delete_group

#' Deletes a sampling rule
#'
#' @description
#' Deletes a sampling rule.
#'
#' @usage
#' xray_delete_sampling_rule(RuleName, RuleARN)
#'
#' @param RuleName The name of the sampling rule. Specify a rule by either name or ARN, but
#' not both.
#' @param RuleARN The ARN of the sampling rule. Specify a rule by either name or ARN, but
#' not both.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SamplingRuleRecord = list(
#'     SamplingRule = list(
#'       RuleName = "string",
#'       RuleARN = "string",
#'       ResourceARN = "string",
#'       Priority = 123,
#'       FixedRate = 123.0,
#'       ReservoirSize = 123,
#'       ServiceName = "string",
#'       ServiceType = "string",
#'       Host = "string",
#'       HTTPMethod = "string",
#'       URLPath = "string",
#'       Version = 123,
#'       Attributes = list(
#'         "string"
#'       )
#'     ),
#'     CreatedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ModifiedAt = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_sampling_rule(
#'   RuleName = "string",
#'   RuleARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_delete_sampling_rule
xray_delete_sampling_rule <- function(RuleName = NULL, RuleARN = NULL) {
  op <- new_operation(
    name = "DeleteSamplingRule",
    http_method = "POST",
    http_path = "/DeleteSamplingRule",
    paginator = list()
  )
  input <- .xray$delete_sampling_rule_input(RuleName = RuleName, RuleARN = RuleARN)
  output <- .xray$delete_sampling_rule_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$delete_sampling_rule <- xray_delete_sampling_rule

#' Retrieves the current encryption configuration for X-Ray data
#'
#' @description
#' Retrieves the current encryption configuration for X-Ray data.
#'
#' @usage
#' xray_get_encryption_config()
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EncryptionConfig = list(
#'     KeyId = "string",
#'     Status = "UPDATING"|"ACTIVE",
#'     Type = "NONE"|"KMS"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_encryption_config()
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_encryption_config
xray_get_encryption_config <- function() {
  op <- new_operation(
    name = "GetEncryptionConfig",
    http_method = "POST",
    http_path = "/EncryptionConfig",
    paginator = list()
  )
  input <- .xray$get_encryption_config_input()
  output <- .xray$get_encryption_config_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_encryption_config <- xray_get_encryption_config

#' Retrieves group resource details
#'
#' @description
#' Retrieves group resource details.
#'
#' @usage
#' xray_get_group(GroupName, GroupARN)
#'
#' @param GroupName The case-sensitive name of the group.
#' @param GroupARN The ARN of the group that was generated on creation.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Group = list(
#'     GroupName = "string",
#'     GroupARN = "string",
#'     FilterExpression = "string",
#'     InsightsConfiguration = list(
#'       InsightsEnabled = TRUE|FALSE,
#'       NotificationsEnabled = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_group(
#'   GroupName = "string",
#'   GroupARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_group
xray_get_group <- function(GroupName = NULL, GroupARN = NULL) {
  op <- new_operation(
    name = "GetGroup",
    http_method = "POST",
    http_path = "/GetGroup",
    paginator = list()
  )
  input <- .xray$get_group_input(GroupName = GroupName, GroupARN = GroupARN)
  output <- .xray$get_group_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_group <- xray_get_group

#' Retrieves all active group details
#'
#' @description
#' Retrieves all active group details.
#'
#' @usage
#' xray_get_groups(NextToken)
#'
#' @param NextToken Pagination token.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Groups = list(
#'     list(
#'       GroupName = "string",
#'       GroupARN = "string",
#'       FilterExpression = "string",
#'       InsightsConfiguration = list(
#'         InsightsEnabled = TRUE|FALSE,
#'         NotificationsEnabled = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_groups(
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_groups
xray_get_groups <- function(NextToken = NULL) {
  op <- new_operation(
    name = "GetGroups",
    http_method = "POST",
    http_path = "/Groups",
    paginator = list()
  )
  input <- .xray$get_groups_input(NextToken = NextToken)
  output <- .xray$get_groups_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_groups <- xray_get_groups

#' Retrieves the summary information of an insight
#'
#' @description
#' Retrieves the summary information of an insight. This includes impact to
#' clients and root cause services, the top anomalous services, the
#' category, the state of the insight, and the start and end time of the
#' insight.
#'
#' @usage
#' xray_get_insight(InsightId)
#'
#' @param InsightId &#91;required&#93; The insight's unique identifier. Use the GetInsightSummaries action to
#' retrieve an InsightId.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Insight = list(
#'     InsightId = "string",
#'     GroupARN = "string",
#'     GroupName = "string",
#'     RootCauseServiceId = list(
#'       Name = "string",
#'       Names = list(
#'         "string"
#'       ),
#'       AccountId = "string",
#'       Type = "string"
#'     ),
#'     Categories = list(
#'       "FAULT"
#'     ),
#'     State = "ACTIVE"|"CLOSED",
#'     StartTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     EndTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Summary = "string",
#'     ClientRequestImpactStatistics = list(
#'       FaultCount = 123,
#'       OkCount = 123,
#'       TotalCount = 123
#'     ),
#'     RootCauseServiceRequestImpactStatistics = list(
#'       FaultCount = 123,
#'       OkCount = 123,
#'       TotalCount = 123
#'     ),
#'     TopAnomalousServices = list(
#'       list(
#'         ServiceId = list(
#'           Name = "string",
#'           Names = list(
#'             "string"
#'           ),
#'           AccountId = "string",
#'           Type = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_insight(
#'   InsightId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_insight
xray_get_insight <- function(InsightId) {
  op <- new_operation(
    name = "GetInsight",
    http_method = "POST",
    http_path = "/Insight",
    paginator = list()
  )
  input <- .xray$get_insight_input(InsightId = InsightId)
  output <- .xray$get_insight_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_insight <- xray_get_insight

#' X-Ray reevaluates insights periodically until they're resolved, and
#' records each intermediate state as an event
#'
#' @description
#' X-Ray reevaluates insights periodically until they're resolved, and
#' records each intermediate state as an event. You can review an insight's
#' events in the Impact Timeline on the Inspect page in the X-Ray console.
#'
#' @usage
#' xray_get_insight_events(InsightId, MaxResults, NextToken)
#'
#' @param InsightId &#91;required&#93; The insight's unique identifier. Use the GetInsightSummaries action to
#' retrieve an InsightId.
#' @param MaxResults Used to retrieve at most the specified value of events.
#' @param NextToken Specify the pagination token returned by a previous request to retrieve
#' the next page of events.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InsightEvents = list(
#'     list(
#'       Summary = "string",
#'       EventTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ClientRequestImpactStatistics = list(
#'         FaultCount = 123,
#'         OkCount = 123,
#'         TotalCount = 123
#'       ),
#'       RootCauseServiceRequestImpactStatistics = list(
#'         FaultCount = 123,
#'         OkCount = 123,
#'         TotalCount = 123
#'       ),
#'       TopAnomalousServices = list(
#'         list(
#'           ServiceId = list(
#'             Name = "string",
#'             Names = list(
#'               "string"
#'             ),
#'             AccountId = "string",
#'             Type = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_insight_events(
#'   InsightId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_insight_events
xray_get_insight_events <- function(InsightId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetInsightEvents",
    http_method = "POST",
    http_path = "/InsightEvents",
    paginator = list()
  )
  input <- .xray$get_insight_events_input(InsightId = InsightId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .xray$get_insight_events_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_insight_events <- xray_get_insight_events

#' Retrieves a service graph structure filtered by the specified insight
#'
#' @description
#' Retrieves a service graph structure filtered by the specified insight.
#' The service graph is limited to only structural information. For a
#' complete service graph, use this API with the GetServiceGraph API.
#'
#' @usage
#' xray_get_insight_impact_graph(InsightId, StartTime, EndTime, NextToken)
#'
#' @param InsightId &#91;required&#93; The insight's unique identifier. Use the GetInsightSummaries action to
#' retrieve an InsightId.
#' @param StartTime &#91;required&#93; The estimated start time of the insight, in Unix time seconds. The
#' StartTime is inclusive of the value provided and can't be more than 30
#' days old.
#' @param EndTime &#91;required&#93; The estimated end time of the insight, in Unix time seconds. The EndTime
#' is exclusive of the value provided. The time range between the start
#' time and end time can't be more than six hours.
#' @param NextToken Specify the pagination token returned by a previous request to retrieve
#' the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InsightId = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ServiceGraphStartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ServiceGraphEndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Services = list(
#'     list(
#'       ReferenceId = 123,
#'       Type = "string",
#'       Name = "string",
#'       Names = list(
#'         "string"
#'       ),
#'       AccountId = "string",
#'       Edges = list(
#'         list(
#'           ReferenceId = 123
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_insight_impact_graph(
#'   InsightId = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_insight_impact_graph
xray_get_insight_impact_graph <- function(InsightId, StartTime, EndTime, NextToken = NULL) {
  op <- new_operation(
    name = "GetInsightImpactGraph",
    http_method = "POST",
    http_path = "/InsightImpactGraph",
    paginator = list()
  )
  input <- .xray$get_insight_impact_graph_input(InsightId = InsightId, StartTime = StartTime, EndTime = EndTime, NextToken = NextToken)
  output <- .xray$get_insight_impact_graph_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_insight_impact_graph <- xray_get_insight_impact_graph

#' Retrieves the summaries of all insights in the specified group matching
#' the provided filter values
#'
#' @description
#' Retrieves the summaries of all insights in the specified group matching
#' the provided filter values.
#'
#' @usage
#' xray_get_insight_summaries(States, GroupARN, GroupName, StartTime,
#'   EndTime, MaxResults, NextToken)
#'
#' @param States The list of insight states.
#' @param GroupARN The Amazon Resource Name (ARN) of the group. Required if the GroupName
#' isn't provided.
#' @param GroupName The name of the group. Required if the GroupARN isn't provided.
#' @param StartTime &#91;required&#93; The beginning of the time frame in which the insights started. The start
#' time can't be more than 30 days old.
#' @param EndTime &#91;required&#93; The end of the time frame in which the insights ended. The end time
#' can't be more than 30 days old.
#' @param MaxResults The maximum number of results to display.
#' @param NextToken Pagination token.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InsightSummaries = list(
#'     list(
#'       InsightId = "string",
#'       GroupARN = "string",
#'       GroupName = "string",
#'       RootCauseServiceId = list(
#'         Name = "string",
#'         Names = list(
#'           "string"
#'         ),
#'         AccountId = "string",
#'         Type = "string"
#'       ),
#'       Categories = list(
#'         "FAULT"
#'       ),
#'       State = "ACTIVE"|"CLOSED",
#'       StartTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EndTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Summary = "string",
#'       ClientRequestImpactStatistics = list(
#'         FaultCount = 123,
#'         OkCount = 123,
#'         TotalCount = 123
#'       ),
#'       RootCauseServiceRequestImpactStatistics = list(
#'         FaultCount = 123,
#'         OkCount = 123,
#'         TotalCount = 123
#'       ),
#'       TopAnomalousServices = list(
#'         list(
#'           ServiceId = list(
#'             Name = "string",
#'             Names = list(
#'               "string"
#'             ),
#'             AccountId = "string",
#'             Type = "string"
#'           )
#'         )
#'       ),
#'       LastUpdateTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_insight_summaries(
#'   States = list(
#'     "ACTIVE"|"CLOSED"
#'   ),
#'   GroupARN = "string",
#'   GroupName = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_insight_summaries
xray_get_insight_summaries <- function(States = NULL, GroupARN = NULL, GroupName = NULL, StartTime, EndTime, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetInsightSummaries",
    http_method = "POST",
    http_path = "/InsightSummaries",
    paginator = list()
  )
  input <- .xray$get_insight_summaries_input(States = States, GroupARN = GroupARN, GroupName = GroupName, StartTime = StartTime, EndTime = EndTime, MaxResults = MaxResults, NextToken = NextToken)
  output <- .xray$get_insight_summaries_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_insight_summaries <- xray_get_insight_summaries

#' Retrieves all sampling rules
#'
#' @description
#' Retrieves all sampling rules.
#'
#' @usage
#' xray_get_sampling_rules(NextToken)
#'
#' @param NextToken Pagination token.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SamplingRuleRecords = list(
#'     list(
#'       SamplingRule = list(
#'         RuleName = "string",
#'         RuleARN = "string",
#'         ResourceARN = "string",
#'         Priority = 123,
#'         FixedRate = 123.0,
#'         ReservoirSize = 123,
#'         ServiceName = "string",
#'         ServiceType = "string",
#'         Host = "string",
#'         HTTPMethod = "string",
#'         URLPath = "string",
#'         Version = 123,
#'         Attributes = list(
#'           "string"
#'         )
#'       ),
#'       CreatedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ModifiedAt = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_sampling_rules(
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_sampling_rules
xray_get_sampling_rules <- function(NextToken = NULL) {
  op <- new_operation(
    name = "GetSamplingRules",
    http_method = "POST",
    http_path = "/GetSamplingRules",
    paginator = list()
  )
  input <- .xray$get_sampling_rules_input(NextToken = NextToken)
  output <- .xray$get_sampling_rules_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_sampling_rules <- xray_get_sampling_rules

#' Retrieves information about recent sampling results for all sampling
#' rules
#'
#' @description
#' Retrieves information about recent sampling results for all sampling
#' rules.
#'
#' @usage
#' xray_get_sampling_statistic_summaries(NextToken)
#'
#' @param NextToken Pagination token.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SamplingStatisticSummaries = list(
#'     list(
#'       RuleName = "string",
#'       Timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       RequestCount = 123,
#'       BorrowCount = 123,
#'       SampledCount = 123
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_sampling_statistic_summaries(
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_sampling_statistic_summaries
xray_get_sampling_statistic_summaries <- function(NextToken = NULL) {
  op <- new_operation(
    name = "GetSamplingStatisticSummaries",
    http_method = "POST",
    http_path = "/SamplingStatisticSummaries",
    paginator = list()
  )
  input <- .xray$get_sampling_statistic_summaries_input(NextToken = NextToken)
  output <- .xray$get_sampling_statistic_summaries_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_sampling_statistic_summaries <- xray_get_sampling_statistic_summaries

#' Requests a sampling quota for rules that the service is using to sample
#' requests
#'
#' @description
#' Requests a sampling quota for rules that the service is using to sample
#' requests.
#'
#' @usage
#' xray_get_sampling_targets(SamplingStatisticsDocuments)
#'
#' @param SamplingStatisticsDocuments &#91;required&#93; Information about rules that the service is using to sample requests.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SamplingTargetDocuments = list(
#'     list(
#'       RuleName = "string",
#'       FixedRate = 123.0,
#'       ReservoirQuota = 123,
#'       ReservoirQuotaTTL = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Interval = 123
#'     )
#'   ),
#'   LastRuleModification = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   UnprocessedStatistics = list(
#'     list(
#'       RuleName = "string",
#'       ErrorCode = "string",
#'       Message = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_sampling_targets(
#'   SamplingStatisticsDocuments = list(
#'     list(
#'       RuleName = "string",
#'       ClientID = "string",
#'       Timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       RequestCount = 123,
#'       SampledCount = 123,
#'       BorrowCount = 123
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_sampling_targets
xray_get_sampling_targets <- function(SamplingStatisticsDocuments) {
  op <- new_operation(
    name = "GetSamplingTargets",
    http_method = "POST",
    http_path = "/SamplingTargets",
    paginator = list()
  )
  input <- .xray$get_sampling_targets_input(SamplingStatisticsDocuments = SamplingStatisticsDocuments)
  output <- .xray$get_sampling_targets_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_sampling_targets <- xray_get_sampling_targets

#' Retrieves a document that describes services that process incoming
#' requests, and downstream services that they call as a result
#'
#' @description
#' Retrieves a document that describes services that process incoming
#' requests, and downstream services that they call as a result. Root
#' services process incoming requests and make calls to downstream
#' services. Root services are applications that use the [AWS X-Ray
#' SDK](https://docs.aws.amazon.com/xray/index.html). Downstream services
#' can be other applications, AWS resources, HTTP web APIs, or SQL
#' databases.
#'
#' @usage
#' xray_get_service_graph(StartTime, EndTime, GroupName, GroupARN,
#'   NextToken)
#'
#' @param StartTime &#91;required&#93; The start of the time frame for which to generate a graph.
#' @param EndTime &#91;required&#93; The end of the timeframe for which to generate a graph.
#' @param GroupName The name of a group based on which you want to generate a graph.
#' @param GroupARN The Amazon Resource Name (ARN) of a group based on which you want to
#' generate a graph.
#' @param NextToken Pagination token.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Services = list(
#'     list(
#'       ReferenceId = 123,
#'       Name = "string",
#'       Names = list(
#'         "string"
#'       ),
#'       Root = TRUE|FALSE,
#'       AccountId = "string",
#'       Type = "string",
#'       State = "string",
#'       StartTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EndTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Edges = list(
#'         list(
#'           ReferenceId = 123,
#'           StartTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           EndTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           SummaryStatistics = list(
#'             OkCount = 123,
#'             ErrorStatistics = list(
#'               ThrottleCount = 123,
#'               OtherCount = 123,
#'               TotalCount = 123
#'             ),
#'             FaultStatistics = list(
#'               OtherCount = 123,
#'               TotalCount = 123
#'             ),
#'             TotalCount = 123,
#'             TotalResponseTime = 123.0
#'           ),
#'           ResponseTimeHistogram = list(
#'             list(
#'               Value = 123.0,
#'               Count = 123
#'             )
#'           ),
#'           Aliases = list(
#'             list(
#'               Name = "string",
#'               Names = list(
#'                 "string"
#'               ),
#'               Type = "string"
#'             )
#'           )
#'         )
#'       ),
#'       SummaryStatistics = list(
#'         OkCount = 123,
#'         ErrorStatistics = list(
#'           ThrottleCount = 123,
#'           OtherCount = 123,
#'           TotalCount = 123
#'         ),
#'         FaultStatistics = list(
#'           OtherCount = 123,
#'           TotalCount = 123
#'         ),
#'         TotalCount = 123,
#'         TotalResponseTime = 123.0
#'       ),
#'       DurationHistogram = list(
#'         list(
#'           Value = 123.0,
#'           Count = 123
#'         )
#'       ),
#'       ResponseTimeHistogram = list(
#'         list(
#'           Value = 123.0,
#'           Count = 123
#'         )
#'       )
#'     )
#'   ),
#'   ContainsOldGroupVersions = TRUE|FALSE,
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_service_graph(
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   GroupName = "string",
#'   GroupARN = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_service_graph
xray_get_service_graph <- function(StartTime, EndTime, GroupName = NULL, GroupARN = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetServiceGraph",
    http_method = "POST",
    http_path = "/ServiceGraph",
    paginator = list()
  )
  input <- .xray$get_service_graph_input(StartTime = StartTime, EndTime = EndTime, GroupName = GroupName, GroupARN = GroupARN, NextToken = NextToken)
  output <- .xray$get_service_graph_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_service_graph <- xray_get_service_graph

#' Get an aggregation of service statistics defined by a specific time
#' range
#'
#' @description
#' Get an aggregation of service statistics defined by a specific time
#' range.
#'
#' @usage
#' xray_get_time_series_service_statistics(StartTime, EndTime, GroupName,
#'   GroupARN, EntitySelectorExpression, Period, ForecastStatistics,
#'   NextToken)
#'
#' @param StartTime &#91;required&#93; The start of the time frame for which to aggregate statistics.
#' @param EndTime &#91;required&#93; The end of the time frame for which to aggregate statistics.
#' @param GroupName The case-sensitive name of the group for which to pull statistics from.
#' @param GroupARN The Amazon Resource Name (ARN) of the group for which to pull statistics
#' from.
#' @param EntitySelectorExpression A filter expression defining entities that will be aggregated for
#' statistics. Supports ID, service, and edge functions. If no selector
#' expression is specified, edge statistics are returned.
#' @param Period Aggregation period in seconds.
#' @param ForecastStatistics The forecasted high and low fault count values. Forecast enabled
#' requests require the EntitySelectorExpression ID be provided.
#' @param NextToken Pagination token.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TimeSeriesServiceStatistics = list(
#'     list(
#'       Timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EdgeSummaryStatistics = list(
#'         OkCount = 123,
#'         ErrorStatistics = list(
#'           ThrottleCount = 123,
#'           OtherCount = 123,
#'           TotalCount = 123
#'         ),
#'         FaultStatistics = list(
#'           OtherCount = 123,
#'           TotalCount = 123
#'         ),
#'         TotalCount = 123,
#'         TotalResponseTime = 123.0
#'       ),
#'       ServiceSummaryStatistics = list(
#'         OkCount = 123,
#'         ErrorStatistics = list(
#'           ThrottleCount = 123,
#'           OtherCount = 123,
#'           TotalCount = 123
#'         ),
#'         FaultStatistics = list(
#'           OtherCount = 123,
#'           TotalCount = 123
#'         ),
#'         TotalCount = 123,
#'         TotalResponseTime = 123.0
#'       ),
#'       ServiceForecastStatistics = list(
#'         FaultCountHigh = 123,
#'         FaultCountLow = 123
#'       ),
#'       ResponseTimeHistogram = list(
#'         list(
#'           Value = 123.0,
#'           Count = 123
#'         )
#'       )
#'     )
#'   ),
#'   ContainsOldGroupVersions = TRUE|FALSE,
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_time_series_service_statistics(
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   GroupName = "string",
#'   GroupARN = "string",
#'   EntitySelectorExpression = "string",
#'   Period = 123,
#'   ForecastStatistics = TRUE|FALSE,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_time_series_service_statistics
xray_get_time_series_service_statistics <- function(StartTime, EndTime, GroupName = NULL, GroupARN = NULL, EntitySelectorExpression = NULL, Period = NULL, ForecastStatistics = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetTimeSeriesServiceStatistics",
    http_method = "POST",
    http_path = "/TimeSeriesServiceStatistics",
    paginator = list()
  )
  input <- .xray$get_time_series_service_statistics_input(StartTime = StartTime, EndTime = EndTime, GroupName = GroupName, GroupARN = GroupARN, EntitySelectorExpression = EntitySelectorExpression, Period = Period, ForecastStatistics = ForecastStatistics, NextToken = NextToken)
  output <- .xray$get_time_series_service_statistics_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_time_series_service_statistics <- xray_get_time_series_service_statistics

#' Retrieves a service graph for one or more specific trace IDs
#'
#' @description
#' Retrieves a service graph for one or more specific trace IDs.
#'
#' @usage
#' xray_get_trace_graph(TraceIds, NextToken)
#'
#' @param TraceIds &#91;required&#93; Trace IDs of requests for which to generate a service graph.
#' @param NextToken Pagination token.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Services = list(
#'     list(
#'       ReferenceId = 123,
#'       Name = "string",
#'       Names = list(
#'         "string"
#'       ),
#'       Root = TRUE|FALSE,
#'       AccountId = "string",
#'       Type = "string",
#'       State = "string",
#'       StartTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EndTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Edges = list(
#'         list(
#'           ReferenceId = 123,
#'           StartTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           EndTime = as.POSIXct(
#'             "2015-01-01"
#'           ),
#'           SummaryStatistics = list(
#'             OkCount = 123,
#'             ErrorStatistics = list(
#'               ThrottleCount = 123,
#'               OtherCount = 123,
#'               TotalCount = 123
#'             ),
#'             FaultStatistics = list(
#'               OtherCount = 123,
#'               TotalCount = 123
#'             ),
#'             TotalCount = 123,
#'             TotalResponseTime = 123.0
#'           ),
#'           ResponseTimeHistogram = list(
#'             list(
#'               Value = 123.0,
#'               Count = 123
#'             )
#'           ),
#'           Aliases = list(
#'             list(
#'               Name = "string",
#'               Names = list(
#'                 "string"
#'               ),
#'               Type = "string"
#'             )
#'           )
#'         )
#'       ),
#'       SummaryStatistics = list(
#'         OkCount = 123,
#'         ErrorStatistics = list(
#'           ThrottleCount = 123,
#'           OtherCount = 123,
#'           TotalCount = 123
#'         ),
#'         FaultStatistics = list(
#'           OtherCount = 123,
#'           TotalCount = 123
#'         ),
#'         TotalCount = 123,
#'         TotalResponseTime = 123.0
#'       ),
#'       DurationHistogram = list(
#'         list(
#'           Value = 123.0,
#'           Count = 123
#'         )
#'       ),
#'       ResponseTimeHistogram = list(
#'         list(
#'           Value = 123.0,
#'           Count = 123
#'         )
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_trace_graph(
#'   TraceIds = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_trace_graph
xray_get_trace_graph <- function(TraceIds, NextToken = NULL) {
  op <- new_operation(
    name = "GetTraceGraph",
    http_method = "POST",
    http_path = "/TraceGraph",
    paginator = list()
  )
  input <- .xray$get_trace_graph_input(TraceIds = TraceIds, NextToken = NextToken)
  output <- .xray$get_trace_graph_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_trace_graph <- xray_get_trace_graph

#' Retrieves IDs and annotations for traces available for a specified time
#' frame using an optional filter
#'
#' @description
#' Retrieves IDs and annotations for traces available for a specified time
#' frame using an optional filter. To get the full traces, pass the trace
#' IDs to [`batch_get_traces`][xray_batch_get_traces].
#' 
#' A filter expression can target traced requests that hit specific service
#' nodes or edges, have errors, or come from a known user. For example, the
#' following filter expression targets traces that pass through
#' `api.example.com`:
#' 
#' `service("api.example.com")`
#' 
#' This filter expression finds traces that have an annotation named
#' `account` with the value `12345`:
#' 
#' `annotation.account = "12345"`
#' 
#' For a full list of indexed fields and keywords that you can use in
#' filter expressions, see [Using Filter
#' Expressions](https://docs.aws.amazon.com/xray/latest/devguide/xray-console-filters.html)
#' in the *AWS X-Ray Developer Guide*.
#'
#' @usage
#' xray_get_trace_summaries(StartTime, EndTime, TimeRangeType, Sampling,
#'   SamplingStrategy, FilterExpression, NextToken)
#'
#' @param StartTime &#91;required&#93; The start of the time frame for which to retrieve traces.
#' @param EndTime &#91;required&#93; The end of the time frame for which to retrieve traces.
#' @param TimeRangeType A parameter to indicate whether to query trace summaries by TraceId or
#' Event time.
#' @param Sampling Set to `true` to get summaries for only a subset of available traces.
#' @param SamplingStrategy A parameter to indicate whether to enable sampling on trace summaries.
#' Input parameters are Name and Value.
#' @param FilterExpression Specify a filter expression to retrieve trace summaries for services or
#' requests that meet certain requirements.
#' @param NextToken Specify the pagination token returned by a previous request to retrieve
#' the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   TraceSummaries = list(
#'     list(
#'       Id = "string",
#'       Duration = 123.0,
#'       ResponseTime = 123.0,
#'       HasFault = TRUE|FALSE,
#'       HasError = TRUE|FALSE,
#'       HasThrottle = TRUE|FALSE,
#'       IsPartial = TRUE|FALSE,
#'       Http = list(
#'         HttpURL = "string",
#'         HttpStatus = 123,
#'         HttpMethod = "string",
#'         UserAgent = "string",
#'         ClientIp = "string"
#'       ),
#'       Annotations = list(
#'         list(
#'           list(
#'             AnnotationValue = list(
#'               NumberValue = 123.0,
#'               BooleanValue = TRUE|FALSE,
#'               StringValue = "string"
#'             ),
#'             ServiceIds = list(
#'               list(
#'                 Name = "string",
#'                 Names = list(
#'                   "string"
#'                 ),
#'                 AccountId = "string",
#'                 Type = "string"
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       Users = list(
#'         list(
#'           UserName = "string",
#'           ServiceIds = list(
#'             list(
#'               Name = "string",
#'               Names = list(
#'                 "string"
#'               ),
#'               AccountId = "string",
#'               Type = "string"
#'             )
#'           )
#'         )
#'       ),
#'       ServiceIds = list(
#'         list(
#'           Name = "string",
#'           Names = list(
#'             "string"
#'           ),
#'           AccountId = "string",
#'           Type = "string"
#'         )
#'       ),
#'       ResourceARNs = list(
#'         list(
#'           ARN = "string"
#'         )
#'       ),
#'       InstanceIds = list(
#'         list(
#'           Id = "string"
#'         )
#'       ),
#'       AvailabilityZones = list(
#'         list(
#'           Name = "string"
#'         )
#'       ),
#'       EntryPoint = list(
#'         Name = "string",
#'         Names = list(
#'           "string"
#'         ),
#'         AccountId = "string",
#'         Type = "string"
#'       ),
#'       FaultRootCauses = list(
#'         list(
#'           Services = list(
#'             list(
#'               Name = "string",
#'               Names = list(
#'                 "string"
#'               ),
#'               Type = "string",
#'               AccountId = "string",
#'               EntityPath = list(
#'                 list(
#'                   Name = "string",
#'                   Exceptions = list(
#'                     list(
#'                       Name = "string",
#'                       Message = "string"
#'                     )
#'                   ),
#'                   Remote = TRUE|FALSE
#'                 )
#'               ),
#'               Inferred = TRUE|FALSE
#'             )
#'           ),
#'           ClientImpacting = TRUE|FALSE
#'         )
#'       ),
#'       ErrorRootCauses = list(
#'         list(
#'           Services = list(
#'             list(
#'               Name = "string",
#'               Names = list(
#'                 "string"
#'               ),
#'               Type = "string",
#'               AccountId = "string",
#'               EntityPath = list(
#'                 list(
#'                   Name = "string",
#'                   Exceptions = list(
#'                     list(
#'                       Name = "string",
#'                       Message = "string"
#'                     )
#'                   ),
#'                   Remote = TRUE|FALSE
#'                 )
#'               ),
#'               Inferred = TRUE|FALSE
#'             )
#'           ),
#'           ClientImpacting = TRUE|FALSE
#'         )
#'       ),
#'       ResponseTimeRootCauses = list(
#'         list(
#'           Services = list(
#'             list(
#'               Name = "string",
#'               Names = list(
#'                 "string"
#'               ),
#'               Type = "string",
#'               AccountId = "string",
#'               EntityPath = list(
#'                 list(
#'                   Name = "string",
#'                   Coverage = 123.0,
#'                   Remote = TRUE|FALSE
#'                 )
#'               ),
#'               Inferred = TRUE|FALSE
#'             )
#'           ),
#'           ClientImpacting = TRUE|FALSE
#'         )
#'       ),
#'       Revision = 123,
#'       MatchedEventTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   ApproximateTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   TracesProcessedCount = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$get_trace_summaries(
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   TimeRangeType = "TraceId"|"Event",
#'   Sampling = TRUE|FALSE,
#'   SamplingStrategy = list(
#'     Name = "PartialScan"|"FixedRate",
#'     Value = 123.0
#'   ),
#'   FilterExpression = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_get_trace_summaries
xray_get_trace_summaries <- function(StartTime, EndTime, TimeRangeType = NULL, Sampling = NULL, SamplingStrategy = NULL, FilterExpression = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetTraceSummaries",
    http_method = "POST",
    http_path = "/TraceSummaries",
    paginator = list()
  )
  input <- .xray$get_trace_summaries_input(StartTime = StartTime, EndTime = EndTime, TimeRangeType = TimeRangeType, Sampling = Sampling, SamplingStrategy = SamplingStrategy, FilterExpression = FilterExpression, NextToken = NextToken)
  output <- .xray$get_trace_summaries_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$get_trace_summaries <- xray_get_trace_summaries

#' Returns a list of tags that are applied to the specified AWS X-Ray group
#' or sampling rule
#'
#' @description
#' Returns a list of tags that are applied to the specified AWS X-Ray group
#' or sampling rule.
#'
#' @usage
#' xray_list_tags_for_resource(ResourceARN, NextToken)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.
#' @param NextToken A pagination token. If multiple pages of results are returned, use the
#' `NextToken` value returned with the current page of results as the value
#' of this parameter to get the next page of results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_list_tags_for_resource
xray_list_tags_for_resource <- function(ResourceARN, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/ListTagsForResource",
    paginator = list()
  )
  input <- .xray$list_tags_for_resource_input(ResourceARN = ResourceARN, NextToken = NextToken)
  output <- .xray$list_tags_for_resource_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$list_tags_for_resource <- xray_list_tags_for_resource

#' Updates the encryption configuration for X-Ray data
#'
#' @description
#' Updates the encryption configuration for X-Ray data.
#'
#' @usage
#' xray_put_encryption_config(KeyId, Type)
#'
#' @param KeyId An AWS KMS customer master key (CMK) in one of the following formats:
#' 
#' -   **Alias** - The name of the key. For example, `alias/MyKey`.
#' 
#' -   **Key ID** - The KMS key ID of the key. For example,
#'     `ae4aa6d49-a4d8-9df9-a475-4ff6d7898456`. AWS X-Ray does not support
#'     asymmetric CMKs.
#' 
#' -   **ARN** - The full Amazon Resource Name of the key ID or alias. For
#'     example,
#'     `arn:aws:kms:us-east-2:123456789012:key/ae4aa6d49-a4d8-9df9-a475-4ff6d7898456`.
#'     Use this format to specify a key in a different account.
#' 
#' Omit this key if you set `Type` to `NONE`.
#' @param Type &#91;required&#93; The type of encryption. Set to `KMS` to use your own key for encryption.
#' Set to `NONE` for default encryption.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EncryptionConfig = list(
#'     KeyId = "string",
#'     Status = "UPDATING"|"ACTIVE",
#'     Type = "NONE"|"KMS"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_encryption_config(
#'   KeyId = "string",
#'   Type = "NONE"|"KMS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_put_encryption_config
xray_put_encryption_config <- function(KeyId = NULL, Type) {
  op <- new_operation(
    name = "PutEncryptionConfig",
    http_method = "POST",
    http_path = "/PutEncryptionConfig",
    paginator = list()
  )
  input <- .xray$put_encryption_config_input(KeyId = KeyId, Type = Type)
  output <- .xray$put_encryption_config_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$put_encryption_config <- xray_put_encryption_config

#' Used by the AWS X-Ray daemon to upload telemetry
#'
#' @description
#' Used by the AWS X-Ray daemon to upload telemetry.
#'
#' @usage
#' xray_put_telemetry_records(TelemetryRecords, EC2InstanceId, Hostname,
#'   ResourceARN)
#'
#' @param TelemetryRecords &#91;required&#93; 
#' @param EC2InstanceId 
#' @param Hostname 
#' @param ResourceARN 
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$put_telemetry_records(
#'   TelemetryRecords = list(
#'     list(
#'       Timestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       SegmentsReceivedCount = 123,
#'       SegmentsSentCount = 123,
#'       SegmentsSpilloverCount = 123,
#'       SegmentsRejectedCount = 123,
#'       BackendConnectionErrors = list(
#'         TimeoutCount = 123,
#'         ConnectionRefusedCount = 123,
#'         HTTPCode4XXCount = 123,
#'         HTTPCode5XXCount = 123,
#'         UnknownHostCount = 123,
#'         OtherCount = 123
#'       )
#'     )
#'   ),
#'   EC2InstanceId = "string",
#'   Hostname = "string",
#'   ResourceARN = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_put_telemetry_records
xray_put_telemetry_records <- function(TelemetryRecords, EC2InstanceId = NULL, Hostname = NULL, ResourceARN = NULL) {
  op <- new_operation(
    name = "PutTelemetryRecords",
    http_method = "POST",
    http_path = "/TelemetryRecords",
    paginator = list()
  )
  input <- .xray$put_telemetry_records_input(TelemetryRecords = TelemetryRecords, EC2InstanceId = EC2InstanceId, Hostname = Hostname, ResourceARN = ResourceARN)
  output <- .xray$put_telemetry_records_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$put_telemetry_records <- xray_put_telemetry_records

#' Uploads segment documents to AWS X-Ray
#'
#' @description
#' Uploads segment documents to AWS X-Ray. The [X-Ray
#' SDK](https://docs.aws.amazon.com/xray/index.html) generates segment
#' documents and sends them to the X-Ray daemon, which uploads them in
#' batches. A segment document can be a completed segment, an in-progress
#' segment, or an array of subsegments.
#' 
#' Segments must include the following fields. For the full segment
#' document schema, see [AWS X-Ray Segment
#' Documents](https://docs.aws.amazon.com/xray/latest/devguide/xray-api-segmentdocuments.html)
#' in the *AWS X-Ray Developer Guide*.
#' 
#' **Required segment document fields**
#' 
#' -   `name` - The name of the service that handled the request.
#' 
#' -   `id` - A 64-bit identifier for the segment, unique among segments in
#'     the same trace, in 16 hexadecimal digits.
#' 
#' -   `trace_id` - A unique identifier that connects all segments and
#'     subsegments originating from a single client request.
#' 
#' -   `start_time` - Time the segment or subsegment was created, in
#'     floating point seconds in epoch time, accurate to milliseconds. For
#'     example, `1480615200.010` or `1.480615200010E9`.
#' 
#' -   `end_time` - Time the segment or subsegment was closed. For example,
#'     `1480615200.090` or `1.480615200090E9`. Specify either an `end_time`
#'     or `in_progress`.
#' 
#' -   `in_progress` - Set to `true` instead of specifying an `end_time` to
#'     record that a segment has been started, but is not complete. Send an
#'     in-progress segment when your application receives a request that
#'     will take a long time to serve, to trace that the request was
#'     received. When the response is sent, send the complete segment to
#'     overwrite the in-progress segment.
#' 
#' A `trace_id` consists of three numbers separated by hyphens. For
#' example, 1-58406520-a006649127e371903a2de979. This includes:
#' 
#' **Trace ID Format**
#' 
#' -   The version number, for instance, `1`.
#' 
#' -   The time of the original request, in Unix epoch time, in 8
#'     hexadecimal digits. For example, 10:00AM December 2nd, 2016 PST in
#'     epoch time is `1480615200` seconds, or `58406520` in hexadecimal.
#' 
#' -   A 96-bit identifier for the trace, globally unique, in 24
#'     hexadecimal digits.
#'
#' @usage
#' xray_put_trace_segments(TraceSegmentDocuments)
#'
#' @param TraceSegmentDocuments &#91;required&#93; A string containing a JSON document defining one or more segments or
#' subsegments.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   UnprocessedTraceSegments = list(
#'     list(
#'       Id = "string",
#'       ErrorCode = "string",
#'       Message = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$put_trace_segments(
#'   TraceSegmentDocuments = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_put_trace_segments
xray_put_trace_segments <- function(TraceSegmentDocuments) {
  op <- new_operation(
    name = "PutTraceSegments",
    http_method = "POST",
    http_path = "/TraceSegments",
    paginator = list()
  )
  input <- .xray$put_trace_segments_input(TraceSegmentDocuments = TraceSegmentDocuments)
  output <- .xray$put_trace_segments_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$put_trace_segments <- xray_put_trace_segments

#' Applies tags to an existing AWS X-Ray group or sampling rule
#'
#' @description
#' Applies tags to an existing AWS X-Ray group or sampling rule.
#'
#' @usage
#' xray_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.
#' @param Tags &#91;required&#93; A map that contains one or more tag keys and tag values to attach to an
#' X-Ray group or sampling rule. For more information about ways to use
#' tags, see [Tagging AWS
#' resources](https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html)
#' in the *AWS General Reference*.
#' 
#' The following restrictions apply to tags:
#' 
#' -   Maximum number of user-applied tags per resource: 50
#' 
#' -   Maximum tag key length: 128 Unicode characters
#' 
#' -   Maximum tag value length: 256 Unicode characters
#' 
#' -   Valid values for key and value: a-z, A-Z, 0-9, space, and the
#'     following characters: _ . : / = + - and @@
#' 
#' -   Tag keys and values are case sensitive.
#' 
#' -   Don't use `aws:` as a prefix for keys; it's reserved for AWS use.
#'     You cannot edit or delete system tags.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_tag_resource
xray_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/TagResource",
    paginator = list()
  )
  input <- .xray$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .xray$tag_resource_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$tag_resource <- xray_tag_resource

#' Removes tags from an AWS X-Ray group or sampling rule
#'
#' @description
#' Removes tags from an AWS X-Ray group or sampling rule. You cannot edit
#' or delete system tags (those with an `aws:` prefix).
#'
#' @usage
#' xray_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Number (ARN) of an X-Ray group or sampling rule.
#' @param TagKeys &#91;required&#93; Keys for one or more tags that you want to remove from an X-Ray group or
#' sampling rule.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_untag_resource
xray_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/UntagResource",
    paginator = list()
  )
  input <- .xray$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .xray$untag_resource_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$untag_resource <- xray_untag_resource

#' Updates a group resource
#'
#' @description
#' Updates a group resource.
#'
#' @usage
#' xray_update_group(GroupName, GroupARN, FilterExpression,
#'   InsightsConfiguration)
#'
#' @param GroupName The case-sensitive name of the group.
#' @param GroupARN The ARN that was generated upon creation.
#' @param FilterExpression The updated filter expression defining criteria by which to group
#' traces.
#' @param InsightsConfiguration The structure containing configurations related to insights.
#' 
#' -   The InsightsEnabled boolean can be set to true to enable insights
#'     for the group or false to disable insights for the group.
#' 
#' -   The NotifcationsEnabled boolean can be set to true to enable
#'     insights notifications for the group. Notifications can only be
#'     enabled on a group with InsightsEnabled set to true.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Group = list(
#'     GroupName = "string",
#'     GroupARN = "string",
#'     FilterExpression = "string",
#'     InsightsConfiguration = list(
#'       InsightsEnabled = TRUE|FALSE,
#'       NotificationsEnabled = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_group(
#'   GroupName = "string",
#'   GroupARN = "string",
#'   FilterExpression = "string",
#'   InsightsConfiguration = list(
#'     InsightsEnabled = TRUE|FALSE,
#'     NotificationsEnabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_update_group
xray_update_group <- function(GroupName = NULL, GroupARN = NULL, FilterExpression = NULL, InsightsConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateGroup",
    http_method = "POST",
    http_path = "/UpdateGroup",
    paginator = list()
  )
  input <- .xray$update_group_input(GroupName = GroupName, GroupARN = GroupARN, FilterExpression = FilterExpression, InsightsConfiguration = InsightsConfiguration)
  output <- .xray$update_group_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$update_group <- xray_update_group

#' Modifies a sampling rule's configuration
#'
#' @description
#' Modifies a sampling rule's configuration.
#'
#' @usage
#' xray_update_sampling_rule(SamplingRuleUpdate)
#'
#' @param SamplingRuleUpdate &#91;required&#93; The rule and fields to change.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SamplingRuleRecord = list(
#'     SamplingRule = list(
#'       RuleName = "string",
#'       RuleARN = "string",
#'       ResourceARN = "string",
#'       Priority = 123,
#'       FixedRate = 123.0,
#'       ReservoirSize = 123,
#'       ServiceName = "string",
#'       ServiceType = "string",
#'       Host = "string",
#'       HTTPMethod = "string",
#'       URLPath = "string",
#'       Version = 123,
#'       Attributes = list(
#'         "string"
#'       )
#'     ),
#'     CreatedAt = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ModifiedAt = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_sampling_rule(
#'   SamplingRuleUpdate = list(
#'     RuleName = "string",
#'     RuleARN = "string",
#'     ResourceARN = "string",
#'     Priority = 123,
#'     FixedRate = 123.0,
#'     ReservoirSize = 123,
#'     Host = "string",
#'     ServiceName = "string",
#'     ServiceType = "string",
#'     HTTPMethod = "string",
#'     URLPath = "string",
#'     Attributes = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname xray_update_sampling_rule
xray_update_sampling_rule <- function(SamplingRuleUpdate) {
  op <- new_operation(
    name = "UpdateSamplingRule",
    http_method = "POST",
    http_path = "/UpdateSamplingRule",
    paginator = list()
  )
  input <- .xray$update_sampling_rule_input(SamplingRuleUpdate = SamplingRuleUpdate)
  output <- .xray$update_sampling_rule_output()
  config <- get_config()
  svc <- .xray$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.xray$operations$update_sampling_rule <- xray_update_sampling_rule
