% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codebuild_operations.R
\name{codebuild_import_source_credentials}
\alias{codebuild_import_source_credentials}
\title{Imports the source repository credentials for an AWS CodeBuild project
that has its source code stored in a GitHub, GitHub Enterprise, or
Bitbucket repository}
\usage{
codebuild_import_source_credentials(username, token, serverType,
  authType, shouldOverwrite)
}
\arguments{
\item{username}{The Bitbucket username when the \code{authType} is BASIC_AUTH. This
parameter is not valid for other types of source providers or
connections.}

\item{token}{[required] For GitHub or GitHub Enterprise, this is the personal access token. For
Bitbucket, this is the app password.}

\item{serverType}{[required] The source provider used for this project.}

\item{authType}{[required] The type of authentication used to connect to a GitHub, GitHub
Enterprise, or Bitbucket repository. An OAUTH connection is not
supported by the API and must be created using the AWS CodeBuild
console.}

\item{shouldOverwrite}{Set to \code{false} to prevent overwriting the repository source credentials.
Set to \code{true} to overwrite the repository source credentials. The
default value is \code{true}.}
}
\value{
A list with the following syntax:\preformatted{list(
  arn = "string"
)
}
}
\description{
Imports the source repository credentials for an AWS CodeBuild project
that has its source code stored in a GitHub, GitHub Enterprise, or
Bitbucket repository.
}
\section{Request syntax}{
\preformatted{svc$import_source_credentials(
  username = "string",
  token = "string",
  serverType = "GITHUB"|"BITBUCKET"|"GITHUB_ENTERPRISE",
  authType = "OAUTH"|"BASIC_AUTH"|"PERSONAL_ACCESS_TOKEN",
  shouldOverwrite = TRUE|FALSE
)
}
}

\keyword{internal}
