% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codecommit_operations.R
\name{codecommit_get_comment}
\alias{codecommit_get_comment}
\title{Returns the content of a comment made on a change, file, or commit in a
repository}
\usage{
codecommit_get_comment(commentId)
}
\arguments{
\item{commentId}{[required] The unique, system-generated ID of the comment. To get this ID, use
\code{\link[=codecommit_get_comments_for_compared_commit]{get_comments_for_compared_commit}}
or
\code{\link[=codecommit_get_comments_for_pull_request]{get_comments_for_pull_request}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  comment = list(
    commentId = "string",
    content = "string",
    inReplyTo = "string",
    creationDate = as.POSIXct(
      "2015-01-01"
    ),
    lastModifiedDate = as.POSIXct(
      "2015-01-01"
    ),
    authorArn = "string",
    deleted = TRUE|FALSE,
    clientRequestToken = "string",
    callerReactions = list(
      "string"
    ),
    reactionCounts = list(
      123
    )
  )
)
}
}
\description{
Returns the content of a comment made on a change, file, or commit in a
repository.

Reaction counts might include numbers from user identities who were
deleted after the reaction was made. For a count of reactions from
active identities, use GetCommentReactions.
}
\section{Request syntax}{
\preformatted{svc$get_comment(
  commentId = "string"
)
}
}

\keyword{internal}
