% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codedeploy_operations.R
\name{codedeploy_batch_get_applications}
\alias{codedeploy_batch_get_applications}
\title{Gets information about one or more applications}
\usage{
codedeploy_batch_get_applications(applicationNames)
}
\arguments{
\item{applicationNames}{[required] A list of application names separated by spaces. The maximum number of
application names you can specify is 100.}
}
\value{
A list with the following syntax:\preformatted{list(
  applicationsInfo = list(
    list(
      applicationId = "string",
      applicationName = "string",
      createTime = as.POSIXct(
        "2015-01-01"
      ),
      linkedToGitHub = TRUE|FALSE,
      gitHubAccountName = "string",
      computePlatform = "Server"|"Lambda"|"ECS"
    )
  )
)
}
}
\description{
Gets information about one or more applications. The maximum number of
applications that can be returned is 100.
}
\section{Request syntax}{
\preformatted{svc$batch_get_applications(
  applicationNames = list(
    "string"
  )
)
}
}

\keyword{internal}
