% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codestar_operations.R
\name{codestar_disassociate_team_member}
\alias{codestar_disassociate_team_member}
\title{Removes a user from a project}
\usage{
codestar_disassociate_team_member(projectId, userArn)
}
\arguments{
\item{projectId}{[required] The ID of the AWS CodeStar project from which you want to remove a team
member.}

\item{userArn}{[required] The Amazon Resource Name (ARN) of the IAM user or group whom you want to
remove from the project.}
}
\value{
An empty list.
}
\description{
Removes a user from a project. Removing a user from a project also
removes the IAM policies from that user that allowed access to the
project and its resources. Disassociating a team member does not remove
that user's profile from AWS CodeStar. It does not remove the user from
IAM.
}
\section{Request syntax}{
\preformatted{svc$disassociate_team_member(
  projectId = "string",
  userArn = "string"
)
}
}

\keyword{internal}
