% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worklink_operations.R
\name{worklink_list_domains}
\alias{worklink_list_domains}
\title{Retrieves a list of domains associated to a specified fleet}
\usage{
worklink_list_domains(FleetArn, NextToken, MaxResults)
}
\arguments{
\item{FleetArn}{[required] The ARN of the fleet.}

\item{NextToken}{The pagination token used to retrieve the next page of results for this
operation. If this value is null, it retrieves the first page.}

\item{MaxResults}{The maximum number of results to be included in the next page.}
}
\value{
A list with the following syntax:\preformatted{list(
  Domains = list(
    list(
      DomainName = "string",
      DisplayName = "string",
      CreatedTime = as.POSIXct(
        "2015-01-01"
      ),
      DomainStatus = "PENDING_VALIDATION"|"ASSOCIATING"|"ACTIVE"|"INACTIVE"|"DISASSOCIATING"|"DISASSOCIATED"|"FAILED_TO_ASSOCIATE"|"FAILED_TO_DISASSOCIATE"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a list of domains associated to a specified fleet.
}
\section{Request syntax}{
\preformatted{svc$list_domains(
  FleetArn = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
