% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/worklink_operations.R
\name{worklink_list_website_authorization_providers}
\alias{worklink_list_website_authorization_providers}
\title{Retrieves a list of website authorization providers associated with a
specified fleet}
\usage{
worklink_list_website_authorization_providers(FleetArn, NextToken,
  MaxResults)
}
\arguments{
\item{FleetArn}{[required] The ARN of the fleet.}

\item{NextToken}{The pagination token to use to retrieve the next page of results for
this operation. If this value is null, it retrieves the first page.}

\item{MaxResults}{The maximum number of results to be included in the next page.}
}
\value{
A list with the following syntax:\preformatted{list(
  WebsiteAuthorizationProviders = list(
    list(
      AuthorizationProviderId = "string",
      AuthorizationProviderType = "SAML",
      DomainName = "string",
      CreatedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a list of website authorization providers associated with a
specified fleet.
}
\section{Request syntax}{
\preformatted{svc$list_website_authorization_providers(
  FleetArn = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
