% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_create_dataset}
\alias{personalize_create_dataset}
\title{Creates an empty dataset and adds it to the specified dataset group}
\usage{
personalize_create_dataset(name, schemaArn, datasetGroupArn,
  datasetType)
}
\arguments{
\item{name}{[required] The name for the dataset.}

\item{schemaArn}{[required] The ARN of the schema to associate with the dataset. The schema defines
the dataset fields.}

\item{datasetGroupArn}{[required] The Amazon Resource Name (ARN) of the dataset group to add the dataset
to.}

\item{datasetType}{[required] The type of dataset.

One of the following (case insensitive) values:
\itemize{
\item Interactions
\item Items
\item Users
}}
}
\value{
A list with the following syntax:\preformatted{list(
  datasetArn = "string"
)
}
}
\description{
Creates an empty dataset and adds it to the specified dataset group. Use
\code{\link[=personalize_create_dataset_import_job]{create_dataset_import_job}} to
import your training data to a dataset.

There are three types of datasets:
\itemize{
\item Interactions
\item Items
\item Users
}

Each dataset type has an associated schema with required field types.
Only the \code{Interactions} dataset is required in order to train a model
(also referred to as creating a solution).

A dataset can be in one of the following states:
\itemize{
\item CREATE PENDING > CREATE IN_PROGRESS > ACTIVE -or- CREATE
FAILED
\item DELETE PENDING > DELETE IN_PROGRESS
}

To get the status of the dataset, call
\code{\link[=personalize_describe_dataset]{describe_dataset}}.

\strong{Related APIs}
\itemize{
\item \code{\link[=personalize_create_dataset_group]{create_dataset_group}}
\item \code{\link[=personalize_list_datasets]{list_datasets}}
\item \code{\link[=personalize_describe_dataset]{describe_dataset}}
\item \code{\link[=personalize_delete_dataset]{delete_dataset}}
}
}
\section{Request syntax}{
\preformatted{svc$create_dataset(
  name = "string",
  schemaArn = "string",
  datasetGroupArn = "string",
  datasetType = "string"
)
}
}

\keyword{internal}
